<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 */
require_once "config.php";
security();

//Datumausgabe
function datum($eingabe, $farbe) {

	if (!is_numeric($eingabe) || $eingabe<1 ) {
		$res = '<img src="img/b5.gif" title="'.text('admin_age_5').'">';

	} else {

		$diff = mktime()-$eingabe;
		if ($diff < (86400*3)) {
			$res = '<img src="img/b1.gif" title="'.text('admin_age_1').'
'.strftime(text('admin_age'),$eingabe).'">';
		} elseif ($diff < (86400*5)) {
			$res = '<img src="img/b2.gif" title="'.text('admin_age_2').'
'.strftime(text('admin_age'),$eingabe).'">';
		} elseif ($diff < (86400*7)) {
			$res = '<img src="img/b3.gif" title="'.text('admin_age_3').'
'.strftime(text('admin_age'),$eingabe).'">';
		} elseif ($diff < (86400*14)) {
			$res = '<img src="img/b4.gif" title="'.text('admin_age_4').'
'.strftime(text('admin_age'),$eingabe).'">';
		} else {
			$res = '<img src="img/b5.gif" title="'.text('admin_age_5').'
'.strftime(text('admin_age'),$eingabe).'">';
		}
	}

	return "<td{$farbe}>".$res."</td>";
}

//Summenberechnung
  function truppensum($volk)
  {
	global $sid;
	$allowed_sids = get_allowed_sids($sid, "s.");
  	$sql="SELECT
            sum(t.t1), sum(t.t2), sum(t.t3), sum(t.t4), sum(t.t5), sum(t.t6), sum(t.t7), sum(t.t8), sum(t.t9), sum(t.t10)
          FROM
		    ".PREFIX."truppen t,
		    ".PREFIX."spieler s
          WHERE
		    s.volk='".$volk."' AND
		    s.sid = t.sid AND
			(".$allowed_sids.")"; // ****** RISI added:      AND(".$allowed_sids.")
	$result = mysql_query($sql) OR die(mysql_error());
	$row    = mysql_fetch_assoc($result);
	$return = "";
	for ($i=1; $i<=10; $i++) {
		$return .= "<td class=\"footer\">".zero($row['sum(t.t'.$i.')'])."</td>";
	}
	return $return;
  }

  //Truppenheader
  function write_table_header($volk)
  {
  	$return = "";
  	for ($i=1; $i<=10; $i++) {
  		$return .= "<td class=\"header2\"><img src=\"".img_pfad($volk, $i)."\" title=\"".text('t_'.$volk.$i)."\" alt=\"".text('t_'.$volk.$i)."\"></td>";
  	}

  	return $return;
  }

  // @since 2007/11/02 Moonie fixed bug that inactive heroes are not shown up anymore
  function num_hero($spielerid)
  {
  	$sql = "SELECT
  	          COUNT(id) AS anzahl
  	        FROM
  	          ".PREFIX."hero
  	        WHERE
			  sid LIKE '".$spielerid."' AND
			  active=1";
  	$result = mysql_query($sql) OR die(mysql_error());
  	$row    = mysql_fetch_assoc($result);

  	return zero($row['anzahl']);
  }





write_header(text('admin_header'))
?>

<div class="oben"><?php include "oben.php"; ?></div>

<div class="menu"><?php include "menu.php"; ?></div>

<div class="mitte2" align="center">

<?php
    if(is_he_admin($sid)) :
        $sql = "SELECT id, name FROM ".PREFIX."groups";
        $result = mysql_query($sql) OR die(mysql_error());
        $selected_default = "selected='selected'";
        while($row = mysql_fetch_assoc($result)) {
            $selected = ($_POST['group'] == $row['id']) ? "selected='selected'"
: "";
            if($selected != "") $selected_default = "";
            $options .= "<option value='" . $row['id'] . "' " . $selected . ">"
. $row['name'] . "</option>
            ";
        }

?>
    <form method = "POST" action="<?php echo $_SERVER['PHP_SELF']; ?>"
id="select_group">
        <select name="group"
onchange="document.getElementById('select_group').submit();">
            <?php echo $options; ?>
            <option value="" <?php echo $selected_default ?> ><?php
echo text("all_groups"); ?></option>
        </select>
    </form>
    <br/>
<?php endif; ?>

<table class="itable" cellpadding="2" cellspacing="1">
	<tr>
		<td class="header1" colspan="<?php echo check_t3(36 , 34)?>"><?php echo text('admin_header')?></td>
	</tr>
	<tr>
		<td class="header2" rowspan="2"><a href="admin.php?sort=lastchange" title="<?php echo text('admin_sort')?> <?php echo text('admin_lastchange')?>"><img src="img/clock.gif"></a></td>
        <td class="header2" rowspan="2"><a href="admin.php?sort=spieler" title="<?php echo text('admin_sort')?> <?php echo text('admin_player')?>"><?php echo text('admin_player')?></a></td>
		<td class="header2" colspan="10"><?php echo text('volk_rom')?></td>
		<td class="header2" width="0" rowspan="2"></td>
		<td class="header2" colspan="10"><?php echo text('volk_ger')?></td>
		<td class="header2" width="0" rowspan="2"></td>
		<td class="header2" colspan="10"><?php echo text('volk_gal')?></td>
		<?php echo check_t3('<td class="header2" width="0" rowspan="2"></td><td class="header2" rowspan="2" valign="bottom"><img src="img/hero.gif"></td>')?>
	</tr>
    <tr>
<?php
  echo write_table_header('rom');
  echo write_table_header('ger');
  echo write_table_header('gal');
?>
    </tr>
	<tr>
	  <td height="4" colspan="<?php echo check_t3(36 , 34)?>"></td>
	</tr>
<?php
  //Sortierfunktion
  if (isset($_GET['sort'])) {
  	//w�hlt zwischen den verschiedenen Sortierungsm�glichkeiten:
  	switch($_GET['sort']) {
  		case "spieler":
  		  //wenn vorher aufw�rts sortiert wurde, wird jetzt abw�rts sortiert
  		  //wenn vorher abw�rts sortiert wurde, wird jetzt aufw�rts sortiert
  		  //wenn vorher nach einem anderen Eintrag sortiert wurde, wird jetzt aufw�rts sortiert
  		  if (substr($_SESSION[INSTANCE_KEY]['sort'], 5) == "ASC") {
  		  	$_SESSION[INSTANCE_KEY]['sort']="name DESC";
  		  } else {
  		  	$_SESSION[INSTANCE_KEY]['sort']="name ASC";
  		  }
  		  break;
  		case "lastchange":
  		  //wenn vorher aufw�rts sortiert wurde, wird jetzt abw�rts sortiert
  		  //wenn vorher abw�rts sortiert wurde, wird jetzt aufw�rts sortiert
  		  //wenn vorher nach einem anderen Eintrag sortiert wurde, wird jetzt aufw�rts sortiert
  		  if (substr($_SESSION[INSTANCE_KEY]['sort'], 11) == "DESC") {
  		  	$_SESSION[INSTANCE_KEY]['sort']="lastchange ASC";
  		  } else {
  		  	$_SESSION[INSTANCE_KEY]['sort']="lastchange DESC";
  		  }
  		  break;
  	}
  } else {
  	//Standartsortierung
  	$_SESSION[INSTANCE_KEY]['sort']="name ASC";
  }

  /*************************** risi altered this. Only members of the
admins group (id=0) can see all.*/

	$allowed_sids = get_allowed_sids($sid);
	  $sql="SELECT
	          sid,
	          name,
	          volk,
	          rechte,
	          UNIX_TIMESTAMP(lastchange) AS lastchange
	        FROM
	          ".PREFIX."spieler
	        WHERE
	          aktiv='1'
			  AND
			  (".$allowed_sids.")
			ORDER BY
			  ".$_SESSION[INSTANCE_KEY]['sort']."";

	/***************************end**************************/


  $result = mysql_query($sql) OR die(mysql_error());
  $zeile=0;
  while ($row = mysql_fetch_assoc($result)) {
  	//Zeilenfarbe
  	$zeile++;
  	if(($zeile%2)==0) {
  		$farbe=" class=\"zeile2\"";
  	} else {
  		$farbe=" class=\"zeile1\"";
  	}
  	//jeder Spieler bekommt seine eigene Zeile
  	echo "<tr>";
  	//Ausgabe des Datums
  	echo datum($row['lastchange'], $farbe);
  	//Spielername
  	//Statistik bei Mousover nur anzeigen, wenn Spieler das Recht dazu hat
  	if ($rechte[3]=="2") echo "<td".$farbe."><a href=\"showtroops.php?spieler=".urlencode($row['name'])."\" onmouseover=\"return overlib('<img src=\'image.php?u=".urlencode($row['name'])."\' alt=\'".$row['name']."\' border=\'0\' style=\'margin:0px;\'>');\" onmouseout=\"return nd();\">".$row['name']."</a>".contact_member($row['name'])."</td>";
  	else echo "<td".$farbe."><a href=\"showtroops.php?spieler=".urlencode($row['name'])."&\">".$row['name']."</a>".contact_member($row['name'])."</td>";

  	//Truppenquery
  	$sqltruppen="SELECT
  	         sum(t1), sum(t2), sum(t3), sum(t4), sum(t5), sum(t6), sum(t7), sum(t8), sum(t9), sum(t10)
  	       FROM
  	         ".PREFIX."truppen
  	       WHERE
  	         sid='".$row['sid']."'";
  	$resulttruppen = mysql_query($sqltruppen) OR die(mysql_error());
  	$rowtruppen = mysql_fetch_assoc($resulttruppen);
  	//definiert $nix. (10 Zellen mit 0)
  	$nix="";
  	for ($i=1; $i<=10; $i++) {
  		$nix.="<td".$farbe.">".zero(0)."</td>";
  	}
  	//definiert $truppen (10 Zellen mit der entsprechenden Truppenzahl)
  	$truppen="";
  	for ($i=1; $i<=10; $i++) {
  		$truppen.="<td".$farbe.">".zero($rowtruppen['sum(t'.$i.')'])."</td>";
  	}
  	//weist dem entsprechenden Volk die Truppenzahlen zu
  	$t=array();
  	$t['rom']=$nix;
  	$t['gal']=$nix;
  	$t['ger']=$nix;

  	$t[$row['volk']]=$truppen;
  	//Ausgabe der Truppenzahlen (die beiden anderen V�lker entsprechen $nix)
  	echo $t['rom']."<td".$farbe."></td>".$t['ger']."<td".$farbe."></td>".$t['gal'];
  	//Held
  	echo check_t3('<td'.$farbe.'></td><td'.$farbe.'>'.num_hero($row['sid']).'</td>');
  	//Ende der Spielerzeile
  	echo "</tr>\n";
  }

  //Zwischenzeile
  echo "<tr><td height='4' colspan='".check_t3(36 , 34)."'></td></tr>\n";

  //Truppen die Zweite
  echo "<tr>";
  echo "<td class=\"footer\" colspan=\"2\" rowspan=\"2\"><b>".text('admin_sum')."</b></td>";
  echo write_table_header('rom');
  echo "<td class=\"footer\"></td>";
  echo write_table_header('ger');
  echo "<td class=\"footer\"></td>";
  echo write_table_header('gal');
  echo check_t3('<td class="footer"></td><td class="footer"><img src="img/hero.gif"></td>');
  echo "</tr>";

  //Ausgabe der Summe START
  echo "<tr>";
  echo truppensum('rom');
  echo "<td class=\"footer\"></td>";
  echo truppensum('ger');
  echo "<td class=\"footer\"></td>";
  echo truppensum('gal');
  echo "<td class=\"footer\"></td>".check_t3('<td class="footer">'.num_hero('%').'</td>');
  echo "</tr>";
  //Ausgabe der Summe ENDE
  //Tabellenende
  echo "</table>";
?>
<br>

</div>

</body>
</html>