<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/09/22 waRhawK set database connection encoding to utf-8 once established
 * @since 2007/11/02 waRhawK moved into some php directives from .htaccess file to be some more webspace-friendly
 * @since 2007/11/03 waRhawK setting global locale if specified in language file
 * @since 2007/11/15 waRhawK updated installation check and inclusion order
 */
//
// Debug helper method
function ausgabe($array) {
	if (is_array($array)) {
		print '<br /> <pre>';
		print_r($array);
		print '</pre>';
	}
}

// Set Error Reporting
error_reporting(E_ALL ^ E_NOTICE);

// PHP default header definitions
ini_set('default_mimetype','text/html');
ini_set('default_charset','utf-8');

# PHP string directives
ini_set('mbstring.language','neutral');
ini_set('mbstring.internal_encoding','utf-8');
ini_set('mbstring.encoding_translation','on');
ini_set('mbstring.http_input','pass');
ini_set('mbstring.http_output','utf-8');

// Start the session 
session_start();

// Force magic_quotes
if (!get_magic_quotes_gpc()) {
  	foreach($_POST as $key => $value) {
	  	$_POST[$key] = htmlspecialchars(addslashes($value));
  	}
	foreach($_GET  as $key => $value) {
		$_GET[$key]  = htmlspecialchars(addslashes($value));
	}
}

// Define some globals
define('VERSION', '4.0 Beta 1');
define('MOD_NAME', 'Road to WW Mod');
define('MOD_VERSION', '0.1.1');
define('MOD_AUTHOR', 'waRhawK');
define('MOD_CONTACT', 'whk@gmx.de');
define('MOD_SITE', 'http://www.assembla.com/space/rtww/');
define('MOD_UPDATE', '2008/01/09');

// Include main functions file
if (file_exists('function.php')) {
	include_once 'function.php';
}

// Include User Config
if (file_exists('config/inc_config.php')) {
	include_once 'config/inc_config.php';
} 
	
// Check Installation
if (!defined('MYSQL_USER')) {
	header('Location: install/install.php');
	die();
}

// Include defined language file
include "lang_".(defined('LANGUAGE')?LANGUAGE:'en').".php";

// Set Locale if specified
if (is_array($locales = text('locale')) && count($locales)) {
	$locale = setlocale(LC_ALL, $locales);
}

// Establish Database connection
@mysql_connect(MYSQL_HOST, MYSQL_USER, MYSQL_PASS) OR die(mysql_error());
mysql_select_db(MYSQL_DATABASE) OR die(mysql_error());
mysql_query("SET NAMES utf8") OR die (mysql_error());
?>