<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 */
//header und Gr��e vom Bild
Header("Content-Type: image/png");
$img = ImageCreateFromPNG ('img/diagramm.png');

require_once "config.php";
security();

  // -- -- Erstellt ein Kreisdiagramm -- --
  if (isset($_GET['truppen'])) {
  	//truppenverteilung
  	function sum_query($volk)
  	{
  		$sql="SELECT
		        sum(t.t1)+sum(t.t2)+sum(t.t3)+sum(t.t4)+sum(t.t5)+sum(t.t6)+sum(t.t7)+sum(t.t8)+sum(t.t9)+sum(t.t10) AS truppen
			  FROM
			    ".PREFIX."truppen t,
			    ".PREFIX."spieler s
			  WHERE
			    s.volk='".$volk."' AND
				s.sid = t.sid";
		$result = mysql_query($sql) OR die(mysql_error());
		$row = mysql_fetch_assoc($result);
		return $row['truppen'];
  	}
  } else {
  	//spielerverteilung
  	function sum_query($volk)
  	{
  		$sql="SELECT
		        count(sid) AS anzahl
			  FROM
			    ".PREFIX."spieler
			  WHERE
			    volk='".$volk."'";
		$result = mysql_query($sql) OR die(mysql_error());
		$row = mysql_fetch_assoc($result);
		return $row['anzahl'];
  	}
  }

  //reine Anzahl
  $rom=sum_query('rom')+0;
  $ger=sum_query('ger')+0;
  $gal=sum_query('gal')+0;
  //Gesamtzahl
  $ges=$rom+$ger+$gal;
  //Anteil an der Gesamtzahl
  $rom_ges=($rom/$ges)*360;
  $ger_ges=($ger/$ges)*360;
  $gal_ges=($gal/$ges)*360;
  //Prozente
  $rom_per=$rom.' ('.round($rom/$ges*100).'%)';
  $ger_per=$ger.' ('.round($ger/$ges*100).'%)';
  $gal_per=$gal.' ('.round($gal/$ges*100).'%)';

  //Definieren der Farben
  $white = ImageColorAllocate($img, 255, 255, 255);
  $black = ImageColorAllocate($img, 0, 0, 0);
  $green = ImageColorAllocate($img, 0, 240, 0);
  $red   = ImageColorAllocate($img, 240, 0, 0);
  $blue  = ImageColorAllocate($img, 0, 0, 255);
  $grey  = ImageColorAllocate($img, 224, 224, 224);

  //R�meranteil
  ImageFilledArc($img, 110, 75, 100, 100, 0, $rom_ges, $red, 'IMG_ARC_PIE');
  //Germanenanteil
  ImageFilledArc($img, 110, 75, 100, 100, $rom_ges, $ger_ges+$rom_ges, $blue, 'IMG_ARC_PIE');
  //Gallieranteil
  ImageFilledArc($img, 110, 75, 100, 100, $ger_ges+$rom_ges, 360, $green, 'IMG_ARC_PIE');

  //R�mer
  ImageString($img, 2, 225+1, 15+1, $rom_per, $grey);
  ImageString($img, 2, 225, 15, $rom_per, $red);
  //Germanen
  ImageString($img, 2, 225+1, 32+1, $ger_per, $grey);
  ImageString($img, 2, 225, 32, $ger_per, $blue);
  //Gallier
  ImageString($img, 2, 225+1, 50+1, $gal_per, $grey);
  ImageString($img, 2, 225, 50, $gal_per, $green);

  // Sum
  ImageString($img, 2, 225+1, 75+1, $ges, $grey);
  ImageString($img, 2, 225, 75, $ges, $black);

  //erstellt das Bild und leert den Cache
  ImagePNG($img);
  ImageDestroy($img);
?>