<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/08/12 waRhawK increased session check precision and timeout processing
 */

function changedate($datum_alt, $year2 = false) {
  	if ($year2) {
	  $year = substr($datum_alt, 0, 4);
  	  $month = substr($datum_alt, 5, 2);
  	  $day = substr($datum_alt, 8, 2);

  	  return $day.".".$month.".".$year;
  	} else {
  	  $month = substr($datum_alt, 5, 2);
  	  $day = substr($datum_alt, 8, 2);

  	  return $day.".".$month.".";
  	}
}



/**
 * Layout based forward while displaying a short message
 *
 * @param string $page the page to forward to
 * @param string $msg an additional message to display
 * @param bool $error set to true for evil red message style
 */
function fwd($page,$msg='',$error=false) {

	$wait = (strlen($msg)) ? round((int)strlen($msg)/25) : 0;
	print '<html>
<head>
<title>'.utf8_encode(TITLE).'</title>
<meta name="robots" content="noindex">
<meta name="Author" content="Florian Schreier">
<meta name="Copyright" content="Florian Schreier">
<meta http-equiv="refresh" content="'.$wait.'; URL='.$page.'">
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="pragma" content="no-cache">
<link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
<div class="oben">';

	include 'oben.php';

	print '</div>
<div class="mitte" align="center">
<br/><br/>
<span style="font-weight:bold;'.(($error)?' color:red;':'').'">';

	if (strlen($msg)) { print '<b>'.$msg.'</b><p/>'; }

	print '<a href="'.$page.'">'.text('fwd').'</a>
</span>
</div>
</body>
</html>';

    die();
}

function zero($val) {
  	if (is_null($val)) {
  		return "<span class='null'>0</span>";
  	} elseif ((float)$val == 0) {
  		return "<span class='null'>{$val}</span>";
  	} else {
  		return $val;
  	}
}



/**
 * Session Handling and base permission checks
 */
function security() {

	// Session Checks
	if (empty($_SESSION[INSTANCE_KEY]) && empty($_GET['auth'])) {
		session_destroy();
		fwd( 'index.php', text('err_cookie'), true );

	} elseif (
		empty($_GET['auth']) && (
		!isset($_SESSION[INSTANCE_KEY]['sid']) ||
		!isset($_SESSION[INSTANCE_KEY]['name']) ||
		!isset($_SESSION[INSTANCE_KEY]['pass']) ||
		!isset($_SESSION[INSTANCE_KEY]['volk']) ||
		!isset($_SESSION[INSTANCE_KEY]['rechte']) ||
		!isset($_SESSION[INSTANCE_KEY]['touch']) ||
		($_SESSION[INSTANCE_KEY]['sid'] < 1) ||
		!strlen($_SESSION[INSTANCE_KEY]['name']) ||
		!strlen($_SESSION[INSTANCE_KEY]['pass']) ||
		!strlen($_SESSION[INSTANCE_KEY]['volk']) ||
		!strlen($_SESSION[INSTANCE_KEY]['rechte']) ||
		!is_numeric($_SESSION[INSTANCE_KEY]['touch']) )
	) {
		session_destroy();
		fwd( 'index.php', text('err_sess_invalid'), true );

	} elseif( empty($_GET['auth']) && ( $_SESSION[INSTANCE_KEY]['touch'] + 10800 ) < mktime() ) {
		session_destroy();
		fwd( 'index.php', text('err_sess_timeout'), true );

	} elseif(!empty($_GET['auth'])) {
		// create session now
		$_GET['auth'] = (get_magic_quotes_gpc()) ? $_GET['auth'] : addslashes($_GET['auth']);
		$sql = "SELECT s.sid AS sid,".
			"s.name AS name,".
			"s.pass AS pass,".
			"s.volk AS volk,".
			"s.rechte AS rechte ".
			"FROM ".PREFIX."auth a ".
			"LEFT JOIN ".PREFIX."spieler s ON (s.sid = a.sid) ".
			"WHERE a.auth='".$_GET['auth']."' LIMIT 1";

		$result = mysql_query($sql) OR die(mysql_error());
		if(mysql_num_rows($result) > 0) {
			$row = mysql_fetch_assoc($result);
			$_SESSION[INSTANCE_KEY] = array(
	    		'sid'		=> $row['sid'],
	    		'name'		=> $row['name'],
	    		'pass'		=> $row['pass'],
	    		'volk'		=> $row['volk'],
	    		'rechte'	=> $row['rechte'],
	    		'touch'		=> mktime(),
	    	);
		} else {
			session_destroy();
			fwd( 'index.php', text('err_sess_invalid'), true );
		}
	}

	// Push some globals
	global $sid, $name, $volk;
	$sid  = htmlspecialchars($_SESSION[INSTANCE_KEY]['sid']);
	$name = htmlspecialchars($_SESSION[INSTANCE_KEY]['name']);
	$volk = htmlspecialchars($_SESSION[INSTANCE_KEY]['volk']);

	// Query User
	$sql="SELECT sid, name, pass, rechte ".
	     "FROM ".PREFIX."spieler ".
	     "WHERE name='".$name."'";

	$result=mysql_query($sql) OR die(mysql_error());
	$row=mysql_fetch_assoc($result);

	global $rechte;
	$rechte = explode('|', $row['rechte']);

	// Check password
	if ($row['pass']!=htmlspecialchars($_SESSION[INSTANCE_KEY]['pass'])) {
		session_destroy();
		fwd( 'index.php', text('err_sess_invalid'), true );
	}

	// Touch the Session
	$_SESSION[INSTANCE_KEY]['touch'] = mktime();

	// Check some page permissions
	switch (basename($_SERVER['PHP_SELF'])) {
		case "admin.php":
			if ($rechte[0]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
		case "showtroops.php":
			if ($rechte[0]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
		case "member.php":
			if ($rechte[1]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
		case "umkreis.php":
			if ($rechte[2]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
		case "stat.php":
			if ($rechte[3]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
		case "image.php":
			if ($rechte[3]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
		case "diagramm.php":
			if ($rechte[3]=="0") {
				die("<font color=\"red\">No Access!</font>");
			}
		break;
	}
}



function img_pfad($volk, $tid) {
	$img = "img/".(($tid<11)?$volk.$tid:"hero").".gif";
  	return $img;
}



function write_header($title, $addTags="") {
	global $locale;

	header('Content-Type: text/html; charset=utf-8');
	$res = '
<html>
<head>
<title>'.utf8_encode(TITLE).' - '.trim($title).'</title>
<meta name="robots" content="noindex">
<meta name="Author" content="Florian Schreier">
<meta name="Copyright" content="Florian Schreier">
<meta http-equiv="content-type" content="text/html;charset=utf-8">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="pragma" content="no-cache">
<link rel="stylesheet" type="text/css" href="style.css">
<script type="text/javascript" src="scripts/overlib.js"><!-- overLIB (c) Erik Bosrup --></script>
<script type="text/javascript" src="scripts/datepicker.php?locale='.$locale.'"></script>
'.trim($addTags).'
</head>
<body>
<div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></div>
	';

	print trim( $res );
}



function contact_member($member) {
  	$sql="SELECT
  	        wert
  	      FROM
  	        ".PREFIX."config
  	      WHERE
  	        name = 'mail'";
  	$result=mysql_query($sql) OR die(mysql_error());
  	$row=mysql_fetch_assoc($result);
  	if($row['wert']==1) {
  		return " <a href=\"kontakt.php?an=".$member."\"><img src=\"img/brief.gif\"></a>";
  	}
  	return '';
}



function check_t3($if_t3, $if_t2 = "") {

	if (TRAVIAN_VERSION == 3) return $if_t3;
	else                      return $if_t2;
}



/**
 * Sort arrow rendering for table columns
 *
 * @param int $type the sort direction (0=asc, 1=desc, 2=group)
 * @return string the rendered arrow
 */
function sortarrow($type=0) {

	static $types=array('asc','desc','group');
	return (isset($types[$type])) ? '<img src="img/sort'.$types[$type].'.gif" alt="" title="'.text('sort_'.$types[$type]).'" border"0" align="center">' : '';
}



/**
 * Zerofill a number
 *
 * @param int $int the number
 * @param int $length the digits the number should have
 * @return string the zerofilled number
 * @access public
 * @author waRhawK <whk@gmx.de>
 */
function zerofill($int,$length=2) {

	$int = (string)$int;
	while(strlen($int) < $length) {
		$int = '0'.$int;
	}
	return $int;
}



/**
 * Format a village name wrapped in table cell
 * @param string $name the name of the village
 * @param int $x the x-coordinaate of the village
 * @param int $y the y-coordinaate of the village
 * @return string the formatted village name in a table cell
 * @access public
 * @author waRhawK <whk@gmx.de>
 * @since 2007/12/18 waRhawK quick improvement: declared config result static to avoid querying the same again and again and again...
 * @since 2007/12/18 waRhawK replace empty names by unknown indication
 */
function format_village($name, $x, $y, $tdclass='', $spieler='') {
	static $row;
	if (!is_array($row)) {
	  	$sql="SELECT
	  	        wert
	  	      FROM
	  	        ".PREFIX."config
	  	      WHERE
	  	        name = 'dorfname'";
	  	$result=mysql_query($sql) OR die(mysql_error());
	  	$row=mysql_fetch_assoc($result);
	}

	$name = (strlen($name))?$name:'<span class="grey">'.text('list_unknown').'</span>';
	$spieler = ($spieler != '') ? "<span style=\"color:#8F8F8F; font-style:italic;\">(".$spieler.")</span>" : '';

	if($row['wert']==0) {
		//display coordinates
		return "<td{$tdclass}>(".$x."|".$y.")</td>";
	} elseif($row['wert']==1) {
		//display coordinates, village name on mouseover
		return "<td title=\"".$name." ".$spieler."\"{$tdclass}>(".$x."|".$y.")</td>";
	} elseif($row['wert']==2) {
		//display village name, coordinates on mouseover
		return "<td title=\"(".$x."|".$y.")\"{$tdclass}>".$name." ".$spieler."</td>";
	} elseif($row['wert']==3) {
		//display both village name and coordinates
		return "<td{$tdclass}>".$name." (".$x."|".$y.") ".$spieler."</td>";
	} elseif($row['wert']==4) {
		//display both, coordinates on new line
		return "<td{$tdclass}>".$name." ".$spieler."<br>(".$x."|".$y.")</td>";
	}
}

  /************ risi *************/
  function is_he_admin($spielerid) {
	$sql = "SELECT id FROM ".PREFIX."groups WHERE id='1' AND (members LIKE '%,".$spielerid.",%')";
	$result = mysql_query($sql) OR die(mysql_error());
	if(mysql_num_rows($result) > 0) {
		return true;
	} else {
		return false;
	}
  }

  function get_allowed_sids($spielerid, $prefix="")
  {
	if(is_he_admin($spielerid) && isset($_POST['group']) && $_POST['group']
!= "") {
               $allowed_sids = "";
               $sql = "SELECT members FROM ".PREFIX."groups WHERE
id = " . (int)$_POST['group'];
                 $result = mysql_query($sql) OR die(mysql_error());
        }
        elseif(is_he_admin($spielerid)) {
		return "TRUE";
	}
        else {

                $allowed_sids = "";
                $sql = "SELECT members FROM ".PREFIX."groups WHERE
members    LIKE '%,".$spielerid.",%'";
                $result = mysql_query($sql) OR die(mysql_error());
        }

        if(mysql_num_rows($result) < 1) {
                return "FALSE";
        } else {
                while($row = mysql_fetch_assoc($result)) {
                    $friendly_sids .= rtrim($row['members'], ",");
                }
                $friendly_sids = explode(",", trim($friendly_sids, ","));
                $friendly_sids = array_unique($friendly_sids);
                foreach($friendly_sids as $this_sid) {
                    $allowed_sids .= $prefix."sid='".$this_sid."' OR ";
                }
                $allowed_sids = rtrim($allowed_sids, "OR ");
        }

	return $allowed_sids;
  }

  /********************* end risi **************************/
?>