<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/11/03 waRhawK added check for freetype support and fallback to simple string rendering if not
 * @since 2007/12/18 waRhawK fixed bug that font file may not be accessed properly
 */
//header und Gr��e vom Bild
Header("Content-Type: image/png");
$img = ImageCreateFromPNG ('img/image.png');

require_once "config.php";
security();

$user = isset($_GET['u']) ? $_GET['u'] : '';
$sid = isset($_GET['sid']) ? $_GET['sid'] : -1;

  //Abfrage der Truppen eines Spielers
  $sql="SELECT
          s.name AS name,
          st.truppen AS truppen,
          st.datum AS datum
        FROM
          ".PREFIX."spieler s,
          ".PREFIX."stat st
        WHERE
          st.sid = s.sid AND ".
		  (($user!='')?"s.name = '".$user."'":"").
		  (($sid>0)?"s.sid = ".$sid:"").
		" ORDER BY
		  st.datum DESC
		LIMIT
		  0, 14";
  //Abfrage der Truppen einer Allianz
  if ($user=="alle") {
  	$sql="SELECT
          sum(truppen) AS truppen,
          datum
        FROM
          ".PREFIX."stat
        GROUP BY
          datum
		ORDER BY
		  datum DESC
		LIMIT
		  0, 14";
	$user = ALLY_NAME;
  }
  $result = mysql_query($sql) OR die(mysql_error());

  //Definieren der Farben
  $white  = ImageColorAllocate($img, 255, 255, 255);
  $black  = ImageColorAllocate($img, 0, 0, 0);
  $grey   = ImageColorAllocate($img, 191, 191, 191);
  $line   = ImageColorAllocate($img, 0, 0, 127);

  //Spielername
  if (function_exists('imagettftext')) {
  	imagettftext($img, 9, 0, 7, 17, $grey, 'img/font.ttf', $user);
  	imagettftext($img, 9, 0, 6, 16, $black, 'img/font.ttf', $user);
  } else {
  	ImageString($img, 3, 5, 5, $user, $black);
  }

  $i=-1;
  while ($row=mysql_fetch_assoc($result)) {
  	$i++; //1. Durchlauf: i=0 -+- 2. Durchlauf: i=1 usw

  	if ($i==0) {
  		//beim 1. Durchlauf Faktor bestimmmen
		//letzter Wert kann maximal 50 sein
  		$faktor = $row['truppen']/50;
  	} else {
  		// -- beim zweiten Durchlauf Linie zeichnen
  		//Endpunkt f�r diesen Durchlauf bestimmen -+- 0-Punkt bei 13:110  (liegt links von x_start)
		$x_end = 208-15*$i;
		$y_end = 110-$row['truppen']/$faktor;

		//ansteigen der letzten (linken) Linie, bei fehlenden Werten
		$y_while_schleife_end = $y_end;

		//-- fehlende Werte bestimmen und anzeigen --
		//wenn zwischen zwei Werten in der Statistik mehr als ein Tag
		//vergangen ist, tue so als ob er trotzdem in Datenbank w�re
		//86400s == 1d
		while(($datum1-$row['datum'])>86400) {
			$datum1 -= 86400;

			//Datum (n�chstes Datum: links+15)
			ImageStringUp($img, 1, 205-15*$i+1, 144+1, date('d.m.', $datum1), $grey);
			ImageStringUp($img, 1, 205-15*$i, 144, date('d.m.', $datum1), $black);

			//Truppenanzahl
			ImageStringUp($img, 1, (208-15*$i)-3+1, $y_start-10+1, $truppen1+1, $grey);
			ImageStringUp($img, 1, (208-15*$i)-3, $y_start-10, $truppen1, $black);

			if (($datum1-$row['datum'])>86400) {
				//Linie zeichnen
				ImageLine($img, (208-15*$i)+1, $y_start+1, (208-15*$i)-15+1, $y_start+1, $grey);
				ImageLine($img, (208-15*$i), $y_start, (208-15*$i)-15, $y_start, $line);
			} else {
				//letzter Durchlauf
				ImageLine($img, (208-15*$i)+1, $y_start+1, (208-15*$i)-15+1, $y_while_schleife_end+1, $grey);
				ImageLine($img, (208-15*$i), $y_start, (208-15*$i)-15, $y_while_schleife_end, $line);
			}

		    $i++;

		    //sorgt daf�r, dass die rechteste Linie gerade bleibt
		    $y_end = $y_start;
		}

		//Linie zeichnen
		ImageLine($img, $x_start+1, $y_start+1, $x_end+1, $y_end+1, $grey);
		ImageLine($img, $x_start, $y_start, $x_end, $y_end, $line);
  	}
  	//Datum&Truppen f�r n�chsten Durchlauf speichern
  	$datum1=$row['datum'];
  	$truppen1=$row['truppen'];

	//Startpunkt f�r n�chsten Durchlauf bestimmen -+- 0-Punkt bei 13:110 (liegt rechts von x_end)
	$x_start = 208-15*$i;
	$y_start = 110-$row['truppen']/$faktor;

  	//Datum (n�chstes Datum: links+15)
  	ImageStringUp($img, 1, 205-15*$i+1, 144+1, date('d.m.', $row['datum']), $grey);
  	ImageStringUp($img, 1, 205-15*$i, 144, date('d.m.', $row['datum']), $black);

  	//Truppenanzahl
  	ImageStringUp($img, 1, $x_start-3+1, $y_start-10+1, $row['truppen'], $grey		);
  	ImageStringUp($img, 1, $x_start-3, $y_start-10, $row['truppen'], $black);
  }

  //erstellt das Bild und leert den Cache
  ImagePNG($img);
  ImageDestroy($img);
?>