<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/08/06 waRhawK slightly updated for mod compatibility, appears in english for default
 * @since 2007/08/12 waRhawK added generation and saving of a unique instance key to improve sessioning and parallel usage
 * @since 2007/11/02 Lichon create database structure after writing the config file
 * @since 2007/08/12 waRhawK added option for italian and swedish languages
 * @since 2007/08/12 waRhawK added some hints for all the fields to avoid some people get confused what to enter each
 * @since 2007/12/11 waRhawK added chmod 777 to the created inc_config.php to solve some manual edit problems depending on the hosting environment
 */
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">

<html>
<head>
  <title>Trooptool Installation</title>
  <link rel="stylesheet" href="../style.css">
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
</head>
<body>

<div class="oben"></div>

<div class="mitte" align="center">
<?php
  // Installation
  if ((isset($_POST['action'])) AND ($_POST['action'] == "install")) {

  	$mysql_host      = str_replace(array("\\","'",";"),array('','',''),$_POST['mysql_host']);
	$mysql_user      = str_replace(array("\\","'",";"),array('','',''),$_POST['mysql_user']);
	$mysql_pass      = str_replace(array("\\","'",";"),array('','',''),$_POST['mysql_pass']);
	$mysql_database  = str_replace(array("\\","'",";"),array('','',''),$_POST['mysql_database']);
	$mysql_prefix    = str_replace(array("\\","'",";"),array('','',''),$_POST['mysql_prefix']);

	$travian_version = $_POST['travian_version'];
	if($travian_version=='t2') $map = 250;
	else                       $map = 400;
	$allycode            = $_POST['ally_code'];
	$allyname            = $_POST['ally_name'];
	$db_dump            = $_POST['db_dump'];
	$mysql_executable            = $_POST['mysql_executable'];
	$update_db_like_lamma = (empty($_POST['mysql_executable'])) ? true : false;
	//$max_filesize            = $_POST['max_filesize'];
	$updater_code            = $_POST['updater_code'];
	if($travian_version=='t2') $travian_version = 2;
	else $travian_version = 3;

	$admin_name = str_replace(array("\\","'",";"),array('','',''),$_POST['admin_name']);
	$admin_mail = str_replace(array("\\","'",";"),array('','',''),$_POST['admin_mail']);
	$admin_volk = str_replace(array("\\","'",";"),array('','',''),$_POST['admin_volk']);
	$admin_pass = md5($_POST['admin_pass']);

	$instance_key	= addslashes($_POST['instance_key']);
	$language 		= addslashes($_POST['language']);

	// Connect to MySQL
	/*mysql_connect($mysql_host, $mysql_user, $mysql_pass) OR die(mysql_error());
	mysql_select_db($mysql_database) OR die(mysql_error());
	mysql_query("SET NAMES utf8") OR die (mysql_error());*/
	
	
	if(!mysql_connect($mysql_host, $mysql_user, $mysql_pass)) die(mysql_error());
	if(!mysql_select_db($mysql_database)) die(mysql_error());
	if(!mysql_query("SET NAMES utf8")) die (mysql_error());
		
	
	// Create config file
	//$datei = fopen("../inc_config.php","w") OR die('Error: Can\'t create <i>../inc_config.php</i>, check file system permissions!');
	$datei = fopen("../config/inc_config.php","w");
	if(!$datei) die('Error: Can\'t create <i>../config/inc_config.php</i>, check file system permissions!');

	$temp =  "<?php\n";
	fwrite($datei, $temp);
	$temp =  "# Trooptool Configuration File - created by install tool\n";
	fwrite($datei, $temp);
	$temp =  "# Perform changes with care, another install tool run will overwrite this file!\n";
	fwrite($datei, $temp);
	$temp =  "define('MYSQL_HOST','".$mysql_host."');\n";
	fwrite($datei, $temp);
	$temp =  "define('MYSQL_USER','".$mysql_user."');\n";
	fwrite($datei, $temp);
	$temp =  "define('MYSQL_PASS','".$mysql_pass."');\n";
	fwrite($datei, $temp);
	$temp =  "define('MYSQL_DATABASE','".$mysql_database."');\n";
	fwrite($datei, $temp);
	$temp =  "define('PREFIX','".$mysql_prefix."');\n";
	fwrite($datei, $temp);
	$temp =  "define('TRAVIAN_VERSION',".$travian_version.");\n";
	fwrite($datei, $temp);
	$temp =  "define('INSTANCE_KEY','".$instance_key."');\n";
	fwrite($datei, $temp);
	$temp =  "define('LANGUAGE','".$language."');\n";
	fwrite($datei, $temp);
	$temp =  "define('KARTE','".$map."');\n";
	fwrite($datei, $temp);
	$temp =  "define('TITLE','Welcome');\n";
	fwrite($datei, $temp);
	$temp =  "define('INTRO_1','Congratulations to your new troop tool installation/update!');\n";
	fwrite($datei, $temp);
	$temp =  "define('INTRO_2','Check out the <i>inc_config.php</i> to finalize the configuration and place your own cool ally slogan here.');\n";
	fwrite($datei, $temp);
	$temp =  "define('LOGO','img/logo.gif');\n";
	fwrite($datei, $temp);
	$temp =  "define('ALLY_CODE', '".$allycode."');\n";
	fwrite($datei, $temp);
	$temp =  "define('ALLY_NAME', '".$allyname."');\n";
	fwrite($datei, $temp);
	$temp =  "define('DB_DUMP', '".$db_dump."');\n";
	fwrite($datei, $temp);
	$temp =  "define('MYSQL_EXECUTABLE', '".$mysql_executable."');\n";
	fwrite($datei, $temp);
	$temp =  "define('UPDATER_CODE', '".$updater_code."');\n";
	fwrite($datei, $temp);
	$temp =  "define('UPDATE_DB_LIKE_LAMMA', '".$update_db_like_lamma."');\n";
	fwrite($datei, $temp);
	$temp =  "?>";
	fwrite($datei, $temp);

	fclose($datei);
	chmod("../config/inc_config.php", 0777);  

	// Read install SQL
	if ( !strlen( $sqlFile = file_get_contents( 'install.sql' ) ) ) die('no install.sql found');

	// Insert Placeholders
	$sqlFile = str_replace(
		array(	':PREFIX:',		':ADMIN_NAME:',	':ADMIN_PASS:',	':ADMIN_MAIL:',	':ADMIN_TRIBE:'	),
		array(	$mysql_prefix,	$admin_name,	$admin_pass,	$admin_mail,	$admin_volk 	),
		$sqlFile
	);

	// Split to commands
	$sqlCommands = explode( ';', $sqlFile );

	// Execute each command
	foreach( $sqlCommands as $sql ) {
		$sql = trim ( $sql );
		if ( ( strpos( $sql, '#' ) !== 0 ) && ( mb_strlen( $sql ) > 0 ) ) {
			mysql_query( $sql ) OR die(mysql_error());
		}
	}
	
	require_once("../config/inc_config.php");
	echo "<b>Installation successful!</b>
	<p>It is recommended to get the world database dump from your travian server now. <a href='../updater.php?code=".UPDATER_CODE."'>Click here to get it now!</a></p>
	<p>Remember to delete the <i>install</i> directory from server due to security reasons!<br />[ <a href=\"{$_SERVER['PHP_SELF']}?action=finalize\">Delete it for me now</a> ]<p />[ <a href=\"../index.php\">Launch Tool</a> ]";

  } elseif (isset($_GET['action']) && $_GET['action']=='finalize') {

  	// Delete Install Directory
	/**
	 * rm_recurse
	 * @description Remove recursively. (Like `rm -r`)
	 * @see Comment by davedx at gmail dot com on { http://us2.php.net/manual/en/function.rmdir.php }
	 * @param file {String} The file or folder to be deleted.
	 **/
	function rm_recurse($file) {
	    if (is_dir($file) && !is_link($file)) {
	        foreach(glob($file.'/*') as $sf) {
	            if ( !rm_recurse($sf) ) {
	                error_log("Failed to remove $sf\n");
	                return false;
	            }
	        }
	        return rmdir($file);
	    } else {
	        return unlink($file);
	    }
	}
	if ( rm_recurse( '../install' ) ) {
		echo "<strong>Installation finalized!</strong><em>The installation directory was successfully deleted!</em><p />[ <a href=\"../index.php\">Launch Tool</a> ]";
	} else {
		echo "<strong>Installation finalized!</strong><br/><em>The install/ directory could not be deleted - please delete it manually!</em><p />[ <a href=\"../index.php\">Launch Tool</a> ]";
	}

  } else {

  	// @since 2007/08/12 waRhawK added generation of unique instance key for rtww_mod
  	$instance_key = mb_substr( md5( serialize( array_merge( $_SERVER, $_ENV ) ) ), 0, 16);
?>
  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" accept-charset="utf-8">
	<input name="action" type="hidden" value="install">
	<table class="itable" cellpadding="2" cellspacing="1" width="400">
	  <tr>
	    <td colspan="2" class="header1">MySQL Setup</td>
	  </tr>
	  <tr>
	    <td class="header2" width="150">Host:</td>
		<td width="250" title="Enter the hostname or ip address your mysql server is listening on, in most cases this is the same as the webserver (localhost)"><input name="mysql_host" type="text" class="ibox" maxlength="30" value="localhost" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Username:</td>
		<td title="Enter the username that is required for mysql authentication"><input name="mysql_user" type="text" class="ibox" maxlength="30" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Password:</td>
		<td title="Enter the password that is required for mysql authentication"><input name="mysql_pass" type="password" class="ibox" maxlength="30" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Database:</td>
		<td title="Enter the name of the database the troop tool tables should reside in. If you don't have a database yet on your server, please create one manually before continuing'"><input name="mysql_database" type="text" class="ibox" maxlength="30" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Table Prefix:</td>
		<td title="Enter a prefix that is used for database table names for this instance. This allows you to use the troop tool together with other applications on same table"><input name="mysql_prefix" type="text" class="ibox" maxlength="30" value="tt_" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td colspan="2" class="header1">World Setup</td>
	  </tr>
	  <tr>
	    <td class="header2">Ally Code:</td>
		<td title="Please enter the shortcut of your Alliance here as done ingame"><input name="ally_code" type="text" class="ibox" maxlength="10" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Ally Name:</td>
		<td title="Please enter the full name of your Alliance here as done ingame"><input name="ally_name" type="text" class="ibox" maxlength="20" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Travian Map Dump:</td>
		<td title="Please enter the URL of your Travian server's map dump file"><input name="db_dump" type="text" class="ibox" maxlength="255" style="width:150px;" value="http://s1.travian.com/map.sql"></td>
	  </tr>
	  <tr>
	    <td class="header2">Path to the MySQL Executable:</td>
		<td title="Please enter the system path to the mysql shell client on your server"><input name="mysql_executable" type="text" class="ibox" maxlength="255" style="width:150px;" value="/usr/local/mysql/bin/mysql"></td>
	  </tr>
	  <tr>
	    <td class="header2">Password to protect the DB update process:</td>
		<td title="Please enter arbitrary string. Roman letters and numerlas only!"><input name="updater_code" type="text" class="ibox" maxlength="20" style="width:150px;" value="<?php echo substr(md5(time()^rand(1,10)^"laffers.net"), rand(0,19), 12); ?>"></td>
	  </tr>
	  <tr>
	    <td class="header2">Travian Version:</td>
		<td title="Please select the travian version you are playing. As T2 is yet dated out, select T3 if this confuses you">
		  <select name="travian_version" class="ibox" style="width:150px;">
		    <option value="t2">T2</option>
			<option value="t3" selected>T3</option>
		  </select>
		</td>
	  </tr>
	  <tr>
	    <td class="header2">Instance Key:</td>
		<td title="Enter an unique identifier for this troop installation. You can enter whatever you want or just leave in the random key that has been created for you"><input name="instance_key" type="text" class="ibox" maxlength="16" style="width:150px;" value="<?php echo $instance_key?>"></td>
	  </tr>
	  <tr>
	    <td class="header2">Language:</td>
		<td title="Select the language you are like to use. If available, it should match the language the game is running at, otherwise select your favorite">
		  <select name="language" class="ibox" style="width:150px;">
	    <option value="en">English</option>
			<option value="de">Deutsch</option>
			<option value="it">Italiano</option>
			<option value="ne">Nederlands</option>
			<option value="se">Svensk</option>
		  </select>
		</td>
	  </tr>
	  <tr>
	    <td colspan="2" class="header1">Admin Account</td>
	  </tr>
	  <tr>
	    <td class="header2">Username:</td>
		<td title="Enter your username here"><input name="admin_name" type="text" class="ibox" maxlength="20" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Password:</td>
		<td title="Enter your password here"><input name="admin_pass" type="password" class="ibox" maxlength="20" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">E-Mail Address:</td>
		<td title="Enter your email address here"><input name="admin_mail" type="text" class="ibox" maxlength="50" style="width:150px;"></td>
	  </tr>
	  <tr>
	    <td class="header2">Tribe:</td>
		<td title="Enter your tribe here">
		  <select name="admin_volk" class="ibox" style="width:150px;">
		    <option value="rom">Romans</option>
			<option value="gal">Gauls</option>
			<option value="ger">Teutons</option>
		  </select>
		</td>
	  </tr>
	  <tr>
	    <td colspan="2" align="center"><input type="submit" class="submit" value="Install"></td>
	  </tr>
	</table>
  </form>
<?php
  }
?>
</div>

</body>
</html>
