# Install SQL for TT rtww_mod 0.1 - Used by install tool
# On manual usage, be sure to replace all :PLACEHOLDERS: first with your desired values
# Requires: MySQL 4.1 or higher with built-in utf-8 encoding support
# Last Updated: 2007/11/03



# --- Tables ---

# Table 1/6: Config;
DROP TABLE IF EXISTS `:PREFIX:config`;
CREATE TABLE `:PREFIX:config` (
  `ID` int(11) NOT NULL auto_increment,
  `name` varchar(50) character set ascii collate ascii_bin default NULL,
  `wert` tinyint(1) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

# Table 2/6: Villages;
DROP TABLE IF EXISTS `:PREFIX:dorf`;
CREATE TABLE `:PREFIX:dorf` (
  `did` int(11) NOT NULL auto_increment,
  `sid` int(11) default '0',
  `x` smallint(4) default '0',
  `y` smallint(4) default '0',
  `name` varchar(20) default 'n/a',
  `size` smallint(4) unsigned default NULL,
  `type` tinyint(1) unsigned default NULL,
  `layout` tinyint(1) unsigned default NULL,
  `mauer` smallint(2) default '0',
  `turnier` int(2) default '0',
  `palast` smallint(2) default '0',
  `residenz` smallint(2) default '0',
  `kornspeicher` int(6) default '0',
  `getreide` int(6) default '0',
  PRIMARY KEY  (`did`),
  KEY `sid` (`sid`),
  KEY `coords` (`x`,`y`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 3/6: Heroes;
DROP TABLE IF EXISTS `:PREFIX:hero`;
CREATE TABLE `:PREFIX:hero` (
  `id` int(11) NOT NULL auto_increment,
  `sid` int(11) default NULL,
  `active` tinyint(1) unsigned default NULL,
  `name` varchar(25) default NULL,
  `typ` varchar(25) default NULL,
  `x` int(11) default NULL,
  `y` int(11) default NULL,
  `off` int(11) default NULL,
  `def_inf` int(11) default NULL,
  `def_kav` int(11) default NULL,
  `off_bonus` float default NULL,
  `def_bonus` float default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 4/6: Accounts;
DROP TABLE IF EXISTS `:PREFIX:spieler`;
CREATE TABLE `:PREFIX:spieler` (
  `sid` int(11) NOT NULL auto_increment,
  `name` varchar(20) default NULL,
  `pass` varchar(32) character set ascii collate ascii_bin default NULL,
  `email` varchar(50) default NULL,
  `rechte` varchar(10) character set ascii collate ascii_bin default NULL,
  `volk` char(3) character set ascii collate ascii_bin default NULL,
  `aktiv` tinyint(1) default '0',
  `start` datetime default '0000-00-00 00:00:00',
  `lastlogin` datetime default '0000-00-00 00:00:00',
  `lastchange` date default '0000-00-00',
  `lasthost` char(15) character set ascii collate ascii_bin default NULL,
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 5/6: Statistics;
DROP TABLE IF EXISTS `:PREFIX:stat`;
CREATE TABLE `:PREFIX:stat` (
  `ID` int(11) NOT NULL auto_increment,
  `sid` int(11) default NULL,
  `truppen` int(11) default NULL,
  `datum` int(11) default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 6/6: Units;
DROP TABLE IF EXISTS `:PREFIX:truppen`;
CREATE TABLE `:PREFIX:truppen` (
  `tid` int(11) NOT NULL auto_increment,
  `sid` int(11) default '0',
  `x1` int(11) default NULL,
  `y1` int(11) default NULL,
  `x2` int(11) default NULL,
  `y2` int(11) default NULL,
  `volk` char(3) character set ascii collate ascii_bin default NULL,
  `datum` date default '0000-00-00',
  `t1` int(11) default '0',
  `t2` int(11) default '0',
  `t3` int(11) default '0',
  `t4` int(11) default '0',
  `t5` int(11) default '0',
  `t6` int(11) default '0',
  `t7` int(11) default '0',
  `t8` int(11) default '0',
  `t9` int(11) default '0',
  `t10` int(11) default '0',
  PRIMARY KEY  (`tid`),
  KEY `sid` (`sid`),
  KEY `origin` (`x1`,`y1`),
  KEY `position` (`x2`,`y2`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 7/8: Groups;
DROP TABLE IF EXISTS `:PREFIX:groups`;
CREATE TABLE `:PREFIX:groups` (
  `id` int(9) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default 'Group 1',
  `description` varchar(255) NOT NULL,
  `members` longtext,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 8/8: World;
CREATE TABLE `x_world` (
  `id` int(9) unsigned NOT NULL default '0',
  `x` smallint(3) NOT NULL default '0',
  `y` smallint(3) NOT NULL default '0',
  `tid` tinyint(1) unsigned NOT NULL default '0',
  `vid` int(9) unsigned NOT NULL default '0',
  `village` varchar(20) NOT NULL default '',
  `uid` int(9) NOT NULL default '0',
  `player` varchar(20) NOT NULL default '',
  `aid` int(9) unsigned NOT NULL default '0',
  `alliance` varchar(8) NOT NULL default '',
  `population` smallint(5) unsigned NOT NULL default '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

# Table 9/9: auth
DROP TABLE IF EXISTS `:PREFIX:auth`;
CREATE TABLE `:PREFIX:auth` (
  `sid` int(9) NOT NULL,
  `auth` varchar(16) NOT NULL,
  PRIMARY KEY  (`sid`),
  UNIQUE KEY `auth` (`auth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


# --- Data ---

# Config;
INSERT INTO `:PREFIX:config` (`name`, `wert`) VALUES ('mail', 1);
INSERT INTO `:PREFIX:config` (`name`, `wert`) VALUES ('dorfname', 2);

# Villages;
INSERT INTO `:PREFIX:dorf` (`sid`, `x`, `y`, `name`, `size`, `type`, `layout`, `mauer`, `turnier`, `palast`, `residenz`, `kornspeicher`, `getreide`)
	VALUES (1, 0, 0, ':ADMIN_NAME:''s Village', 250, 1, 0, 20, 10, 20, 0, 160000, 4000);

# Heroes;
INSERT INTO `:PREFIX:hero` (`sid`, `active`, `name`, `typ`, `x`, `y`, `off`, `def_inf`, `def_kav`, `off_bonus`, `def_bonus`)
	VALUES (1, 1, ':ADMIN_NAME:''s Hero', 'Example', 0, 0, 10000, 5000, 2500, 5, 3);

# Accounts;
INSERT INTO `:PREFIX:spieler` (`sid`, `name`, `pass`, `email`, `rechte`, `volk`, `aktiv`, `start`)
	VALUES (1, ':ADMIN_NAME:', ':ADMIN_PASS:', ':ADMIN_MAIL:', '2|3|2|2', ':ADMIN_TRIBE:', 1, NOW());

# Units;
INSERT INTO `:PREFIX:truppen` (`sid`, `x1`, `y1`, `x2`, `y2`, `volk`, `datum`, `t1`, `t2`, `t3`, `t4`, `t5`, `t6`, `t7`, `t8`, `t9`, `t10`)
	VALUES (1, 0, 0, 0, 0, ':ADMIN_TRIBE:', NOW(), 1000, 500, 500, 250, 250, 250, 100, 100, 2, 3);

# Groups
INSERT INTO `:PREFIX:groups` (`id`, `name`, `description`, `members`) VALUES (1, 'Admins', 'Special groups that grants its users access to all people', '');