<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @internal language: german
 * @todo replace by xml-based, full utf-8 layer
 * @since 2007/11/02 waRhawK converted to native utf-8 file, be sure your editor support utf-8 before editing this file
 */



/**
 * Delivering of language specific text
 *
 * @param string $parameter the label key to fetch
 * @return string the utf-8 encoded, localized text
 */
function text($parameter) {

	/**
	 * The language stack
	 * @var array
	 */
	$text=array();

	// Name of Translator
	$text['translator']="waRhawK";

	// About
	$text['about'] = 'Truppentool '.VERSION.
	((mb_strlen(MOD_NAME))?' - '.MOD_NAME:'').
	((mb_strlen(MOD_VERSION))?' '.MOD_VERSION:'').
	((mb_strlen(MOD_AUTHOR))?' von '.MOD_AUTHOR:'').
	((mb_strlen(MOD_UPDATE))?', letztes Update: '.MOD_UPDATE:'');

	// Language specific
	$text['locale'] = array('de_DE', 'de_DE@EURO', 'de_DE@ISO-8859-15', 'German');
	$text['date_short'] = 'd.m.Y';
	$text['date_picker_fmt'] = 'dmy';
	$text['date_picker_sep'] = '.';

	// Menu
	$text['admin.php']="Truppenübersicht";
	$text['admin.php_hover']="die Armee der gesamten Allianz";

	$text['member.php']="Mitgliederliste";
	$text['member.php_hover']="Liste der Mitglieder & Mitgliederverwaltung";

	$text['user.php']="Meine Truppen";
	$text['user.php_hover']="neue Truppen eintragen oder alte Verbände aktualisieren";

	$text['hero.php']="Meine Helden";
	$text['hero.php_hover']="Meine Helden verwalten";

	$text['dorf.php']="Meine Dörfer";
	$text['dorf.php_hover']="Meine Dörfer verwalten";

	$text['umkreis.php']="Einsatzplanung";
	$text['umkreis.php_hover']="Truppen für den nächsten Einsatz planen";

	$text['stat.php']="Statistik";
	$text['stat.php_hover']="Statistik zur Entwicklung der Truppenzahlen";

	$text['userconfig.php']="Einstellungen";
	$text['userconfig.php_hover']="das Truppentool anpassen";

	$text['profil.php']="Mein Profil";
	$text['profil.php_hover']="Meine Angaben aktualisieren";

	$text['faq.php']="FAQ";
	$text['faq.php_hover']="FAQ (häufige Fragen und ihre Antworten)";

	$text['logout.php']="Logout";
	$text['logout.php_hover']="Abmeldung";

	$text['login']="Anmeldung";
	$text['login_hover']="Anmeldung";

	$text['register.php']="Registrieren";
	$text['register.php_hover']="neuen Account anlegen";

	// Login
	$text['login_header'] 	= "Anmeldung";
	$text['login_name']   	= "Spielername:";
	$text['login_pass']   	= "Passwort:";
	$text['login_submit'] 	= "Anmelden";
	#$text['login_fehler1']	= "Der Spieler wurde nicht in der Datenbank gefunden. Überprüfen sie bitte die korrekte Schreibweise.";  // Security risk...
	$text['login_inactive']	= "Dein Account wurde noch nicht freigeschaltet. Bitte räume dem Administrator dafür ein wenig Zeit ein und kontaktiere ihn, wenn es aus deiner Sicht zu lange dauert.";
	$text['login_wrong']	= "Der eingegebene Spielername und/oder das Passwort ist nicht korrekt. Klicke <a href=\"index.php?action=lostpw\">hier</a>, wenn du dein Passwort vergessen hast und dir ein neues erstellen lassen möchtest.";
	$text['login_success']	= "Hallo <i>###PLAYER:NAME###</i>, dein Login war erfolgreich.";

	// Generic Errors
	$text['err_cookie']			= "Das Cookie für die Sitzung konnte nicht erstellt werden.<br />Bitte überprüfe deine Browsereinstellungen.";
	$text['err_sess_invalid']	= "Ungültige Sitzungsdaten. Bitte melde dich erneut an.";
	$text['err_sess_timeout']	= "Deine Sitzung ist abgelaufen. Bitte melde dich erneut an.";

	// Lost Password
	$text['pw_header']	="Passwort vergessen";
	$text['pw_text']	="Mit Hilfe dieses Formulars kannst du dir ein neues Passwort erstellen lassen, falls du dein altes vergessen hast. Gib dazu deinen Spielernamen und die E-Mail Adresse ein, die du bei der Registrierung verwendet hat. Das neue Passwort wird dir dann an diese Adresse per E-Mail zugestellt.";
	$text['pw_name']	="Spielername:";
	$text['pw_email']	="E-Mail:";
	$text['pw_submit']	="Neues Passwort erstellen";

	// Registration
	$text['register_header']="Registrierung";
	$text['register_name']="Benutzername:";
	$text['register_pass']="Passwort:";
	$text['register_volk']="Volk:";
	$text['register_submit']="Anmelden";
	$text['register_error_1']="Dieser Spielername ist bereits in der Datenbank gespeichert. Bitte suchen sie sich einen neuen aus.";
	$text['register_error_2']="Bitte füllen sie alle Felder aus.";
	$text['register_error_21']="Fehler: Es wurde kein Spielername eingegeben.";
	$text['register_error_22']="Fehler: Sie haben kein Passwort eingegeben.";
	$text['register_error_3']="Die Registrierung war erfolgreich. Jetzt müssen sie nur noch warten, bis sie von einem Admin freigeschaltet werden.";

	// Tribe
	$text['volk_rom'] = "Römer";
	$text['volk_gal'] = "Gallier";
	$text['volk_ger'] = "Germanen";

	// Actions
	$text['edit'] = "Bearbeiten";
	$text['del']  = "Löschen";
	$text['fwd']  = "Weiter";

	// Sortings @added 2007/08/02 for RtWW Mod
	$text['sort_asc']	= 'Aufsteigende Sortierung';
	$text['sort_desc']	= 'Absteigende Sortierung';
	$text['sort_group']	= 'Gruppierung';

	// Quick Selects
	$text['list_members'] = "Spieler";
	$text['list_villages'] = "Dörfer";
	$text['list_groups'] = "Gruppen";
	$text['list_allies'] = "Allianzen";
	$text['list_empty'] = "(keine)";
	$text['list_na'] = "(nicht verfügbar)";
	$text['list_unknown'] = "(unbekannt)";

	// Troop Overview
	$text['admin_header']     = "Truppenübersicht";
	$text['admin_player']     = "Spieler";
	$text['admin_lastchange'] = "letzte Aktualisierung";
	$text['admin_sort']       = "Sortierung nach";
	$text['admin_sum']        = "Summe";
	$text['lastlogin']        = "Letzter Login";
	$text['admin_age']        = "Zuletzt aktualisiert am: %d.%m.%Y";
	$text['admin_age_1']      = "Truppenstand ist aktuell (max. 3 Tage)";
	$text['admin_age_2']      = "Truppenstand ist leicht veraltet (3-5 Tage)";
	$text['admin_age_3']      = "Truppenstand ist veraltet (5-7 Tage)";
	$text['admin_age_4']      = "Truppenstand ist stark veraltet (7-14 Tage)";
	$text['admin_age_5']      = "Truppenstand ist extrem veraltet (mind. 2 Wochen) oder nicht gepflegt";

	// User Profile
	$text['troops_detail'] = "Detailansicht";
	$text['troops_hero']   = "Helden";
	$text['troops_stat']   = "Statistik";

	// Memberlist
	$text['memberlist_header']   = "Mitgliederliste";
	$text['name']                = "Name";
	$text['member_header']       = "Anmeldungen";
	$text['member_ok']           = "Spieler aufnehmen";
	$text['member_no']           = "Spieler abweisen";
	$text['member_date']         = "Anmeldung";
	$text['member_tribe']        = "Volk";
	$text['member_nonewmembers'] = "keine neuen Anmeldungen";
	$text['member_del']          = "Spieler löschen";
	$text['member_delq']         = "Wollen sie diesen Spieler wirklich löschen?";

	// Access Control
	$text['rechte_0'] = "kein Zugriff";
	$text['rechte_1'] = "nur eigene lesen";
	$text['rechte_2'] = "alles lesen";
	$text['rechte_3'] = "lesen und bearbeiten";
	$text['member_0'] = "Truppenübersicht";
	$text['member_1'] = "Mitgliederliste";
	$text['member_2'] = "Truppensuche";
	$text['member_3'] = "Statistik";

	// Own Troops
	$text['user_askdel']      = "Wollen Sie diese Daten wirklich löschen?";
	$text['user_header']      = "Meine Truppen";
	$text['user_her']         = "Herkunft";
	$text['user_sta']         = "Standort";
	$text['user_units']       = "Einheiten";
	$text['user_showforms']   = "neue Truppen eintragen";
	$text['user_form_header'] = "Truppen eintragen";
	$text['user_hilfe_regex'] = "Gehen sie auf die Travianhomepage und rufen sie die Seite des Versammlungsplatzes auf (z.B. http://welt3.travian.de/build.php?id=39). Drücken sie dort nacheinander Strg+A und Strg+C. Anschließend gehen sie wieder auf diese Seite, setzen den Cursor in das Feld links und drücken Strg+V. Jetzt müssen sie nur noch die entsprechenden Koordinaten eingeben und auf &quot;speichern&quot; klicken. Die Truppen werden automatisch eingetragen. Als Alternative können sie sie auch manuell eintragen. Achten sie hierbei darauf, dass das Textfeld links leer bleibt.";
	$text['user_manu']        = "Manuell";
	$text['user_auto']        = "Auto";
	$text['user_manu_hint']   = "Manuelle Eingabe";
	$text['user_auto_hint']   = "Automatische Eingabe";

	// Ingame headlines from rally point; used for auto regex insert of troops
	$text['user_own_troops']    = "Eigene Truppen";
	$text['user_return_from']   = "Rückkehr von";
	$text['user_troops_for']    = "Unterstützung für";
	$text['user_troops_of']     = "'s Truppen";
	$text['user_attack_to']     = "Angriff auf";
	$text['user_raid_to']       = "Raubzug gegen";
	$text['user_spy_at']        = "Spähangriff gegen";
	$text['user_explore_oasis'] = "Verlassenes Tal erkunden";

	// Own heroes
	$text['hero_header']      = "Meine Helden";
	$text['hero_name']        = "Name";
	$text['hero_typ']         = "Typ";
	$text['hero_sta']         = "Standort";
	$text['hero_off']         = "Angriff";
	$text['hero_def']         = "Verteidigung";
	$text['hero_off-bonus']   = "Off-Bonus";
	$text['hero_def-bonus']   = "Def-Bonus";
	$text['hero_showforms']   = "Neuen Held eintragen";
	$text['hero_form_header'] = "Held eintragen";
	$text['hero_enable']      = "Held aktivieren";
	$text['hero_disable']     = "Held deaktivieren";
	$text['hero_active']      = "Dieser Held ist aktuell aktiv";
	$text['hero_inactive']    = "Dieser Held ist nicht aktiv und muss im Heldenhof reaktiviert werden";
	$text['hero_state']		= "Status";
	$text['hero_state_active']		= "Aktiv";
	$text['hero_state_inactive']		= "Inaktiv";

	// Own villages
	$text['dorf_header']       = "Meine Dörfer";
	$text['dorf_showforms']    = "Neues Dorf eintragen";
	$text['dorf_form_header']  = "Dorf eintragen";
	$text['dorf_name']         = "Name";
	$text['dorf_koords']       = "Koordinaten";
	$text['dorf_type']         = "Typ";
	$text['dorf_type_0']       = "Standard (Nebendorf)";
	$text['dorf_type_1']       = "Hauptdorf";
	$text['dorf_type_2']       = "Natarendorf (Weltwunder)";
	$text['dorf_type_3']       = "Besetzte Oase";
	$text['dorf_layout']       = "Layout";
	$text['dorf_layout_0']     = "Standard (4-4-4-6)";
	$text['dorf_layout_1']     = "Holz (5-3-4-6)";
	$text['dorf_layout_2']     = "Lehm (4-5-3-6)";
	$text['dorf_layout_3']     = "Eisen (3-4-5-6)";
	$text['dorf_layout_4']     = "Getreide (3-3-3-9)";
	$text['dorf_layout_5']     = "Getreide (1-1-1-15)";
	$text['dorf_size']         = "Einwohner";
	$text['dorf_mauer']        = "Mauer";
	$text['dorf_turnier']      = "Turnierplatz";
	$text['dorf_palast']       = "Palast";
	$text['dorf_residenz']     = "Residenz";
	$text['dorf_kornspeicher'] = "Kornspeicher";
	$text['dorf_getreide']     = "Produktion";

	// Troop Planner @modified 2007/07/28 for RtWW Mod
	$text['umkreis_header']="Einsatzplanung";
	$text['umkreis_col_val']="Wert";
	$text['umkreis_col_sel']="Auswahl / Bereich";
	$text['umkreis_col_help']="Schnellwahl / Details";
	$text['umkreis_target']="Ziel";
	$text['umkreis_arrival_date']="Ankunftstag";
	$text['umkreis_arrival_time']="Ankunftszeit";
	$text['umkreis_notimes_note1']="Es werden nur Laufzeiten angezeigt";
	$text['umkreis_notimes_note2']="Zeitplanung aktivieren, um Zielzeit festzulegen";
	$text['umkreis_submit']="Planung starten";
	$text['umkreis_date_today']="Heute";
	$text['umkreis_date_cal']="Kalender";
	$text['umkreis_date_cal_hint']="Datum über Kalender auswählen";
	$text['umkreis_time_now']="Jetzt";
	$text['umkreis_time_now_hint']="Zeit auf Jetzt festlegen";
	$text['umkreis_art']="Einsatztyp";
	$text['umkreis_art_def']="Defensiv";
	$text['umkreis_art_off']="Offensiv";
	$text['umkreis_art_adl']="Adelungen";
	$text['umkreis_art_fak']="Fakes";
	$text['umkreis_art_oth']="Sonstige";
	$text['umkreis_types_i']="Nur Infantrie";
	$text['umkreis_types_k']="Nur Kavallerie";
	$text['umkreis_types_g']="Nur Geräte";
	$text['umkreis_types_a']="Nur Adeleinheiten";
	$text['umkreis_types_ik']="Infantrie + Kavallerie";
	$text['umkreis_types_ig']="Infantrie + Geräte";
	$text['umkreis_types_kg']="Kavallerie + Geräte";
	$text['umkreis_types_ai']="Mit Infantrie";
	$text['umkreis_types_ak']="Mit Kavallerie";
	$text['umkreis_types_aik']="Mit Infantrie + Kavallerie";
	$text['umkreis_types_aikg']="Mit allem";
	$text['umkreis_types_ff']="Schnell (Kavallerie)";
	$text['umkreis_types_fm']="Mittel (Infantrie)";
	$text['umkreis_types_fs']="Langsam (Geräte)";
	$text['umkreis_types_sp']="Spähangriff";
	$text['umkreis_types_ss']="Kleiner Raubzug";
	$text['umkreis_types_ls']="Großer Raubzug";
	$text['umkreis_types_all']="Alles";
	$text['umkreis_types_both']="Beides";
	$text['umkreis_troops']="Truppenwahl";
	$text['umkreis_troops_yes']="Ja";
	$text['umkreis_troops_yes_hint']="Dieser Einheitentyp muss auf jeden Fall vorhanden sein";
	$text['umkreis_troops_no']="Nein";
	$text['umkreis_troops_no_hint']="Dieser Einheitentyp wird nicht berücksichtigt";
	$text['umkreis_troops_opt']="Wenn vorhanden";
	$text['umkreis_troops_opt_hint']="Dieser Einheitentyp wird verwendet, sofern vorhanden";
	$text['umkreis_troops_fit']="Wenn passend";
	$text['umkreis_troops_fit_hint']="Dieser Einheitentyp wird verwendet, wenn für den Einsatztyp geeignet";
	$text['umkreis_strength']="Truppenstärke";
	$text['umkreis_strength_cnt']="Nach Anzahl";
	$text['umkreis_strength_res']="Nach Getreideverbrauch";
	$text['umkreis_strength_cry']="Nach Kapazität";
	$text['umkreis_strength_single']="Fake";
	$text['umkreis_strength_all']="Alles";
	$text['umkreis_pool_limit']="Maximal vom Bestand";
	$text['umkreis_pool_limit_player']="Individuell";
	$text['umkreis_pool_limit_set']="Festlegen";
	$text['umkreis_source']="Herkunft";
	$text['umkreis_source_all']="Alle (Allianzverbund)";
	$text['umkreis_source_own']="Persönlich";
	$text['umkreis_source_own_tr']="Meine Truppen";
	$text['umkreis_source_own_gr']="Meine Gruppe";
	$text['umkreis_source_own_al']="Meine Allianz";
	$text['umkreis_source_direct']="Nur direkt";
	$text['umkreis_source_direct_hint']="Es werden nur Truppen aus Döfern verwendet, die direkt produzieren";
	$text['umkreis_source_locations']="Standorte einbeziehen";
	$text['umkreis_source_locations_hint']="Es werden auch Truppen verwendet, die ausgelagert wurden";
	$text['umkreis_distance']="Entfernungslimit";
	$text['umkreis_distance_dur']="Maximale Laufzeit";
	$text['umkreis_distance_dis']="Maximale Distanz";
	$text['umkreis_distance_no']="Kein Limit";
	$text['umkreis_distance_yes']="Limit";
	$text['umkreis_distance_fields']="Felder";

	$text['umkreis_dev_note']="<b>Achtung!</b> Dieser Bereich ist noch nicht fertiggestellt.<br />Alle ausgegrauten Funktionen werden nicht ausgewertet, man kann sie weder umgehen noch erzwingen.";

	$text['umkreis2_header'] = "Planung für ###X###|###Y### am %d.%m.%Y um %H:%M:%S Uhr";
	$text['umkreis2_header_notimes'] = "Planung für ###X###|###Y### (nur Laufzeiten)";
	$text['umkreis2_src_direct']="Direkter Weg von ###VIL1###";
	$text['umkreis2_src_location']="Umweg von ###VIL2### über ###VIL1###";
	$text['umkreis2_col_player']="Spieler";
	$text['umkreis2_col_squad']="Einheiten";
	$text['umkreis2_col_start']="Start";
	$text['umkreis2_col_duration']="Entfernung";

/*
	$text['umkreis_dauer']="Dauer";
	$text['umkreis_start']="Startzeit";
	$text['umkreis_ver']="Verteidigung";
	$text['umkreis_ang']="Angriffsplanung";
	$text['umkreis_own']="nur eigene Truppen";
	$text['umkreis_header21']="innerhalb von";
	$text['umkreis_header22']="Stunden verfügbare Truppen";
	$text['umkreis_herkunft']="Herkunft";
	$text['umkreis_standort']="Standort";
	$text['umkreis_anzahl']="Truppenzahl";
*/

	// Stats
	$text['stat_header']="Statistik";
	$text['stat_verlauf']="Truppenverlauf";
	$text['stat_truppenver']="Truppenverteilung";
	$text['stat_spielerver']="Spielerverteilung";

	// User Profile
	$text['profil_header'] = "Mein Profil";
	$text['profil_name']   = "Spielername:";
	$text['profil_volk']   = "Volk:";
	$text['profil_email']  = "E-Mail Adresse:";
	$text['profil_new']    = "neues Passwort:";
	$text['profil_old']    = "aktuelles Passwort:";
	$text['profil_ok']     = "Das Passwort wurde erfolgreich gespeichert.";
	$text['profil_fehler'] = "Sie haben ein falsches Passwort eingegeben.";
	$text['save']          = "speichern";

	// Setup /* temporarly disabled */
	$text['config_header'] = "Einstellungen";
	$text['config_note'] = "Achtung! Änderungen auf dieser Seite betreffen alle Nutzer!";
	$text['config_mail'] = "Kontaktlink hinter dem Spielernamen";
	$text['config_mail_0'] = "nicht anzeigen";
	$text['config_mail_1'] = "anzeigen";
	$text['config_dorfname'] = "Koordinaten/Dorfnamen-Anzeige";
	$text['config_dorfname_0'] = "nur Koordianten anzeigen";
	$text['config_dorfname_1'] = "Koordinaten anzeigen - Dorfname bei Mouseover";
	$text['config_dorfname_2'] = "Dorfname anzeigen - Koordinaten bei Mouseover";
	$text['config_dorfname_3'] = "Dorfname vor Koordinaten";
	$text['config_dorfname_4'] = "Dorfname über Koordinaten";

	// FAQ
	$text['faq_haeder']="FAQ (häufige Fragen und ihre Antworten)";
	$text['faq_frage']="Frage:";
	$text['faq_antwort']="Antwort:";
	$text['faq_f1']="Warum geht das bei mir nicht?";
	$text['faq_a1']="Damit das Tool korrekt funktioniert braucht man einen aktuellen Browser, der <u>Javascript unterstützt</u> und das <u>Setzen von Cookies erlaubt</u>.";
	$text['faq_f2']="Wie kann ich meine Mitglieder aktivieren?";
	$text['faq_a2']="Wenn sich ein neues Mitglied angemeldet hat, wird der Loginname sowie das Anmeldedatum in der Tabelle rechts angezeigt. Durch klicken auf den grünen Haken neben seinem Namen wird er aktiviert und fortan in der linken Mitgliederliste geführt. Das rote Kreuz löscht den Spieler aus der Datenbank.";
	$text['faq_f3']="Was bedeuten die Symbole unter den Zahlen in der Mitgliederliste?";
	$text['faq_a3']="Die Symbole zeigen die Zugriffsberechtigungen der Spieler. Ein durchgestrichenes Buch bedeutet, dass der Spieler diese Seite nicht betreten darf. Zwei Bücher Übereinander bedeuten, dass der Spieler die Daten aller Anderen auf dieser Seite lesen darf, während ein einzelnes Buch bedeutet, dass der Spieler die Seite zwar betreten darf, aber nur seine eigenen Daten sehen kann. Wenn auf dem Buch noch ein Bleistift liegt, heißt das, dass der Spieler die Rechte hat alle Daten auf dieser Seite zu verändern. Die Zahlen in der obersten Reihe stehen für die vier Seiten, auf denen man Rechte vergeben kann: <b>1</b>=Truppenübersicht, <b>2</b>=Mitgliederliste, <b>3</b>=Truppensuche und <b>4</b>=Statistik. Durch einen Klick auf ein schon bestehendes Symbol können sie die Rechte eines Spielers auf dieser Seite Ändern.";
	$text['faq_f4']="Wie kann ich meine Truppen eintragen?";
	$text['faq_a4']="Im Menu auf der linken Seite sehen sie den Punkt &quot;eigene  Truppen&quot;. Nachdem sie darauf geklickt haben erscheint eine Übersicht über ihre Truppen. Wenn sie noch nichts eingetragen haben, ist die Tabelle natürlich noch leer. Um sie zu füllen klicken sie unten auf &quot;neue Truppen eintragen&quot;. Es erscheint ein Formular. Ganz oben geben sie die X- und die Y-Koordinaten von <u>Herkunft</u> und <u>Standort</u> ein. Um die Truppen automatisch eintragen zu lassen gehen sie auf die Seite des Versammlungsplatzes (z.B. http://welt3.travian.de/build.php?id=39). Dort müssen sie nacheinander Strg+A und Strg+C drücken. Anschließend klicken sie in das große Feld und drücken Strg+V. Wenn sie ihre Truppen lieber per Hand eintragen wollen, klicken sie auf den kleinen Pfeil rechts neben dem Feld. In die neuen Felder können sie nun die Truppenstärke der entsprechenden Einheit eintragen. Zum Schluss klicken sie noch auf &quot;speichern&quot; um die Daten abzuspeichern. Wenn alles geklappt hat, sehen sie jetzt die eingegebenen Truppen oben in einer Tabelle. (Sie müssen unbedingt alle Dorfnamen ihres Reiches unter &quot;eigene Dörfer&quot; eingeben. Andernfalls werden die Truppen in diesem Dorf nicht angezeigt.)";
	$text['faq_f5']="Wie kann ich meine Truppenzahlen verändern?";
	$text['faq_a5']="Um ihre Truppenzahlen zu verändern klicken sie auf den <u>Bleistift</u>, der in der selben Zeile wie die zu verändernden Truppenzahlen steht. Das neue Formular enthält die alten Daten und kann durch Eingabe neuer Werte verändert werden.";
	$text['faq_f6']="Wie kann ich einzelne Datensätze löschen?";
	$text['faq_a6']="Dazu klicken sie auf das X, welches sie neben dem Datensatz finden. Wenn sie die Löschung mit Klick auf OK bestätigen, werden die betrofenen Truppen <u>unwiderruflich gelöscht</u>.";
	$text['faq_f7']="Wie funktioniert die Truppensuche?";
	$text['faq_a7']="In der oberen Zeile finden sie fünf Eingabefelder. In die ersten beiden geben sie die Koordinaten des Ziel-Dorfes ein. Die anderen drei Felder sind für die spätest mögliche Ankunftszeit reserviert. Bitte geben sie die Zeit im Format <u>Stunde : Minute : Sekunde</u> ein. In der zweiten Zeile befinden sich noch zwei optionale Felder. Wenn sie das erste ankreuzen werden in der Ergebnisliste auch SpÄher aufgeführt. Das Ankreuzen des zweiten Feldes hat zur Folge, dass in der Liste zusätzlich zum Standort die Herkunft angezeigt wird. Auf die Berechnung haben beide Optionen keinen Einfluss. Die Truppen müssen immer den folgenden Weg zurück legen: <u>Standort -&gt; Herkunft -&gt; Ziel</u>";
	$text['faq_f8']="Welche Truppen werden bei der Truppensuche berücksichtigt?";
	$text['faq_a8']="Bei einer <u>Verteidigungssuche</u> werden nur spezielle Def-Truppen angezeigt. Von den <i>Römern</i> sind dies Legionäre, Prätorianer und Equites Imperatoris, von den <i>Galliern</i> Phalanx, Druidenreiter und Haeduaner und von den <i>Germanen</i> Speerkämpfer und Paladine. Eine <u>Angriffsplanung</u> zeigt von den <i>römischen Truppen</i> nur Imperianer, Equites Imperatoris und Equites Caesaris, von den <i>gallischen Truppen</i> nur Schwertkämpfer, Theutates Blitz und Haeduaner und von den <i>germanischen Truppen</i> nur Keulenschwinger, Axtkämpfer, Paladine und Teutonen Reiter an.";
	$text['faq_f9']="Das Tool kommt mir so bekannt vor. Woran liegt das?";
	$text['faq_a9']="Ich habe mich beim Programmieren an Crys Truppentool orientiert. Deshalb sieht es an manchen Stellen ähnlich aus. Wenn du deshalb lieber Crys benutzen willst, musst du auf <a href=\"http://truppen.macaputo.de\">truppen.macaputo.de</a> gehen.";

	// Logout
	$text['login_again']="nochmal einloggen";

	// Troops (Single) @modified 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1']  = "Legionär";
	$text['t_rom2']  = "Prätorianer";
	$text['t_rom3']  = "Imperianer";
	$text['t_rom4']  = "Equites Legati";
	$text['t_rom5']  = "Equites Imperatoris";
	$text['t_rom6']  = "Equites Caesaris";
	$text['t_rom7']  = "Rammbock";
	$text['t_rom8']  = "Feuerkatapult";
	$text['t_rom9']  = "Senator";
	$text['t_rom10'] = "Siedler";

	// Gauls
	$text['t_gal1']  = "Phalanx";
	$text['t_gal2']  = "Schwertkämpfer";
	$text['t_gal3']  = "Späher";
	$text['t_gal4']  = "Theutates Blitz";
	$text['t_gal5']  = "Druidenreiter";
	$text['t_gal6']  = "Haeduaner";
	$text['t_gal7']  = "Rammholz";
	$text['t_gal8']  = "Kriegskatapult";
	$text['t_gal9']  = "Häuptling";
	$text['t_gal10'] = "Siedler";

	// Teutons
	$text['t_ger1']  = "Keulenschwinger";
	$text['t_ger2']  = "Speerkämpfer";
	$text['t_ger3']  = "Axtkämpfer";
	$text['t_ger4']  = "Kundschafter";
	$text['t_ger5']  = "Paladin";
	$text['t_ger6']  = "Teutonen Reiter";
	$text['t_ger7']  = "Ramme";
	$text['t_ger8']  = "Katapult";
	$text['t_ger9']  = "Stammesführer";
	$text['t_ger10'] = "Siedler";

	// Troops (Multiple) @added 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1_x']  = "Legionäre";
	$text['t_rom2_x']  = "Prätorianer";
	$text['t_rom3_x']  = "Imperianer";
	$text['t_rom4_x']  = "Equites Legati";
	$text['t_rom5_x']  = "Equites Imperatoris";
	$text['t_rom6_x']  = "Equites Caesaris";
	$text['t_rom7_x']  = "Rammböcke";
	$text['t_rom8_x']  = "Feuerkatapulte";
	$text['t_rom9_x']  = "Senatoren";
	$text['t_rom10_x'] = "Siedler";

	// Gauls
	$text['t_gal1_x']  = "Phalanx";
	$text['t_gal2_x']  = "Schwertkämpfer";
	$text['t_gal3_x']  = "Späher";
	$text['t_gal4_x']  = "Theutates Blitze";
	$text['t_gal5_x']  = "Druidenreiter";
	$text['t_gal6_x']  = "Haeduaner";
	$text['t_gal7_x']  = "Rammhölzer";
	$text['t_gal8_x']  = "Kriegskatapulte";
	$text['t_gal9_x']  = "Häuptlinge";
	$text['t_gal10_x'] = "Siedler";

	// Teutons
	$text['t_ger1_x']  = "Keulenschwinger";
	$text['t_ger2_x']  = "Speerkämpfer";
	$text['t_ger3_x']  = "Axtkämpfer";
	$text['t_ger4_x']  = "Kundschafter";
	$text['t_ger5_x']  = "Paladine";
	$text['t_ger6_x']  = "Teutonen Reiter";
	$text['t_ger7_x']  = "Rammen";
	$text['t_ger8_x']  = "Katapulte";
	$text['t_ger9_x']  = "Stammesführer";
	$text['t_ger10_x'] = "Siedler";

	// Troop Types @added 2007/07/21 for RtWW Mod
	$text['t_sp'] = "Späher";
	$text['t_id'] = "Infantrie Defensiv";
	$text['t_io'] = "Infantrie Offensiv";
	$text['t_kd'] = "Kavallerie Defensiv";
	$text['t_ko'] = "Kavallerie Offensiv";
	$text['t_rm'] = "Rammen";
	$text['t_kt'] = "Katapulte";
	$text['t_ad'] = "Adeleinheiten";
	$text['t_gt'] = "Geräte";
	$text['t_hr'] = $text['troops_hero'];

	// Return Text
	return (!empty($text[$parameter])) ? $text[$parameter] : '';
}
?>
