<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @author belse <ake.svedin@gmail.com>
 * @package trooptool
 * @subpackage rtwwmod
 * @internal language: english
 * @todo replace by xml-based, full utf-8 layer
 * @since 2007/11/02 waRhawK converted to native utf-8 file, be sure your editor support utf-8 before editing this file
 */



/**
 * Delivering of language specific text
 *
 * @param string $parameter the label key to fetch
 * @return string the utf-8 encoded, localized text
 */
function text($parameter) {

	/**
	 * The language stack
	 * @var array
	 */
	$text=array();

	// Name of Translator
	$text['translator']="Belse";

	// About
	$text['about'] = 'Truppentool '.VERSION.
	((strlen(MOD_NAME))?' - '.MOD_NAME:'').
	((strlen(MOD_VERSION))?' '.MOD_VERSION:'').
	((strlen(MOD_AUTHOR))?' by '.MOD_AUTHOR:'').
	((strlen(MOD_UPDATE))?', last updated: '.MOD_UPDATE:'');

	// Language specific
	$text['locale'] = array('en_US', 'English');
	$text['date_short'] = 'Y/m/d';
	$text['date_picker_fmt'] = 'ymd';
	$text['date_picker_sep'] = '/';

	// Menu
	$text['admin.php']="Troop overview";
	$text['admin.php_hover']="See the troops of your alliance";

	$text['member.php']="Memberlist";
	$text['member.php_hover']="Administrate your members";

	$text['updater.php']="Update DB";
	$text['updater.php_hover']="Update database with new Travian world data.";

	$text['user.php']="My troops";
	$text['user.php_hover']="Enter new troops or update older ones";

	$text['hero.php']="My heroes";
	$text['hero.php_hover']="Own heroes";

	$text['dorf.php']="My villages";
	$text['dorf.php_hover']="Administrate your own villages";

	$text['umkreis.php']="Mission planner";
	$text['umkreis.php_hover']="Plan the troops' next mission";

	$text['stat.php']="Statistics";
	$text['stat.php_hover']="Statistics";

	$text['userconfig.php']="Preferences";
	$text['userconfig.php_hover']="Adapt the trooptool";

	$text['profil.php']="My profile";
	$text['profil.php_hover']="Change my account details";

	$text['faq.php']="FAQ";
	$text['faq.php_hover']="FAQ (frequently asked questions)";

	$text['logout.php']="Logout";
	$text['logout.php_hover']="Logout";

	$text['login']="Login";
	$text['login_hover']="Login";

	$text['register.php']="Register";
	$text['register.php_hover']="Create a new account";

	// Login
	$text['login_header']	= "Login";
	$text['login_name']		= "Username:";
	$text['login_pass']		= "Password:";
	$text['login_submit']	= "Login";
	$text['login_fehler1']	= "There is no such player in the database. Please check against any typo.";
	$text['login_inactive']	= "Your account got no clearance yet. Please be patient for the admin to do so. Contact him, if it takes too long for your opinion.";
	$text['login_wrong']	= "The given username/password combination is not correct. Click <a href=\"index.php?action=lostpw\">here</a>, if you lost your password and you would like to create to new one.";
	$text['login_success']	= "Hello <i>###PLAYER:NAME###</i>, your login was successful.";

	// Generic Errors
	$text['err_cookie']			= "Could not create a cookie for your session.<br />Please check your browser settings.";
	$text['err_sess_invalid']	= "Invalid session. Please login again.";
	$text['err_sess_timeout']	= "Your session timed out. Please login again.";

	// Lost Password
	$text['pw_header']="Forgotten you password?";
	$text['pw_text']="No problem, just enter you username and your email address, which you entered at registration. After a short time you will get an email with your new password.";
	$text['pw_name']="Username:";
	$text['pw_email']="Email:";
	$text['pw_submit']="Create new password";

	// Registration
	$text['register_header']="Registration";
	$text['register_name']="Username:";
	$text['register_pass']="Password:";
	$text['register_volk']="Tribe:";
	$text['register_submit']="Register";
	$text['register_error_1']="This username is already in the database. Please choose an other one.";
	$text['register_error_2']="Please fill all fields.";
	$text['register_error_21']="Error: You didn't enter a nickname.";
	$text['register_error_22']="Error: You didn't enter a password.";
	$text['register_error_3']="The registration process has succesfully completed. Now you have to wait until an admin activate you.";

	// Tribe
	$text['volk_rom'] = "Romans";
	$text['volk_gal'] = "Gauls";
	$text['volk_ger'] = "Teutons";

	// Actions
	$text['edit'] = "Edit";
	$text['del']  = "Delete";
	$text['fwd']  = "Continue";
	// Sortings @added 2007/08/02 for RtWW Mod
	$text['sort_asc']	= 'Ascending Order';
	$text['sort_desc']	= 'Descending Order';
	$text['sort_group']	= 'Grouping';

	// Quick Selects
	$text['list_members'] = "Player";
	$text['list_villages'] = "Villages";
	$text['list_groups'] = "Group";
	$text['list_allies'] = "Alliance";
	$text['list_empty'] = "(empty)";
	$text['list_na'] = "(not found)";
	$text['list_unknown'] = "(unknown)";

	$text['all_groups'] = "All groups";

	// Troop Overview
	$text['admin_header']     = "Troop overview";
	$text['admin_player']     = "Player";
	$text['admin_lastchange'] = "Last Update";
	$text['admin_sort']       = "Sort by";
	$text['admin_sum']        = "Sum";
	$text['lastlogin']        = "Last login";
	$text['admin_age']        = "Last updated at: %Y/%m/%d";
	$text['admin_age_1']      = "Troops are up to date (max. 3 days)";
	$text['admin_age_2']      = "Tropps are slighty outdated (3-5 days)";
	$text['admin_age_3']      = "Tropps are outdated (5-7 days)";
	$text['admin_age_4']      = "Troops are almost outdated (7-14 days)";
	$text['admin_age_5']      = "Tropps are extremely outdated (min. 2 weeks) or never configured";

	// User Profile
	$text['troops_detail'] = "Details";
	$text['troops_hero']   = "Hero";
	$text['troops_stat']   = "Statistics";
	$text['changepw_ok'] = "Error: The password you entered is incorrect. Can't set the new password.";
	$text['changepw_fehler'] = "Password was changed.";

	// Memberlist
	$text['memberlist_header']   = "Memberlist";
	$text['name']                = "Name";
	$text['member_header']       = "Registrations";
	$text['member_ok']           = "Accept registration";
	$text['member_no']           = "Reject registration";
	$text['member_date']         = "Date";
	$text['member_tribe']        = "Tribe";
	$text['member_nonewmembers'] = "There are no new registrations";
	$text['member_del']          = "Delete this member";
	$text['member_delq']         = "Do you really want to delete this player?";

	// Grouplist - RISI !!!
	$text['grouplist_header']   = "Grouplist";
	$text['header_group']   = "Groups";
	$text['members']   = "Members";
	$text['member_delmemq']         = "Do you really want to remove this player from this group?";
	$text['member_delgrpq']         = "Do you really want to remove this group?";
	$text['add_member'] = "Add member";
	$text['delete_group'] = "Delete group";
	$text['add_group'] = "Add group";
	$text['grp_name'] = "Name:";
	$text['grp_description'] = "Description:";



	// Access Control
    $text['rechte_0'] = "No access";
    $text['rechte_1'] = "Read only own datas";
    $text['rechte_2'] = "Read all datas";
    $text['rechte_3'] = "Read and edit datas";
    $text['member_0'] = "All troops";
    $text['member_1'] = "Memberlist";
    $text['member_2'] = "Troopsearch";
    $text['member_3'] = "Statistics";

	// Own Troops
	$text['user_askdel']      = "Do you really want to delete?";
	$text['user_header']      = "My troops";
	$text['user_her']         = "Origin";
	$text['user_sta']         = "Position";
	$text['user_units']       = "Troops	";
	$text['user_showforms']   = "Enter new troops";
	$text['user_form_header'] = "Enter troops";
	$text['user_hilfe_regex'] = "Go to Travian and the site of rally point in your village (e.g. http://s5.travian.com/build.php?id=39). Select all and copy (press Ctrl+A, then press Ctrl+C) on this site. Afterwards you go back to this site and paste (press Ctrl+V) in the input box. Now you have to enter the coordinates of origin and position. The troops will automatically be entered when you press &quot;save&quot;.";
	$text['user_manu']        = "Manual";
	$text['user_auto']        = "Auto";
	$text['user_manu_hint']   = "Enter manually";
	$text['user_auto_hint']   = "Enter automatically";

	// Ingame headlines from rally point; used for auto regex insert of troops
	$text['user_own_troops']    = "Own troops";
	$text['user_return_from']   = "Return from";
	$text['user_troops_for']    = "Reinforcement";
	$text['user_troops_of']     = "'s troops";
	$text['user_attack_to']     = "Attacking";
	$text['user_raid_to']       = "Raiding";
	$text['user_spy_at']        = "Scout";
	$text['user_explore_oasis'] = "Raid unoccupied oasis";

    // Own heroes
    $text['hero_header']      = "My heroes";
    $text['hero_name']        = "Name";
    $text['hero_typ']         = "Type";
    $text['hero_sta']         = "Position";
    $text['hero_off']         = "Offense";
    $text['hero_def']         = "Defense";
    $text['hero_off-bonus']   = "Off-bonus";
    $text['hero_def-bonus']   = "Def-bonus";
    $text['hero_showforms']   = "Enter another hero";
    $text['hero_form_header'] = "Enter hero";
	$text['hero_enable']      = "Activate hero";
	$text['hero_disable']     = "Deactivate hero";
	$text['hero_active']      = "This hero is active";
	$text['hero_inactive']    = "This hero is inactive and must be re-activated on the hero's mansion";
	$text['hero_state']		= "State";
	$text['hero_state_active']		= "Active";
	$text['hero_state_inactive']		= "Inactive";

	// Own villages
    $text['dorf_header']       = "My villages";
    $text['dorf_showforms']    = "Enter a new village";
	$text['dorf_autofill']    = "Fill in automatically";
    $text['dorf_form_header']  = "Enter village";
    $text['dorf_name']         = "Name";
    $text['dorf_koords']       = "Coordinates";
	$text['dorf_type']         = "Type";
	$text['dorf_type_0']       = "Default (further village)";
	$text['dorf_type_1']       = "Capital";
	$text['dorf_type_2']       = "Natars (WW village)";
	$text['dorf_type_3']       = "Conquered oasis";
	$text['dorf_layout']       = "Layout";
	$text['dorf_layout_0']     = "Default (4-4-4-6)";
	$text['dorf_layout_1']     = "Lumber (5-3-4-6)";
	$text['dorf_layout_2']     = "Clay (4-5-3-6)";
	$text['dorf_layout_3']     = "Iron (3-4-5-6)";
	$text['dorf_layout_4']     = "Crop (3-3-3-9)";
	$text['dorf_layout_5']     = "Crop (1-1-1-15)";
	$text['dorf_size']         = "Residents";
    $text['dorf_mauer']        = "Wall";
    $text['dorf_turnier']      = "Tournament square";
    $text['dorf_palast']       = "Palace";
    $text['dorf_residenz']     = "Residence";
    $text['dorf_kornspeicher'] = "Granary";
    $text['dorf_getreide']     = "Crop production";
	// Troop Planner @modified 2007/07/28 for RtWW Mod
	$text['umkreis_header']="Mission planner";
	$text['umkreis_col_val']="Value";
	$text['umkreis_col_sel']="Selection / Range";
	$text['umkreis_col_help']="Helpers / Details";
	$text['umkreis_target']="Coordinates";
	$text['umkreis_arrival_date']="Arrival date";
	$text['umkreis_arrival_time']="Arrival time";
	$text['umkreis_notimes_note1']="Displaying walk time durations only";
	$text['umkreis_notimes_note2']="Active timing to set arrival date/time";
	$text['umkreis_submit']="Calculate";
	$text['umkreis_date_today']="Today";
	$text['umkreis_date_cal']="Calendar";
	$text['umkreis_date_cal_hint']="Choose date from calendar";
	$text['umkreis_time_now']="Now";
	$text['umkreis_time_now_hint']="The current time";
	$text['umkreis_art']="Mission Type";
	$text['umkreis_art_def']="Defense";
	$text['umkreis_art_off']="Offense";
	$text['umkreis_art_adl']="Conquer";
	$text['umkreis_art_fak']="Fakes";
	$text['umkreis_art_oth']="Other";
	$text['umkreis_types_i']="Infantry only";
	$text['umkreis_types_k']="Cavalry only";
	$text['umkreis_types_g']="Siege weapons only";
	$text['umkreis_types_a']="Tribe leaders only";
	$text['umkreis_types_ik']="Infantry + cavalry";
	$text['umkreis_types_ig']="Infantry + siege weapons";
	$text['umkreis_types_kg']="Cavalry + siege weapons";
	$text['umkreis_types_ai']="With infantry";
	$text['umkreis_types_ak']="With cavalry";
	$text['umkreis_types_aik']="With infantry + cavalry";
	$text['umkreis_types_aikg']="With everything";
	$text['umkreis_types_ff']="Fast (Cavalry)";
	$text['umkreis_types_fm']="Medium (Infantry)";
	$text['umkreis_types_fs']="Slow (Siege weapons)";
	$text['umkreis_types_sp']="Spies";
	$text['umkreis_types_ss']="Small raid";
	$text['umkreis_types_ls']="Big raid";
	$text['umkreis_types_all']="Everything";
	$text['umkreis_types_both']="Both";
	$text['umkreis_troops']="Troop selection";
	$text['umkreis_troops_yes']="Yes";
	$text['umkreis_troops_yes_hint']="This type of unit is a must have";
	$text['umkreis_troops_no']="No";
	$text['umkreis_troops_no_hint']="This type of unit will be ignored";
	$text['umkreis_troops_opt']="If available";
	$text['umkreis_troops_opt_hint']="This type of unit is recognized, if available";
	$text['umkreis_troops_fit']="If suitable";
	$text['umkreis_troops_fit_hint']="This type of unit is recognized, if suitable for the mission";
	$text['umkreis_strength']="Troop strength";
	$text['umkreis_strength_cnt']="By number";
	$text['umkreis_strength_res']="By crop consumption";
	$text['umkreis_strength_cry']="By capacity";
	$text['umkreis_strength_single']="Fake";
	$text['umkreis_strength_all']="All";
	$text['umkreis_pool_limit']="Max. from stock";
	$text['umkreis_pool_limit_player']="Individualy";
	$text['umkreis_pool_limit_set']="Force";
	$text['umkreis_source']="Origin";
	$text['umkreis_source_all']="All (All alliances)";
	$text['umkreis_source_own']="Own";
	$text['umkreis_source_own_tr']="Own troops";
	$text['umkreis_source_own_gr']="Own group";
	$text['umkreis_source_own_al']="Own alliance";
	$text['umkreis_source_direct']="Origins only";
	$text['umkreis_source_direct_hint']="Include troops from production villages only";
	$text['umkreis_source_locations']="Include positions";
	$text['umkreis_source_locations_hint']="Also include troops with elsewhere deployments";
	$text['umkreis_distance']="Range limits";
	$text['umkreis_distance_dur']="Max. duration";
	$text['umkreis_distance_dis']="Max. distance";
	$text['umkreis_distance_no']="Unlimited";
	$text['umkreis_distance_yes']="Limit";
	$text['umkreis_distance_fields']="Fields";

	$text['umkreis_dev_note']="<b>Attention!</b> This page is not yet finished.<br />Not all functions are evaluated yet, you can neither force them nor go around.";

	$text['umkreis2_header'] = "Calculation for ###X###|###Y### at %Y/%m/%d, %H:%M:%S o'clock";
	$text['umkreis2_header_notimes'] = "Calculation for ###X###|###Y### (Durations only)";
	$text['umkreis2_src_direct']="Direct way from ###VIL1###";
	$text['umkreis2_src_location']="Routed way from ###VIL2### over ###VIL1###";
	$text['umkreis2_col_player']="Player";
	$text['umkreis2_col_squad']="Units";
	$text['umkreis2_col_start']="Kickoff";
	$text['umkreis2_col_duration']="Distance";

/*
	$text['umkreis_dauer']="Duration";
	$text['umkreis_start']="Starting time";
	$text['umkreis_ver']="Defense";
	$text['umkreis_ang']="Attack planning";
	$text['umkreis_own']="only own troops";
	$text['umkreis_header21']="Troops available within";
	$text['umkreis_header22']="hours";
	$text['umkreis_herkunft']="Origin";
	$text['umkreis_standort']="Position";
	$text['umkreis_anzahl']="Troops";
*/
	// Stats
	$text['stat_header']="Statistics";
	$text['stat_verlauf']="Troop progression";
	$text['stat_truppenver']="Troop arrangement";
	$text['stat_spielerver']="Tribe arrangement";

	// User Profile
	$text['profil_header'] = "My profile";
	$text['profil_name']   = "Username:";
	$text['profil_volk']   = "Tribe:";
	$text['profil_email']  = "Email address:";
	$text['profil_new']    = "New password:";
	$text['profil_old']    = "Old password:";
	$text['profil_ok']     = "The profile was changed successfully.";
	$text['profil_fehler'] = "You have entered a wrong password.";
	$text['save']          = "Save";

	// Setup /* temporarly disabled */
	$text['config_header'] = "Preferences";
	$text['config_note'] = "Attention! Global preferences! Not only your account!";
	$text['config_mail'] = "Link behind any username to contact player";
	$text['config_mail_0'] = "Do not show";
	$text['config_mail_1'] = "Show";
	$text['config_dorfname'] = "Coordinates/Village name";
	$text['config_dorfname_0'] = "Show only coordinates";
	$text['config_dorfname_1'] = "Show coordinates - Village name when mouseover";
	$text['config_dorfname_2'] = "Show village name - Coordinates when mouseover";
	$text['config_dorfname_3'] = "Coordinates behind village name";
	$text['config_dorfname_4'] = "Village name above coordinates";

	// FAQ
    $text['faq_haeder']="FAQ (frequently asked questions)";
    $text['faq_frage']="Question:";
    $text['faq_antwort']="Answer:";
    $text['faq_f1']="Why doesn't it work?";
    $text['faq_a1']="To make that Tool Work you need an up-to-date Browser. Javascript and Cookies have to be enabled.";
    $text['faq_f2']="How do I activate my members?";
    $text['faq_a2']="If a new member registered the nickname and the date of register are shown in the table on the right side. A click on the green checkmark activates the member. He/she is shown in the table on the left side from now on. If you want to delete the member just click on the red X.";
    $text['faq_f3']="What do the numbers with crosses and circles in the memberlist mean?";
    $text['faq_a3']="The red circles and green crosses below the numbers show if the player is allowed to call that sites. A green cross allows and a red circle forbides to enter the site. The numbers stand for the following sites: 1=All troops, 2=Memberlist, 3=Ambitsearch and 4=Statistics.";
    $text['faq_f4']="How do I enter my own troops?";
    $text['faq_a4']="On the left side in menu you can see the point own troops. After clicking that an overview of your own troops will apear. The table naturally looks empty if nothing is inserted. To enter data you have to click on &quot;enter new troops&quot; which is placed below. In the following form you enter on the top the X and Y coordinates of the troops' origin and where they are stationed at the moment. To enter the troops automatically go to the site of your rally point (e.g. http://s5.travian.com/build.php?id=39). There you have to press Ctrl+A and Ctrl+C. Afterwards you go back to &quot;own troops&quot; and press Ctrl+V in the big input box. If you prefer to enter your troops manually click on the little arrow. Enter the quantity and the unit type in the new boxes. Click on &quot;save&quot; to finish. If all was correct you can see your troops in the table.";
    $text['faq_f5']="How to edit my own troops?";
    $text['faq_a5']="Click the pencil to edit your troops in this line.";
    $text['faq_f6']="How to delete troops?";
    $text['faq_a6']="Click on the \"X\" and the data in this line will be deleted for ever.";
    $text['faq_f7']="How does the Ambitsearch work?";
    $text['faq_a7']="You have to enter the coordinates in the first two fields. The other three are reservered for the latest arrivaltime. Please enter the time like hour : minute : second. You have two optional fields in the second line. The first one includes spys. The second one shows the origin of the troops. This doesn't change the results. The troops have ever to follow that sheme: position -&gt; origin -&gt; target";
    $text['faq_f8']="Which troops are included in the Ambitsearch?";
    $text['faq_a8']="The Ambitsearch includes only troops which are more than 50 of a type in a village. A defense search includes Legionnaires, Praetorians and Equites Imperatoris, Phalanx, Druidriders and Haeduans, Spearfighters and Paladins. A search of offense calculates with Imperians, Equites Imperatoris and Equites Caesaris, Swordsmen, Theutates Thunder and Haeduans, Clubswingers, Axefighters, Paladins and Teuton Knights.";
    $text['faq_f9']="Question";
    $text['faq_a9']="Answer";

	// Logout
	$text['login_again']="login again";

	// Troops (Single) @modified 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1']  = "Legionnaire";
	$text['t_rom2']  = "Praetorian";
	$text['t_rom3']  = "Imperian";
	$text['t_rom4']  = "Equites Legati";
	$text['t_rom5']  = "Equites Imperatoris";
	$text['t_rom6']  = "Equites Caesaris";
	$text['t_rom7']  = "Battering ram";
	$text['t_rom8']  = "Fire catapult";
	$text['t_rom9']  = "Senator";
	$text['t_rom10'] = "Settler";

	// Gauls
	$text['t_gal1']  = "Phalanx";
	$text['t_gal2']  = "Swordsman";
	$text['t_gal3']  = "Pathfinder";
	$text['t_gal4']  = "Theutates Thunder";
	$text['t_gal5']  = "Druidrider";
	$text['t_gal6']  = "Haeduan";
	$text['t_gal7']  = "Ram";
	$text['t_gal8']  = "Trebuchet";
	$text['t_gal9']  = "Chieftain";
	$text['t_gal10'] = "Settler";

	// Teutons
	$text['t_ger1']  = "Clubswinger";
	$text['t_ger2']  = "Spearfighter";
	$text['t_ger3']  = "Axefighter";
	$text['t_ger4']  = "Scout";
	$text['t_ger5']  = "Paladin";
	$text['t_ger6']  = "Teuton Knight";
	$text['t_ger7']  = "Ram";
	$text['t_ger8']  = "Catapult";
	$text['t_ger9']  = "Chief";
	$text['t_ger10'] = "Settler";

	// Troops (Multiple) @added 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1_x']  = "Legionnaires";
	$text['t_rom2_x']  = "Praetorians";
	$text['t_rom3_x']  = "Imperians";
	$text['t_rom4_x']  = "Equites Legati";
	$text['t_rom5_x']  = "Equites Imperatoris";
	$text['t_rom6_x']  = "Equites Caesaris";
	$text['t_rom7_x']  = "Battering rams";
	$text['t_rom8_x']  = "Fire catapults";
	$text['t_rom9_x']  = "Senators";
	$text['t_rom10_x'] = "Settlers";

	// Gauls
	$text['t_gal1_x']  = "Phalanxes";
	$text['t_gal2_x']  = "Swordsmen";
	$text['t_gal3_x']  = "Pathfinders";
	$text['t_gal4_x']  = "Theutates Thunder";
	$text['t_gal5_x']  = "Druidriders";
	$text['t_gal6_x']  = "Haeduans";
	$text['t_gal7_x']  = "Rams";
	$text['t_gal8_x']  = "Trebuchets";
	$text['t_gal9_x']  = "Chieftains";
	$text['t_gal10_x'] = "Settlers";

	// Teutons
	$text['t_ger1_x']  = "Clubswingers";
	$text['t_ger2_x']  = "Spearfighters";
	$text['t_ger3_x']  = "Axefighters";
	$text['t_ger4_x']  = "Scouts";
	$text['t_ger5_x']  = "Paladins";
	$text['t_ger6_x']  = "Teutonic Knights";
	$text['t_ger7_x']  = "Rams";
	$text['t_ger8_x']  = "Catapults";
	$text['t_ger9_x']  = "Chiefs";
	$text['t_ger10_x'] = "Settlers";


	// Troop Types @added 2007/07/21 for RtWW Mod
	$text['t_sp'] = "Spies";
	$text['t_id'] = "Defense infantry";
	$text['t_io'] = "Offense infantry";
	$text['t_kd'] = "Defense cavalry";
	$text['t_ko'] = "Offense cavalry";
	$text['t_rm'] = "Rams";
	$text['t_kt'] = "Catapults";
	$text['t_ad'] = "Tribe leaders";
	$text['t_gt'] = "Siege weapons";
	$text['t_hr'] = $text['troops_hero'];

	// auth key
	$text['auth_header']       = "Authentification key";
	$text['auth_current']       = "Authentification key";
	$text['auth_submit']       = "Generate new key";

	//Updateing troops
	$text['send_success']	= "Trooptool says: Your troops were updated successfully.";
	$text['send_error']	= "Trooptool says: Error! Your troops were not updated.";

	// Return Text
	return (!empty($text[$parameter])) ? $text[$parameter] : '';
}
?>
