<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @author zetor <smoked_guy@hotmail.com>
 * @package trooptool
 * @subpackage rtwwmod
 * @internal language: italian
 * @todo replace by xml-based, full utf-8 layer
 * @since 2007/11/02 waRhawK converted to native utf-8 file, be sure your editor support utf-8 before editing this file
 */



/**
 * Delivering of language specific text
 *
 * @param string $parameter the label key to fetch
 * @return string the utf-8 encoded, localized text
 */
function text($parameter) {

	/**
	 * The language stack
	 * @var array
	 */
	$text=array();

	// Name of Translator
	$text['translator']="11994, Zetor";

	// About
	$text['about'] = 'Truppentool '.VERSION.
	((strlen(MOD_NAME))?' - '.MOD_NAME:'').
	((strlen(MOD_VERSION))?' '.MOD_VERSION:'').
	((strlen(MOD_AUTHOR))?' by '.MOD_AUTHOR:'').
	((strlen(MOD_UPDATE))?', last updated: '.MOD_UPDATE:'');

	// Language specific
	$text['locale'] = array('it_IT', 'Italian');
	$text['date_short'] = 'd.m.Y';
	$text['date_picker_fmt'] = 'dmy';
	$text['date_picker_sep'] = '.';
	
	// Menu
	$text['admin.php']="<B><I>Truppe Ally</I></B>";
	$text['admin.php_hover']="Vedi tutte le truppe dell'alleanza";

	$text['member.php']="<B><I>Lista Membri</I></B>";
	$text['member.php_hover']="Amministra Lista Membri";

	$text['user.php']="Le mie Truppe";
	$text['user.php_hover']="Amministra le mie Truppe";

	$text['hero.php']="I miei Eroi";
	$text['hero.php_hover']="Amministra i miei Eroi";

	$text['dorf.php']="I miei villaggi";
	$text['dorf.php_hover']="Amministra i miei Villaggi";

	$text['umkreis.php']="<B><I>TrovaTruppe</I></B>";
	$text['umkreis.php_hover']="Pianifica attacchi/difese";

	$text['stat.php']="<B><I>Statistiche</I></B>";
	$text['stat.php_hover']="Statistiche";

	$text['userconfig.php']="<B><I>Preferenze</I></B>";
	$text['userconfig.php_hover']="Opzioni di Troopentool";

	$text['profil.php']="Il mio Profilo";
	$text['profil.php_hover']="Cambia i dati del profilo";

	$text['faq.php']="FAQ";
	$text['faq.php_hover']="FAQ (domande frequenti)";

	$text['logout.php']="Logout";
	$text['logout.php_hover']="Esci";

	$text['login']="Login";
	$text['login_hover']="Login";

	$text['register.php']="Registrati";
	$text['register.php_hover']="Crea il tuo nuovo utente";

	// Login
	$text['login_header']	= "Login";
	$text['login_name']		= "Username:";
	$text['login_pass']		= "Password:";
	$text['login_submit']	= "Login";
	$text['login_fehler1']	= '<p>Non riesco a trovare la tua username nel database.<p>Se non sei ancora registrato,<br>effettua ora la registrazione<br>usando "Registrati" qui a sinistra.';
	$text['login_inactive']	= "Il tuo account non e' stato ancora attivato. Domanda al capo della tua alleanza, se non vieni attivato entro 24 ore dall'iscrizione.";
	$text['login_wrong']	= "<p>La password inserita non e' corretta.<br>Usa questo <a href=\"index.php?action=lostpw\">link</a>, se vuoi riceverne una nuova.";
	$text['login_success']	= "Ciao <i>###PLAYER:NAME###</i>, ti sei autenticato con successo!";

	// Generic Errors
	$text['err_cookie']			= "Non posso creare un cookie per la tua sessione.<br />Controlla le opzioni del tuo browser.";
	$text['err_sess_invalid']	= "Sessions non piu' valida. Per favore, rifai il login.";
	$text['err_sess_timeout']	= "Sessione scaduta. Per favore, rifai il login.";

	// Lost Password
	$text['pw_header']="Dimenticato la password?";
	$text['pw_text']="Nessun problema,<br>inserisci il tuo username ed il tuo indirizzo e-mail<br>(lo stesso che hai inserito in fase di registrazione).<br>Dopo alcuni istanti riceverai (via e-mail) una nuova password.";
	$text['pw_name']="Username:";
	$text['pw_email']="e-mail:";
	$text['pw_submit']="Crea una nuova password";

	// Registration
	$text['register_header']="Registration";
	$text['register_name']="Username:";
	$text['register_pass']="Password:";
	$text['register_volk']="Tribu':";
	$text['register_submit']="Registrati";
	$text['register_error_1']="Questo nick e' gia' presente nel database. Perfavore, scegline un altro.";
	$text['register_error_2']="Per favore, riempi tutti i campi.";
	$text['register_error_21']="Errore: Non hai inserito una username.";
	$text['register_error_22']="Errore: Non hai inserito una password.";
	$text['register_error_3']="La registrazione e' stata completata con successo. Ora devi aspettare che un admin ti attivi.";

	// Tribe
	$text['volk_rom'] = "Romani";
	$text['volk_gal'] = "Galli";
	$text['volk_ger'] = "Teutoni";

	// Actions
	$text['edit'] = "Modifica";
	$text['del']  = "Elimina";
	$text['fwd']  = "Continua";
	
	// Sortings @added 2007/08/02 for RtWW Mod
	$text['sort_asc']	= 'Ordine ascendente';
	$text['sort_desc']	= 'Ordine Discendente';
	$text['sort_group']	= 'Ordina per Gruppo';

	// Quick Selects
	$text['list_members'] = "Giocatore";
	$text['list_villages'] = "Villaggi";
	$text['list_groups'] = "Gruppo";
	$text['list_allies'] = "Alleanza";
	$text['list_empty'] = "(vuoto)";
	$text['list_na'] = "(non trovato)";
	$text['list_unknown'] = "(sconosciuto)";

	// Troop Overview
	$text['admin_header']     = "Riassunto Truppe Ally";
	$text['admin_player']     = "Giocatore";
	$text['admin_lastchange'] = "Ultimo Aggiornamento";
	$text['admin_sort']       = "Riordina per";
	$text['admin_sum']        = "Totale";
	$text['lastlogin']        = "Ultimo Login";
	$text['admin_age']        = "Ultimo aggiornamento il: %Y/%m/%d";
	$text['admin_age_1']      = "Le truppe sono aggiornate (max. 3 giorni)";
	$text['admin_age_2']      = "Le truppe sono quasi aggiornate  (3-5 giorni)";
	$text['admin_age_3']      = "Le truppe sono state aggiornate tempo fa (5-7 giorni)";
	$text['admin_age_4']      = "Le truppe NON sono piu' state aggiornate  (7-14 giorni)";
	$text['admin_age_5']      = "Le truppe NON sono per nulla state aggiornate  (min. 2 settimane) o mai inserite";

	// User Profile
	$text['troops_detail'] = "Dettagli";
	$text['troops_hero']   = "Eroe";
	$text['troops_stat']   = "Statistiche";

	// Memberlist
	$text['memberlist_header']   = "Lista Membri";
	$text['name']                = "UserName";
	$text['member_header']       = "Registrazioni";
	$text['member_ok']           = "Accetta registrazioni";
	$text['member_no']           = "Rifiuta registrazioni";
	$text['member_date']         = "Data";
	$text['member_tribe']        = "Tribu'";
	$text['member_nonewmembers'] = "Nessuno vuole iscriversi :P";
	$text['member_del']          = "Elimina questo giocatore";
	$text['member_delq']         = "Sei sicuro di voler eliminare questo giocatore?";

	// Access Control
  $text['rechte_0'] = "Nessun Accesso";
  $text['rechte_1'] = "Leggi solo i propri dati";
  $text['rechte_2'] = "Leggi tutti i dati";
  $text['rechte_3'] = "Leggi e modifica i dati";
  $text['member_0'] = "Tutte le Truppe";
  $text['member_1'] = "Lista Membri";
  $text['member_2'] = "TrovaTruppe";
  $text['member_3'] = "Statistiche";

	// Own Troops
	$text['user_askdel']      = "Sei sicuro di voler cancellare?";
	$text['user_header']      = "Proprie Truppe";
	$text['user_her']         = "Create in";
	$text['user_sta']         = "Stanno in";
	$text['user_units']       = "Truppe	";
	$text['user_showforms']   = "Inserisci nuove truppe";
	$text['user_form_header'] = "Inserisci truppe";
	$text['user_hilfe_regex'] = "Apri Travian, e vai alla caserma (per esempio http://s1.travian.it/build.php?id=39). Qui premi Ctrl+A e Ctrl+C. Dopo, torna in questo sito e premi Ctrl+V nel campo vuoto. Poi devi inserire le coordinate di dove hai creato le truppe e dove stanno ora. Le truppe verranno inserite automaticamente.";
	$text['user_manu']        = "Manuale";
	$text['user_auto']        = "Auto";
	$text['user_manu_hint']   = "Inserisci Manualmente";
  $text['user_auto_hint']   = "Inserisci Automaticamente";

	// Ingame headlines from rally point; used for auto regex insert of troops
	$text['user_own_troops']    = "Proprie truppe";
	$text['user_return_from']   = "Ritorna da";
	$text['user_troops_for']    = "Rinforzi per";
	$text['user_troops_of']     = "Truppe di";
	$text['user_attack_to']     = "Attacco a";
	$text['user_raid_to']       = "Raid verso";
	$text['user_spy_at']        = "Spia";
	$text['user_explore_oasis'] = "Esplora l'";

  // Own heroes
  $text['hero_header']      = "I miei Eroi";
  $text['hero_name']        = "Nome";
  $text['hero_typ']         = "Tipo";
  $text['hero_sta']         = "Posizione";
  $text['hero_off']         = "Offesa";
  $text['hero_def']         = "Difesa";
  $text['hero_off-bonus']   = "Off-bonus";
  $text['hero_def-bonus']   = "Dif-bonus";
  $text['hero_showforms']   = "Inserisci un altro Eroe";
  $text['hero_form_header'] = "Inserisci Eroe";
  $text['hero_enable']      = "Attiva l'Eroe";
  $text['hero_disable']     = "Disattiva l'Eroe";
  $text['hero_active']      = "Questo Eroe e' attivo";
  $text['hero_inactive']    = "Questo Eroe NON e' attivo e deve essere riattivato nel Circolo degli Eroi";
	$text['hero_state']		= "State";
	$text['hero_state_active']		= "Active";
	$text['hero_state_inactive']		= "Inactive";

	// Own villages
  $text['dorf_header']       = "I miei villaggi";
  $text['dorf_showforms']    = "Inserisci un nuovo villaggio";
  $text['dorf_form_header']  = "Inserisci villaggio";
  $text['dorf_name']         = "Nome";
  $text['dorf_koords']       = "Coordinate";
  $text['dorf_type']         = "Tipo";
  $text['dorf_type_0']       = "Villo normale";
  $text['dorf_type_1']       = "Villo Capitale";
  $text['dorf_type_2']       = "Villo Natars";
  $text['dorf_type_3']       = "Oasi conquistata";
  $text['dorf_layout']       = "Campi villo";
  $text['dorf_layout_0']     = "Normale (4-4-4-6)";
  $text['dorf_layout_1']     = "Piu' Legno (5-3-4-6)";
  $text['dorf_layout_2']     = "Piu' Argilla (4-5-3-6)";
  $text['dorf_layout_3']     = "Piu' Ferro (3-4-5-6)";
  $text['dorf_layout_4']     = "Pulcino (3-3-3-9)";
  $text['dorf_layout_5']     = "Canarino (1-1-1-15)";
  $text['dorf_size']         = "Popolazione";
  $text['dorf_mauer']        = "Muro";
  $text['dorf_turnier']      = "Arena";
  $text['dorf_palast']       = "Castello";
  $text['dorf_residenz']     = "Residenza";
  $text['dorf_kornspeicher'] = "Granaio";
  $text['dorf_getreide']     = "Prod. oraria Grano";
    
	// Troop Planner @modified 2007/07/28 for RtWW Mod
	$text['umkreis_header']="TrovaTruppe";
	$text['umkreis_col_val']="";
	$text['umkreis_col_sel']="";
	$text['umkreis_col_help']="";
	$text['umkreis_target']="Coordinate obiettivo";
	$text['umkreis_arrival_date']="Data di arrivo";
	$text['umkreis_arrival_time']="Ora di arrivo";
	$text['umkreis_notimes_note1']="Displaying walk time durations only";
	$text['umkreis_notimes_note2']="Active timing to set arrival date/time";
	$text['umkreis_submit']="Calcola";
	$text['umkreis_date_today']="Oggi";
	$text['umkreis_date_cal']="Calendario";
	$text['umkreis_date_cal_hint']="Scegli una data dal calendario";
	$text['umkreis_time_now']="Ora";
	$text['umkreis_time_now_hint']="L'ora corrente";
	$text['umkreis_art']="Attacco/Difesa<br>Conquista";
	$text['umkreis_art_def']="Difesa";
	$text['umkreis_art_off']="Attacco";
	$text['umkreis_art_adl']="Conquista";
	$text['umkreis_art_fak']="Fakes";
	$text['umkreis_art_oth']="Altro";
	$text['umkreis_types_i']="Solo fanteria";
	$text['umkreis_types_k']="Solo cavalleria";
	$text['umkreis_types_g']="Solo arieti/cata";
	$text['umkreis_types_a']="Solo Capi tribu'";
	$text['umkreis_types_ik']="Fanteria + cavalleria";
	$text['umkreis_types_ig']="Fanteria + arieti/cata";
	$text['umkreis_types_kg']="Cavalleria + arieti/cata";
	$text['umkreis_types_ai']="Con fanteria";
	$text['umkreis_types_ak']="Con cavalleria";
	$text['umkreis_types_aik']="Con fanteria + cavalleria";
	$text['umkreis_types_aikg']="Con tutto";
	$text['umkreis_types_ff']="Veloci (Cavalleria)";
	$text['umkreis_types_fm']="Medi (Fanteria)";
	$text['umkreis_types_fs']="Lenti (Arieti/cata)";
	$text['umkreis_types_sp']="Spie";
	$text['umkreis_types_ss']="Piccolo raid";
	$text['umkreis_types_ls']="Grande raid";
	$text['umkreis_types_all']="Tutto";
	$text['umkreis_types_both']="Entrambi";
	$text['umkreis_troops']="Selezione truppe";
	$text['umkreis_troops_yes']="Si'";
	$text['umkreis_troops_yes_hint']="Questo tipo di unita' si deve usare";
	$text['umkreis_troops_no']="No";
	$text['umkreis_troops_no_hint']="Questo tipo di unita' NON si deve usare";
	$text['umkreis_troops_opt']="Se disponibile";
	$text['umkreis_troops_opt_hint']="Questo tipo di unita' si deve usare, se e' presente";
	$text['umkreis_troops_fit']="Se indicato";
	$text['umkreis_troops_fit_hint']="Questo tipo di unita' si deve usare, se e' indicata";
	$text['umkreis_strength']="Forza truppe";
	$text['umkreis_strength_cnt']="Per numero";
	$text['umkreis_strength_res']="Per consumo di grano";
	$text['umkreis_strength_cry']="Per capacita'";
	$text['umkreis_strength_single']="Fake";
	$text['umkreis_strength_all']="Massimo";
	$text['umkreis_pool_limit']="Max. from stock";
	$text['umkreis_pool_limit_player']="Individualy";
	$text['umkreis_pool_limit_set']="Force";
	$text['umkreis_source']="Origine";
	$text['umkreis_source_all']="Tutti (tutte le alleanze)";
	$text['umkreis_source_own']="Proprie";
	$text['umkreis_source_own_tr']="Proprie truppe";
	$text['umkreis_source_own_gr']="Proprio gruppo";
	$text['umkreis_source_own_al']="Propria alleanza";
	$text['umkreis_source_direct']="Solo dal villo di origine";
	$text['umkreis_source_direct_hint']="Includi truppe che sono nei villaggi che le hanno create";
	$text['umkreis_source_locations']="Includi truppe in rinforzo";
	$text['umkreis_source_locations_hint']="Includi truppe che sono attualmente in rinforzo in altri villaggi";
	$text['umkreis_distance']="Limiti massimi";
	$text['umkreis_distance_dur']="Max. durata";
	$text['umkreis_distance_dis']="Max. distanza";
	$text['umkreis_distance_no']="Illimitata";
	$text['umkreis_distance_yes']="Limite";
	$text['umkreis_distance_fields']="caselle";

  $text['umkreis_dev_note']="<b>Attenzione!</b> Questa pagina non e' ancora stata finita.<br> 
    Non tutte le funzionalita' sono state realizzate e/o provate.";

	$text['umkreis2_header'] = "Calcolo per ###X###|###Y### il %d/%m/%Y alle %H:%M:%S in punto!";
	$text['umkreis2_header_notimes'] = "Calcolo per ###X###|###Y### (Durations only)";
	$text['umkreis2_src_direct']="Strada diretta per ###VIL1###";
	$text['umkreis2_src_location']="Strada attraverso ###VIL2### per ###VIL1###";
	$text['umkreis2_col_player']="Giocatore";
	$text['umkreis2_col_squad']="Unita&#39;";
	$text['umkreis2_col_start']="Partenza";
	$text['umkreis2_col_duration']="Distanza";

/*
	$text['umkreis_dauer']="Duration";
	$text['umkreis_start']="Starting time";
	$text['umkreis_ver']="Defense";
	$text['umkreis_ang']="Attack planning";
	$text['umkreis_own']="only own troops";
	$text['umkreis_header21']="Troops available within";
	$text['umkreis_header22']="hours";
	$text['umkreis_herkunft']="Origin";
	$text['umkreis_standort']="Position";
	$text['umkreis_anzahl']="Troops";
*/
	// Stats
	$text['stat_header']="Statistiche";
	$text['stat_verlauf']="Sviluppo Truppe";
	$text['stat_truppenver']="Composizione Truppe/Tribu'";
	$text['stat_spielerver']="Composizione Giocatori/Tribu'";

	// User Profile
	$text['profil_header'] = "Il mio profilo";
	$text['profil_name']   = "Username:";
	$text['profil_volk']   = "Tribu':";
	$text['profil_email']  = "Indirizzo e-mail:";
	$text['profil_new']    = "Nuova password:";
	$text['profil_old']    = "Vecchia password:";
	$text['profil_ok']     = "La password e' stata cambiata.";
	$text['profil_fehler'] = "Password errata.";
	$text['save']          = "Salva";

	// Setup /* temporarly disabled */
	$text['config_header'] = "Preferenze";
	$text['config_note'] = "Attenzione! Preferenze GLOBALI! Non solo per il tuo user!";
	$text['config_mail'] = "Link dopo ogni username per contattare giocatore";
	$text['config_mail_0'] = "Non mostrare";
	$text['config_mail_1'] = "Mostra";
	$text['config_dorfname'] = "Mostra Coordinate/Nome Villaggio";
	$text['config_dorfname_0'] = "Mostra solo Coordinate";
	$text['config_dorfname_1'] = "Mostra solo Coordinate - Nome Villaggio se mouse sopra";
	$text['config_dorfname_2'] = "Mostra Nome Villaggio - Coordinate se mouse sopra";
	$text['config_dorfname_3'] = "Coordinate dopo Nome Villaggio";
	$text['config_dorfname_4'] = "Nome Villaggio sopra Coordinate";

	// FAQ
  $text['faq_haeder']="FAQ (domande frequenti)";
  $text['faq_frage']="Domanda:";
  $text['faq_antwort']="Risposta:";
  $text['faq_f1']="Perche' non funziona?";
  $text['faq_a1']="Per farlo funzionare, devi avere un Browser aggiornato. Javascript e Cookies
          devono essere abilitati.";
  $text['faq_f2']="Come attivo i miei membri?";
  $text['faq_a2']="Se un nuovo membro si registra, vedrai il suo nick e la data di registrazione nella tabella a destra.
       Cliccando sulla crocetta verde, attiverai il membro. Dopodiche' lo vedrai nella tabella a sinistra.
       Se vuoi cancellarlo, basta che clicchi sulla X rossa.";
  $text['faq_f3']="Cosa significano i numeri con le croci e i cerchi nella Lista Membri?";
  $text['faq_a3']="I cerchi verdi e le croci rosse sotto i numeri indicano se al membro e' permesso usare quella funzione.
       Un cerchio verde permette e una croce rossa proibisce.
       I numeri indicano i vari diritti: 1=Vedere tutte le truppe, 2=Vedere la Lista Membri, 3=Usare il TrovaTruppe e 4=Vedere le Statistiche.";
  $text['faq_f4']="Come inserisco le mie truppe?";
  $text['faq_a4']="Nel menu' a sinistra puoi vedere Proprie Truppe. <br>Dopo averci cliccato ti apparira' una nuova finestra.
       <br>La tabella sara' ovviamente vuota se non ci si ha inserito nulla. <br>Per inserire i dati devi cliccare su Inserisci nuove truppe che trovi poco piu' sotto.
       <br>Qui dovrai inserire le coordinate dove sono state addestrate le truppe e quelle di dove sono ora (per esempio in rinforzo ad un altro villaggio)
       <br>Per inserire le tue truppe automaticamente, vai alla caserma (per esempio http://s1.travian.it/build.php?id=39)e premi Ctrl+A e Ctrl+C.
       <br>Dopo torna dov'eri e premi Ctrl+V nella casella vuota. 
       <br>Se preferisci inserirle manualmente, premi sulla piccola freccia. Inserisci la quantita' e il tipo di truppe nelle caselle.
       <br>Clicca su Salva per concludere. 
       <br>Se hai fatto correttamente, vedrai le tue truppe nella tabella.";
  $text['faq_f5']="Come modifico/AGGIORNO le mie truppe?";
  $text['faq_a5']="Clicca sulla matita vicino alle tue truppe per modificarle/aggiornarle.";
  $text['faq_f6']="Come cancello le mie truppe?";
  $text['faq_a6']="Clicca sulla X rossa per cancellarle.";
  $text['faq_f7']="Come funziona il TrovaTruppe?";
  $text['faq_a7']="Devi inserire le coordinate dell'obiettivo di defesa/attacco nei primi due campi. 
       <br>Poi ci sono altri campi:
       -L'orario d'arrivo- Inserisci l'orario in questo modo ore : minuti : secondi.
       -Esploratori (opzionale)-
       -Coordinate di creazione (opzionale)-
       Le truppe seguiranno quest'ordine: Posizione attuale -&gt; Posizione di creazione -&gt; Obiettivo";
  $text['faq_f8']="Che truppe sono incluse nel TrovaTruppe?";
  $text['faq_a8']="Il TrovaTruppe include solo le truppe che sono piÃƒÆ’Ã‚Â¹ di 50 per tipo in un villaggio.
        Una ricerca difensiva includera' Legionari, Pretoriani e Imperiani a Cavallo, Lancieri , Cavalleria di Difesa e Cavalleria Avanzata, Lancieri e Paladini.
        Una ricerca d'attacco includera' Imperiani, Imperiani a Cavallo e Cavalleria Romana, Combattenti con Spada, Cavalleria Gallica e Cavalleria Avanzata,
        Combattenti, Combattenti con Ascia, Paladini e Cavalleria Teutonica.";
  $text['faq_f9']="Domanda";
  $text['faq_a9']="Risposta";

	// Logout
	$text['login_again']="Ritorna alla pagina di login.";

	// Troops (Single) @modified 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1']  = "Legionario";
	$text['t_rom2']  = "Pretoriano";
	$text['t_rom3']  = "Imperiano";
	$text['t_rom4']  = "Legionario a Cavallo";
	$text['t_rom5']  = "Imperiano a Cavallo";
	$text['t_rom6']  = "Cavalleria Romana";
	$text['t_rom7']  = "Ariete";
	$text['t_rom8']  = "Catapulta";
	$text['t_rom9']  = "Senatore";
	$text['t_rom10'] = "Decurione";

	// Gauls
	$text['t_gal1']  = "Lanciere";
	$text['t_gal2']  = "Combattente con Spada";
	$text['t_gal3']  = "Esploratore";
	$text['t_gal4']  = "Cavalleria Gallica";
	$text['t_gal5']  = "Cavalleria di Difesa";
	$text['t_gal6']  = "Cavalleria Avanzata";
	$text['t_gal7']  = "Ariete";
	$text['t_gal8']  = "Catapulta";
	$text['t_gal9']  = "Capo Tribu\'";
	$text['t_gal10'] = "Decurione";

	// Teutons
	$text['t_ger1']  = "Combattente";
	$text['t_ger2']  = "Lanciere";
	$text['t_ger3']  = "Combattente con Ascia";
	$text['t_ger4']  = "Esploratore";
	$text['t_ger5']  = "Paladino";
	$text['t_ger6']  = "Cavalleria Teutonica";
	$text['t_ger7']  = "Ariete";
	$text['t_ger8']  = "Catapulta";
	$text['t_ger9']  = "Comandante";
	$text['t_ger10'] = "Decurione";

	// Troops (Multiple) @added 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1_x']  = "Legionari";
	$text['t_rom2_x']  = "Pretoriani";
	$text['t_rom3_x']  = "Imperiani";
	$text['t_rom4_x']  = "Legionari a Cavallo";
	$text['t_rom5_x']  = "Imperiani a Cavallo";
	$text['t_rom6_x']  = "Cavalleria Romana";
	$text['t_rom7_x']  = "Arieti";
	$text['t_rom8_x']  = "Catapulte";
	$text['t_rom9_x']  = "Senatori";
	$text['t_rom10_x'] = "Decurioni";

	// Gauls
	$text['t_gal1_x']  = "Lancieri";
	$text['t_gal2_x']  = "Combattenti con Spada";
	$text['t_gal3_x']  = "Esploratori";
	$text['t_gal4_x']  = "Cavalleria Gallica";
	$text['t_gal5_x']  = "Cavalleria di Difesa";
	$text['t_gal6_x']  = "Cavalleria Avanzata";
	$text['t_gal7_x']  = "Arieti";
	$text['t_gal8_x']  = "Catapulte";
	$text['t_gal9_x']  = "Capi Tribu\'";
	$text['t_gal10_x'] = "Decurioni";

	// Teutons
	$text['t_ger1_x']  = "Combattenti";
	$text['t_ger2_x']  = "Lancieri";
	$text['t_ger3_x']  = "Combattenti con Ascia";
	$text['t_ger4_x']  = "Esploratori";
	$text['t_ger5_x']  = "Paladini";
	$text['t_ger6_x']  = "Cavalleria Teutonica";
	$text['t_ger7_x']  = "Arieti";
	$text['t_ger8_x']  = "Catapulte";
	$text['t_ger9_x']  = "Comandanti";
	$text['t_ger10_x'] = "Decurioni";


	// Troop Types @added 2007/07/21 for RtWW Mod
	$text['t_sp'] = "Spie";
	$text['t_id'] = "Fanteria da Difesa";
	$text['t_io'] = "Fanteria d'Attacco";
	$text['t_kd'] = "Cavalleria da Difesa";
	$text['t_ko'] = "Cavalleria d'Attacco";
	$text['t_rm'] = "Arieti";
	$text['t_kt'] = "Catapulte";
	$text['t_ad'] = "Capi Tribu&#39;";
	$text['t_gt'] = "Armi da Assedio";
	$text['t_hr'] = $text['troops_hero'];

	// Return Text
	return (!empty($text[$parameter])) ? $text[$parameter] : '';
}
?>
