<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @author Koen <koenkraaijvanger@hotmail.com>
 * @package trooptool
 * @subpackage rtwwmod
 * @internal language: dutch
 * @todo replace by xml-based, full utf-8 layer
 */



/**
 * Delivering of language specific text
 *
 * @param string $parameter the label key to fetch
 * @return string the utf-8 encoded, localized text
 */
function text($parameter) {

	/**
	 * The language stack
	 * @var array
	 */
	$text=array();

	// Name of Translator
	$text['translator']="Koen";

	// About
	$text['about'] = 'Truppentool '.VERSION.
	((mb_strlen(MOD_NAME))?' - '.MOD_NAME:'').
	((mb_strlen(MOD_VERSION))?' '.MOD_VERSION:'').
	((mb_strlen(MOD_AUTHOR))?' von '.MOD_AUTHOR:'').
	((mb_strlen(MOD_UPDATE))?', letztes Update: '.MOD_UPDATE:'');

	// Language specific
	$text['locale'] = array('nl_NL', 'nl_NL@EURO', 'nl_NL@ISO-8859-15', 'Dutch');
	$text['date_short'] = 'd.m.Y';
	$text['date_picker_fmt'] = 'dmy';
	$text['date_picker_sep'] = '.';

	// Menu
	$text['admin.php']="Troepen overzicht";
	$text['admin.php_hover']="Bekijk de troepen van je alliantie";

	$text['member.php']="Ledenlijst";
	$text['member.php_hover']="Lijst van leden en hun rechten";

	$text['user.php']="Mijn troepen";
	$text['user.php_hover']="Voer nieuwe troepen in of update de oude";

	$text['hero.php']="Mijn helden";
	$text['hero.php_hover']="Eigen helden";

	$text['dorf.php']="Mijn dorpen";
	$text['dorf.php_hover']="Eigen dorpen";

	$text['umkreis.php']="Missie planner";
	$text['umkreis.php_hover']="Plan de volgende missie voor de troepen";

	$text['stat.php']="Statistieken";
	$text['stat.php_hover']="Statistieken";

	$text['userconfig.php']="Voorkeuren";
	$text['userconfig.php_hover']="Verander de tool naar je eigen wensen";

	$text['profil.php']="Mijn profiel";
	$text['profil.php_hover']="Verander je account gegevens";

	$text['faq.php']="FAQ";
	$text['faq.php_hover']="FAQ (frequently asked questions/veelgestelde vragen)";

	$text['logout.php']="Uitloggen";
	$text['logout.php_hover']="Uitloggen";

	$text['login']="Inloggen";
	$text['login_hover']="Inloggen";

	$text['register.php']="Registreren";
	$text['register.php_hover']="Maak een nieuwe account";

	// Login
	$text['login_header']	= "Inloggen";
	$text['login_name']		= "Naam:";
	$text['login_pass']		= "Wachtwoord:";
	$text['login_submit']	= "Log in";
	$text['login_fehler1']	= "Gebruiker bestaat niet! ";
	$text['login_inactive']	= "Je account is nog niet geactiveerd. Je moet wachten tot de Admin dit doet.";
	$text['login_wrong']	= "De opgegeven combinatie van gebruiker/wachtwoord is onjuist.Klik <a href=\"index.php?action=lostpw\">hier</a>, als je je wachtwoord vergeten bent of kwijt bent, en een nieuwe wil maken.";
	$text['login_success']	= "Hallo <i>###PLAYER:NAME###</i>, je bent nu ingelogd, veel plezier!.";

	// Generic Errors
	$text['err_cookie']			= "Kan geen cookie maken voor deze sessie.<br />Controleer aub. je browser instellingen.";
	$text['err_sess_invalid']	= "Error. Log aub opnieuw in!.";
	$text['err_sess_timeout']	= "Error. Log aub opnieuw in!.";

	// Lost Password
	$text['pw_header']="Je wachtwoord vergeten?";
	$text['pw_text']="Dat is geen probleem, je hoeft alleen je gebruikersnaam en email adres in te vullen, die je bij de registratie hebt gebruikt. Na een tijdje krijg je een e-mail met je nieuwe wachtwoord";
	$text['pw_name']="Gebruikersnaam:";
	$text['pw_email']="E-mail:";
	$text['pw_submit']="Vraag nieuw wachtwoord aan!";

	// Registration
	$text['register_header']="Registratie";
	$text['register_name']="Gebruikersnaam:";
	$text['register_pass']="Wachtwoord:";
	$text['register_volk']="Stam:";
	$text['register_submit']="Registreer";
	$text['register_error_1']="Deze gebruikersnaam bestaat al, kies aub een andere";
	$text['register_error_2']="Je moet wel alles invullen!";
	$text['register_error_21']="Error: Je hebt geen gebruikersnaam ingevult.";
	$text['register_error_22']="Error: Je hebt geen wachtwoord ingevult.";
	$text['register_error_3']="Je hebt jezelf succesvol geregistreerd, nu moet je wachten tot je account geactiveerd word. Bedankt!";

	// Tribe
	$text['volk_rom'] = "Romeinen";
	$text['volk_gal'] = "Galliërs";
	$text['volk_ger'] = "Germanen";

	// Actions
	$text['edit'] = "Wijzig";
	$text['del']  = "Verwijder";
	$text['fwd']  = "Doorgaan";
	// Sortings @added 2007/08/02 for RtWW Mod
	$text['sort_asc']	= 'Oplopende volgorde';
	$text['sort_desc']	= 'Aflopende volgorde';
	$text['sort_group']	= 'Groupering';

	// Quick Selects
	$text['list_members'] = "Speler";
	$text['list_villages'] = "Dorpen";
	$text['list_groups'] = "Groepen";
	$text['list_allies'] = "Alliantie";
	$text['list_empty'] = "(leeg)";
	$text['list_na'] = "(niks gevonden)";
	$text['list_unknown'] = "(onbekend)";

	// Troop Overview
	$text['admin_header']     = "Troepenoverzicht";
	$text['admin_player']     = "Speler";
	$text['admin_lastchange'] = "Laatste wijziging";
	$text['admin_sort']       = "Sorteren op";
	$text['admin_sum']        = "Totaal";
	$text['lastlogin']        = "Laatste login";
	$text['admin_age']        = "Laatste update op: %Y/%m/%d";
	$text['admin_age_1']      = "Troepen zijn up to date (max. 3 dagen)";
	$text['admin_age_2']      = "Troepen zijn redelijk up to date (3-5 dagen)";
	$text['admin_age_3']      = "Troepen zijn niet meer up to date(5-7 dagen)";
	$text['admin_age_4']      = "Treopen zijn oud (7-14 dagen)";
	$text['admin_age_5']      = "Troepen zijn ontzettend oud (min. 2 weken) of nooit ingevoerd";

	// User Profile
	$text['troops_detail'] = "Details";
	$text['troops_hero']   = "Held";
	$text['troops_stat']   = "Statistieken";

	// Memberlist
	$text['memberlist_header']   = "Ledenlijst";
	$text['name']                = "Naan";
	$text['member_header']       = "Registraties";
	$text['member_ok']           = "Accepteer registratie";
	$text['member_no']           = "Verwijderen registratie";
	$text['member_date']         = "Datum";
	$text['member_tribe']        = "Stam";
	$text['member_nonewmembers'] = "Er zijn geen nieuwe registraties";
	$text['member_del']          = "Verwijder dit lid";
	$text['member_delq']         = "Wil je echt dit lid verwijderen?";

	// Access Control
    $text['rechte_0'] = "Geen toegang";
    $text['rechte_1'] = "Lees alleen eigen info";
    $text['rechte_2'] = "Lees alle info";
    $text['rechte_3'] = "Lees en wijzig info";
    $text['member_0'] = "Troepenoverzicht";
    $text['member_1'] = "Ledenlijst";
    $text['member_2'] = "Missie plannen";
    $text['member_3'] = "Statistieken";

	// Own Troops
	$text['user_askdel']      = "Wil je echt deze troepen verwijderen?";
	$text['user_header']      = "Mijn troepen";
	$text['user_her']         = "Oorsprong";
	$text['user_sta']         = "Positie";
	$text['user_units']       = "Troepen";
	$text['user_showforms']   = "Voeg nieuwe troepen toe";
	$text['user_form_header'] = "Toevoegen troepen";
	$text['user_hilfe_regex'] = "Ga naar de Traviansite and klik op je verzamelplaats (bijv. http://s1.travian.nl/build.php?id=39). Gebruik Ctrl+A en Ctrl+C op deze site. Ga daarna terug naar deze site en gebruik Ctrl+V in het daarvoor bestemde gebied. Nu moet je de coördinaten van afkomst en van de positie invullen. De troepen worden automatisch ingevuld wanneer je op &quot;Opslaan&quot;.";
	$text['user_manu']        = "Handmatig";
	$text['user_auto']        = "Auto";
	$text['user_manu_hint']   = "Voeg troepen handmatig toe";
	$text['user_auto_hint']   = "Voeg troepen automatisch toe";
	// Ingame headlines from rally point; used for auto regex insert of troops
	$text['user_own_troops']    = "Eigen troepen";
	$text['user_return_from']   = "Keert terug van";
	$text['user_troops_for']    = "Versterking";
	$text['user_troops_of']     = "'s troepen";
	$text['user_attack_to']     = "Aanval";
	$text['user_raid_to']       = "Overval";
	$text['user_spy_at']        = "Scout Aanval";
	$text['user_explore_oasis'] = "Verlaten oase scouten";

    // Own heroes
    $text['hero_header']      = "Mijn helden";
    $text['hero_name']        = "Naam";
    $text['hero_typ']         = "Type";
    $text['hero_sta']         = "Positie";
    $text['hero_off']         = "Aanval";
    $text['hero_def']         = "Verdediging";
    $text['hero_off-bonus']   = "Aanv-bonus";
    $text['hero_def-bonus']   = "Verd-bonus";
    $text['hero_showforms']   = "Voeg een andere held toe";
    $text['hero_form_header'] = "Toevoegen held";
	$text['hero_enable']      = "Actieve held";
	$text['hero_disable']     = "Niet-Actieve held";
	$text['hero_active']      = "Deze held is actief";
	$text['hero_inactive']    = "Deze held is niet-actief en moet opnieuw worden geactiveerd in het heldenhof.";
	$text['hero_state']		= "Status";
	$text['hero_state_active']		= "Actief";
	$text['hero_state_inactive']		= "niet-actief";

	// Own villages
    $text['dorf_header']       = "Mijn dorpen";
    $text['dorf_showforms']    = "Voeg een nieuw dorp toe";
    $text['dorf_form_header']  = "Toevoegen dorp";
    $text['dorf_name']         = "Naam";
    $text['dorf_koords']       = "Coördinaten";
	$text['dorf_type']         = "Type";
	$text['dorf_type_0']       = "Rest (overige dorpen)";
	$text['dorf_type_1']       = "Hoofdorp";
	$text['dorf_type_2']       = "Natar  (WW dorp)";
	$text['dorf_type_3']       = "Veroverde Oase";
	$text['dorf_layout']       = "Vormgeving";
	$text['dorf_layout_0']     = "Standaart (4-4-4-6)";
	$text['dorf_layout_1']     = "Hout (5-3-4-6)";
	$text['dorf_layout_2']     = "Klei (4-5-3-6)";
	$text['dorf_layout_3']     = "Ijzer (3-4-5-6)";
	$text['dorf_layout_4']     = "Graan (3-3-3-9)";
	$text['dorf_layout_5']     = "Graan (1-1-1-15)";
	$text['dorf_size']         = "Inwoners";
    $text['dorf_mauer']        = "Muur";
    $text['dorf_turnier']      = "Toernooiveld";
    $text['dorf_palast']       = "Paleis";
    $text['dorf_residenz']     = "Residentie";
    $text['dorf_kornspeicher'] = "Graansilo capaciteit";
    $text['dorf_getreide']     = "Graanproductie";
	// Troop Planner @modified 2007/07/28 for RtWW Mod
	$text['umkreis_header']="Missie planner";
	$text['umkreis_col_val']="waarde";
	$text['umkreis_col_sel']="Doelwit / gebied";
	$text['umkreis_col_help']="Helpers / Details";
	$text['umkreis_target']="Coördinaten";
	$text['umkreis_arrival_date']="Datum van aankomst";
	$text['umkreis_arrival_time']="Tijd van aankomst";
	$text['umkreis_notimes_note1']="Alleen looptijden laten zien";
	$text['umkreis_notimes_note2']="Actiefe timing om aanvals tijd en datum vast te stellen";
	$text['umkreis_submit']="Bereken";
	$text['umkreis_date_today']="Vandaag";
	$text['umkreis_date_cal']="Kalender";
	$text['umkreis_date_cal_hint']="Kies datum van de kalender";
	$text['umkreis_time_now']="Nu";
	$text['umkreis_time_now_hint']="The huidige tijd";
	$text['umkreis_art']="Type van de missie";
	$text['umkreis_art_def']="Verdediging";
	$text['umkreis_art_off']="Aanval";
	$text['umkreis_art_adl']="Overname";
	$text['umkreis_art_fak']="Fake";
	$text['umkreis_art_oth']="Overig";
	$text['umkreis_types_i']="Alleen infanterie";
	$text['umkreis_types_k']="Alleen cavalerie";
	$text['umkreis_types_g']="Alleen artillerie";
	$text['umkreis_types_a']="Alleen leiders, senatoren of onderleiders";
	$text['umkreis_types_ik']="Infanterie en cavalerie";
	$text['umkreis_types_ig']="Infanterie en artillerie";
	$text['umkreis_types_kg']="Cavalerie en artillerie";
	$text['umkreis_types_ai']="Met infanterie";
	$text['umkreis_types_ak']="Met cavalerie";
	$text['umkreis_types_aik']="Met infanterie en cavalerie";
	$text['umkreis_types_aikg']="Met alles";
	$text['umkreis_types_ff']="Snel (Cavalerie)";
	$text['umkreis_types_fm']="Gemiddeld (Infanterie)";
	$text['umkreis_types_fs']="Langzaam (Artillerie)";
	$text['umkreis_types_sp']="Scouts";
	$text['umkreis_types_ss']="Kleine overval";
	$text['umkreis_types_ls']="Grote overval";
	$text['umkreis_types_all']="Alles";
	$text['umkreis_types_both']="Beide";
	$text['umkreis_troops']="Selecteerd troepen";
	$text['umkreis_troops_yes']="Wel";
	$text['umkreis_troops_yes_hint']="Deze unit is verplicht";
	$text['umkreis_troops_no']="Niet";
	$text['umkreis_troops_no_hint']="Deze unit zal niet worden mee gerekend";
	$text['umkreis_troops_opt']="Als het mogelijk is";
	$text['umkreis_troops_opt_hint']="Deze unit word meegerekend als die er is.";
	$text['umkreis_troops_fit']="Als het mogelijk is";
	$text['umkreis_troops_fit_hint']="Deze unit word meegerekend als die er is";
	$text['umkreis_strength']="Kracht van de troepen";
	$text['umkreis_strength_cnt']="Volgens kracht";
	$text['umkreis_strength_res']="Volgens graanverbruik";
	$text['umkreis_strength_cry']="Volgens draagvermogen";
	$text['umkreis_strength_single']="Fake";
	$text['umkreis_strength_all']="Allemaal";
	$text['umkreis_pool_limit']="Max. van voorraad";
	$text['umkreis_pool_limit_player']="Individueel";
	$text['umkreis_pool_limit_set']="Kracht";
	$text['umkreis_source']="Oorsprong";
	$text['umkreis_source_all']="Allemaal";
	$text['umkreis_source_own']="Eigen";
	$text['umkreis_source_own_tr']="Eigen troepen";
	$text['umkreis_source_own_gr']="Eigen groepen";
	$text['umkreis_source_own_al']="Eigen alliantie";
	$text['umkreis_source_direct']="Alleen oorsprong";
	$text['umkreis_source_direct_hint']="Alleen troepen die bij hun oorsprong staan";
	$text['umkreis_source_locations']="Inclusief posities";
	$text['umkreis_source_locations_hint']="Inclusief troepen die ergens anders staan";
	$text['umkreis_distance']="Maximaal afstand";
	$text['umkreis_distance_dur']="Max. tijd";
	$text['umkreis_distance_dis']="Max. afstand";
	$text['umkreis_distance_no']="Onbeperkt";
	$text['umkreis_distance_yes']="Beperkt";
	$text['umkreis_distance_fields']="Velden";

	$text['umkreis_dev_note']="<b>Waarschuwing!</b> Deze pagina is nog niet af.<br />Niet alle functie's zijn af, en werken dus nog niet!";

	$text['umkreis2_header'] = "Berekening voor ###X###|###Y### om %Y/%m/%d, %H:%M:%S uur";
	$text['umkreis2_src_direct']="Directe weg voor ###VIL1###";
	$text['umkreis2_src_location']="Weg van ###VIL2### naar ###VIL1###";
	$text['umkreis2_col_player']="Speler";
	$text['umkreis2_col_squad']="Troepen";
	$text['umkreis2_col_start']="Start";
	$text['umkreis2_col_duration']="Afstand";

/*
	$text['umkreis_dauer']="Duur";
	$text['umkreis_start']="Start tijd";
	$text['umkreis_ver']="Verdediging";
	$text['umkreis_ang']="Aanvals plan";
	$text['umkreis_own']="Alleen eigen troepen";
	$text['umkreis_header21']="Troepen beschikbaar in";
	$text['umkreis_header22']="Uren";
	$text['umkreis_herkunft']="Oorsprong";
	$text['umkreis_standort']="Positie";
	$text['umkreis_anzahl']="Troepen";
*/
	// Stats
	$text['stat_header']="Statistieken";
	$text['stat_verlauf']="Vooruitgang troepen";
	$text['stat_truppenver']="Troepen verdeling";
	$text['stat_spielerver']="Stam verdeling";

	// User Profile
	$text['profil_header'] = "Mijn profiel";
	$text['profil_name']   = "Gebruikersnaam:";
	$text['profil_volk']   = "Stam:";
	$text['profil_email']  = "Email adres:";
	$text['profil_new']    = "Nieuw wachtwoord:";
	$text['profil_old']    = "Oud wachtwoord:";
	$text['profil_ok']     = "Wachtwoord succesvol veranderd.";
	$text['profil_fehler'] = "Je hebt een verkeerd wachtwoord ingevult";
	$text['save']          = "Opslaan";

	// Setup /* temporarly disabled */
	$text['config_header'] = "Voorkeuren";
	$text['config_note'] = "Let op! Globale voorkeuren, dus niet alleen voor je eigen account!";
	$text['config_mail'] = "Contact link achter elke spelersnaam";
	$text['config_mail_0'] = "Niet laten zien";
	$text['config_mail_1'] = "Wel laten zien";
	$text['config_dorfname'] = "Coördinaten / dorpsnamen";
	$text['config_dorfname_0'] = "Alleen coördinaten";
	$text['config_dorfname_1'] = "Laat coördianten zien, dorpsnamen bij mouseover";
	$text['config_dorfname_2'] = "Laat dorpsnamen zien, coördianten bij mouseover";
	$text['config_dorfname_3'] = "Coördinaten achter dorpsnaam";
	$text['config_dorfname_4'] = "Dorpsnaam boven coördinaten";

	// FAQ
    $text['faq_haeder']="FAQ (frequently asked questions)";
    $text['faq_frage']="Vraag:";
    $text['faq_antwort']="Antwoord:";
    $text['faq_f1']="Waarom werkt het niet??";
    $text['faq_a1']="Om dit hulpmiddel te laten werken heb je een up-to-date Internet Browser. Javascript and Cookies moeten uitgeschakeld zijn.";
    $text['faq_f2']="Hoe activeer ik mijn leden?";
    $text['faq_a2']="Wanneer een nieuw lid zich aanmeld kan je de gebruikersnaam en de datum van registratie in de tabel aan de rechterkant. Klik op de groene markering en de gebruiker word geactiveerd. Dan zal hij/zij voortaan te vinden zijn op de aan de linkerkant. Als je een lid wilt verwijderen klik op de rode 'X'";
    $text['faq_f3']="Wat betekenen de nummers met kruisjes en cirkels in de ledenlijst?";
    $text['faq_a3']="Een groene laat toe om toegang tot de site te krijgen en de roden blokkeert het. De nummers betekenen het volgende: 1=Troepenoverzicht, 2=Ledenlijst, 3=Missie PLannen en 4=Statistieken.";
    $text['faq_f4']="Hoe voeg ik mijn troepen in?";
    $text['faq_a4']="In het menu aan de linker kant kan je klikken op &quot;Mijn troepen&quot;. Als je daarop klikt, zal een overzicht van jouw troepen verschijnen. In het begin is de tabel natuurlijk leeg, want je hebt nog niks kunnen invoegen. Om troepen toe te voegen klik je op &quot;voeg nieuwe troepen toe&quot;, dat staat onderaan de tabel . In het formulier dat dan verschijnt voeg je de coördinaten in van de oorsprong van de troepen (het dorp waar ze gemaakt zijn) en de positie (de plek waar ze nu staan). Om troepen automatisch in te vullen,ga je naar de Traviansite and klik op je verzamelplaats (bijv. http://s1.travian.nl/build.php?id=39). Gebruik Ctrl+A en Ctrl+C op die site (de verzamelplaats). Ga daarna terug naar deze site en gebruik Ctrl+V in het daarvoor bestemde gebied. De troepen worden automatisch ingevuld wanneer je op &quot;Opslaan/Save&quot;. Als je het prettig vind, kan je de troepen ook handmatig invullen, klik daarvoor op &quot;Handmatig&quot;. Dan verschijnt een tabel waar je per soort de hoeveel in kan vullen. Klik op &quot;Opslaan/Save&quot; om het af te roden.Als alles goed is gegaan staan je troepen in de tabel";
    $text['faq_f5']="Hoe wijzig ik mijn troepen?";
    $text['faq_a5']="Klik op het penceeltje om je troepen in die regel te wijzigen.";
    $text['faq_f6']="Hoe verwijder ik troepen?";
    $text['faq_a6']="Klik op de rode 'X' om troepen te verwijderen. Je verwijdert alleen de troepen in de regel waar je op de rode 'X' klikt!.";
    $text['faq_f7']="Hoe werkt Missie plannen?";
    $text['faq_a7']="Het Missie plannen is in deze versie nog niet af. Daarom is een uitgebreide uitleg niet nodig. Vraag de admin om uitleg als je het toch wilt gebruiken";
    $text['faq_f8']="welke troepen worden gebruikt in Missie plannen?";
    $text['faq_a8']="Dat kun je vanaf nu zelf bepaalden door de juiste dingen in te vullen!";
    $text['faq_f9']="Vraag";
    $text['faq_a9']="Antwoord";

	// Logout
	$text['login_again']="Log opnieuw in";

	// Troops (Single) @modified 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1']  = "Legionair";
	$text['t_rom2']  = "Praetoriaan";
	$text['t_rom3']  = "Imperiaan";
	$text['t_rom4']  = "Equites Legati";
	$text['t_rom5']  = "Equites Imperatoris";
	$text['t_rom6']  = "Equites Caesaris";
	$text['t_rom7']  = "Ram";
	$text['t_rom8']  = "Vuurkatapult";
	$text['t_rom9']  = "Senator";
	$text['t_rom10'] = "Kolonist";

	// Gauls
	$text['t_gal1']  = "Phalanx";
	$text['t_gal2']  = "Zwaardvechter";
	$text['t_gal3']  = "Padvinder";
	$text['t_gal4']  = "Toetatis Donder";
	$text['t_gal5']  = "Druideruiter";
	$text['t_gal6']  = "Haeduaan";
	$text['t_gal7']  = "Ram";
	$text['t_gal8']  = "Trebuchet";
	$text['t_gal9']  = "Onderleider";
	$text['t_gal10'] = "Kolonist";

	// Teutons
	$text['t_ger1']  = "Knuppelvechter";
	$text['t_ger2']  = "Speervechter";
	$text['t_ger3']  = "Bijlvechters";
	$text['t_ger4']  = "Verkenner";
	$text['t_ger5']  = "Paladijn";
	$text['t_ger6']  = "Germaanse Ridder";
	$text['t_ger7']  = "Ram";
	$text['t_ger8']  = "Katapult";
	$text['t_ger9']  = "Leider";
	$text['t_ger10'] = "Kolonist";

	// Troops (Multiple) @added 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1_x']  = "Legionairs";
	$text['t_rom2_x']  = "Praetorianen";
	$text['t_rom3_x']  = "Imperianen";
	$text['t_rom4_x']  = "Equites Legati";
	$text['t_rom5_x']  = "Equites Imperatoris";
	$text['t_rom6_x']  = "Equites Caesaris";
	$text['t_rom7_x']  = "Rammen";
	$text['t_rom8_x']  = "Vuurkatapulten";
	$text['t_rom9_x']  = "Senators";
	$text['t_rom10_x'] = "Kolonisten";

	// Gauls
	$text['t_gal1_x']  = "Phalanxen";
	$text['t_gal2_x']  = "zwaardvechters";
	$text['t_gal3_x']  = "Padvinders";
	$text['t_gal4_x']  = "Toetatis Donders";
	$text['t_gal5_x']  = "Druideruiters";
	$text['t_gal6_x']  = "Haeduanen";
	$text['t_gal7_x']  = "Rammen";
	$text['t_gal8_x']  = "Trebuchets";
	$text['t_gal9_x']  = "Onderleiders";
	$text['t_gal10_x'] = "Kolonisten";

	// Teutons
	$text['t_ger1_x']  = "Knuppelvechters";
	$text['t_ger2_x']  = "Speervechters";
	$text['t_ger3_x']  = "Bijlvechters";
	$text['t_ger4_x']  = "Verkenners";
	$text['t_ger5_x']  = "Paladijnen";
	$text['t_ger6_x']  = "Germaanse Ridders";
	$text['t_ger7_x']  = "Rammen";
	$text['t_ger8_x']  = "Katapulten";
	$text['t_ger9_x']  = "Leiders";
	$text['t_ger10_x'] = "Kolonisten";


	// Troop Types @added 2007/07/21 for RtWW Mod
	$text['t_sp'] = "Scouts";
	$text['t_id'] = "Verdedigende Infanterie";
	$text['t_io'] = "Aanvallende Infanterie";
	$text['t_kd'] = "Verdedigende Cavalerie";
	$text['t_ko'] = "Aanvallende Cavalerie";
	$text['t_rm'] = "Rammen";
	$text['t_kt'] = "Katapults";
	$text['t_ad'] = "Leiders, onderleiders en senatoren";
	$text['t_gt'] = "Artillerie";
	$text['t_hr'] = $text['troops_hero'];

	// Return Text
	return (!empty($text[$parameter])) ? $text[$parameter] : '';
}
?>
