<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @author belse <ake.svedin@gmail.com>
 * @package trooptool
 * @subpackage rtwwmod
 * @internal language: english
 * @todo replace by xml-based, full utf-8 layer
 * @since 2007/11/02 waRhawK converted to native utf-8 file, be sure your editor support utf-8 before editing this file
 */



/**
 * Delivering of language specific text
 *
 * @param string $parameter the label key to fetch
 * @return string the utf-8 encoded, localized text
 */
function text($parameter) {

	/**
	 * The language stack
	 * @var array
	 */
	$text=array();

	// Name of Translator
	$text['translator']="Danbrant";

	// About
	$text['about'] = 'Truppentool '.VERSION.
	((strlen(MOD_NAME))?' - '.MOD_NAME:'').
	((strlen(MOD_VERSION))?' '.MOD_VERSION:'').
	((strlen(MOD_AUTHOR))?' by '.MOD_AUTHOR:'').
	((strlen(MOD_UPDATE))?', last updated: '.MOD_UPDATE:'');

	// Language specific
	$text['locale'] = array('se_SE', 'Swedish');
	$text['date_short'] = 'd.m.Y';
	$text['date_picker_fmt'] = 'dmy';
	$text['date_picker_sep'] = '.';

	// Menu
  $text['admin.php']="Alla trupper";
  $text['admin.php_hover']="Se alla trupper i alliansen";
  
  $text['member.php']="Medlemslista";
  $text['member.php_hover']="Medlemslista";
  
  $text['user.php']="Egna trupper";
  $text['user.php_hover']="Egna trupper";

  $text['hero.php']="Egna hjälten";
  $text['hero.php_hover']="Egna hjälten";
	
	$text['chat.php']="Chat";
	$text['chat.php_hover']="Snacka lite";

  $text['dorf.php']="Egna byar";
  $text['dorf.php_hover']="Adminstrera dina byar";

	$text['umkreis.php']="Strategi planerare";
	$text['umkreis.php_hover']="Planera strategier";

  $text['stat.php']="Statistik";
  $text['stat.php_hover']="Statistik";

	$text['userconfig.php']="Inställningar";
	$text['userconfig.php_hover']="Ändra användar inställningar";

	$text['profil.php']="Min profil";
	$text['profil.php_hover']="Fixa kontot";

	$text['faq.php']="FAQ";
	$text['faq.php_hover']="FAQ (frequently asked questions)";

	$text['logout.php']="Logga ut";
	$text['logout.php_hover']="Logga ut";

	$text['login']="Logga in";
	$text['login_hover']="Logga in";

	$text['register.php']="Registrera";
	$text['register.php_hover']="Skapa ett konto";

	// Login
	$text['login_header']	= "Logga in";
	$text['login_name']		= "Anv&auml;ndarnamn:";
	$text['login_pass']		= "L&ouml;senord:";
	$text['login_submit']	= "Logga in";
	$text['login_fehler1']	= "Spelaren kunde inte hittas i databasen";
	$text['login_inactive']	= "Ditt konto &auml;r inte aktiverad &auml;nnu. Fr&aring;ga din alliansledare om du inte &auml;r aktiverad inom 24h..";
	$text['login_wrong']	= "Användarnamnet/lösenordet är stämmmer inte. Klicka <a href=\"index.php?action=lostpw\">hät</a>, om du har tappat bort lösenordet och vill få tillbaka det.";
	$text['login_success']	= "Hej <i>###PLAYER:NAME###</i>, du &auml; nu inloggad.";

	// Generic Errors
	$text['err_cookie']			= "Kunde inte skapa kaka, cookie, för den din session.<br />Var god kontrollera dina webbläsar inställningar.";
	$text['err_sess_invalid']	= "Invalid session. Var god och logga in igen.";
	$text['err_sess_timeout']	= "Tiden har gått ut. Var god och logga in igen.";

	// Lost Password
  $text['pw_header']="Gl&ouml;mt ditt L&ouml;senord?";
  $text['pw_text']="Inga problem, bara skriv in ditt nick och epostadress som du registrerade dig med. Inom kort kommer du få ett email med ditt nya l&ouml;senord.";
  $text['pw_name']="Nick:";
  $text['pw_email']="Epost:";
  $text['pw_submit']="Skapa nytt l&ouml;senord";

	// Registration
  $text['register_header'] = "Registrera";
  $text['register_name']   = "Nick:";
  $text['register_pass']   = "L&ouml;senord:";
	$text['register_volk']="Stam:";
	$text['register_submit']="Registrera";
  $text['register_error_1']="Det anv&auml;ndarnamnet är redan taget, v&auml;lj ett annat.";
  $text['register_error_2']="Fyll i alla f&auml;llten.";
	$text['register_error_21']="Fel: Du fyllde inte i ett nick.";
	$text['register_error_22']="Fel: Du skrev inte i ett l&ouml;senord.";
  $text['register_error_3']="Du &auml;r nu registrerad. Nu &auml;r det bara till att v&auml;nta. En admin kommer inom kort aktiverar ditt konto.";

	// Tribe
  $text['volk_rom']="Romare";
  $text['volk_gal']="Galler";
  $text['volk_ger']="Germaner";

	// Actions
  $text['edit'] = "&Auml;ndra";
  $text['del']  = "Ta bort";
	$text['fwd']  = "Forts&aumlt;";
	// Sortings @added 2007/08/02 for RtWW Mod
	$text['sort_asc']	= 'Stigande ordning';
	$text['sort_desc']	= 'Sjunkande ordning';
	$text['sort_group']	= 'Gruppera';

	// Quick Selects
	$text['list_members'] = "Spelare";
	$text['list_villages'] = "By";
	$text['list_groups'] = "Grupp";
	$text['list_allies'] = "Allians";
	$text['list_empty'] = "Tom";
	$text['list_na'] = "Kunde inte hittas";
	$text['list_unknown'] = "okänd";

	// Troop Overview
  $text['admin_header']="Alla trupper";
  $text['admin_player']="Spelare";
  $text['admin_lastchange']="Senast uppdaterad";
  $text['admin_sort']="Sortera";
  $text['admin_sum']="Totalt";
  $text['lastlogin']="Senaste inloggning";
	$text['admin_age']        = "Senast uppdaterad: %Y/%m/%d";
	$text['admin_age_1']      = "Trupper nyligen uppdaterade (max. 3 days)";
	$text['admin_age_2']      = "Trupp info b&ouml;rjar bli f&ouml;r gammal (3-5 days)";
	$text['admin_age_3']      = "Trupp info &ouml;r mindre f&ouml;r gammal (5-7 days)";
	$text['admin_age_4']      = "Trupp info &auml;r alldeles f&ouml;r gammal (7-14 days)";
	$text['admin_age_5']      = "Trupp info &auml;r extremt gammal (min. 2 weeks) eller aldrig inskriven";

	// User Profile
	$text['troops_detail'] = "Detaljer";
	$text['troops_hero']   = "Hj&auml;lte";
	$text['troops_stat']   = "Statistik";

	// Memberlist
	$text['memberlist_header']   = "Medlemslista";
	$text['name']                = "Nanm";
	$text['member_header']       = "Registrering";
	$text['member_ok']           = "Acceptera registrering";
	$text['member_no']           = "Avb&ouml;j registrering";
	$text['member_date']         = "Datum";
	$text['member_tribe']        = "Stam";
	$text['member_nonewmembers'] = "Alla registreringar accepterade:)";
	$text['member_del']          = "Ta bort medlem";
	$text['member_delq']         = "S&auml;ker?";

	// Access Control
  $text['rechte_0']="Ingen tillg&aring;ng";
  $text['rechte_1']="Egna data l&auml;sbara";
  $text['rechte_2']="Allas data l&auml;sbara";
  $text['rechte_3']="Allas data l&auml;sbara och &auml;ndringsbara";
  $text['member_0']="Alla trupper";
  $text['member_1']="Medlemslista";
  $text['member_2']="Trupps&ouml;kning";
  $text['member_3']="Statistik";

	// Own Troops
  $text['user_askdel']="Vill du verkligen ta bort?";
  $text['user_header']="Egna trupper";
  $text['user_her']="Ursprungsby";
  $text['user_sta']="Nuvarande position";
	$text['user_units']= "Trupper";
  $text['user_showforms']="L&auml;gg till nya trupper";
  $text['user_form_header']="L&auml;gg till trupper";
  $text['user_hilfe_regex']="G&aring; till Travian och g&aring; till din samlingsplats (ex. http://s1.travian.se/build.php?id=39). Tryck Ctrl+A och Ctrl+C p&aring; den sidan. Efter&aring;t, g&aring; tillbaka till denna sida och tryck Ctrl+V i dialogrutan. Nu m&aring;ste du skriva in koordinaterna f&ouml;r byn som skapade trupperna och f&ouml;r byn som h&aring;ller trupperna just nu. Trupperna kommer att l&auml;ggas till automatiskt n&auml;r du trycker p&aring; &quot;Spara&quot;.";
  $text['user_manu']="L&auml;gg till manuellt";
  $text['user_auto']="L&auml;gg till automatiskt";
	$text['user_manu_hint']   = "L&auml;gg till manuellt";
	$text['user_auto_hint']   = "L&auml;gg till automatiskt";

	// Ingame headlines from rally point; used for auto regex insert of troops
	$text['user_own_troops']    = "Egna trupper";
	$text['user_return_from']   = "Kommer tillbaka från";
	$text['user_troops_for']    = "Förstärkning";
	$text['user_troops_of']     = "'s troops";
	$text['user_attack_to']     = "Attackera";
	$text['user_raid_to']       = "Plundra";
	$text['user_spy_at']        = "Scouta";
	$text['user_explore_oasis'] = "Plundra ledig oas";

    // Own heroes
  $text['hero_header']      = "Egen hj&auml;lte";
  $text['hero_name']        = "Namn";
  $text['hero_typ']         = "Sort";
  $text['hero_sta']         = "Befinner sig";
  $text['hero_off']         = "offensiv";
  $text['hero_def']         = "defensiv";
  $text['hero_off-bonus']   = "off-bonus";
  $text['hero_def-bonus']   = "def-bonus";
    $text['hero_showforms']   = "Ny hj&auml;lte";
    $text['hero_form_header'] = "Skriv in hj&auml;lte";
	$text['hero_enable']      = "Aktivera hj&auml;lte";
	$text['hero_disable']     = "Avaktivera hj&auml;lte";
	$text['hero_active']      = "hj&auml;lte &auml;r aktiv";
	$text['hero_inactive']    = "hj&auml;lte &auml;r inte aktiv";
	$text['hero_state']		= "State";
	$text['hero_state_active']		= "Active";
	$text['hero_state_inactive']		= "Inactive";

	// Own villages
  /*new*/$text['dorf_header']       = "Egen by";
  /*new*/$text['dorf_showforms']    = "En ny by &auml;r grundad/er&ouml;vrad";
  /*new*/$text['dorf_form_header']  = "Lägg till by";
  /*new*/$text['dorf_name']         = "Byns namn";
  /*new*/$text['dorf_koords']       = "Kordinater";
	$text['dorf_type']         = "Sort";
	$text['dorf_type_0']       = "Vanlig by (further village)";
	$text['dorf_type_1']       = "Huvudstad";
	$text['dorf_type_2']       = "Natars (WW by)";
	$text['dorf_type_3']       = "Er&ouml;vrad oas";
	$text['dorf_layout']       = "Utseende";
	$text['dorf_layout_0']     = "Standard (4-4-4-6)";
	$text['dorf_layout_1']     = "Tr&auml; (5-3-4-6)";
	$text['dorf_layout_2']     = "Lera (4-5-3-6)";
	$text['dorf_layout_3']     = "J&auml;rn (3-4-5-6)";
	$text['dorf_layout_4']     = "Vete (3-3-3-9)";
	$text['dorf_layout_5']     = "Vete (1-1-1-15)";
	$text['dorf_size']         = "Invånare";
    $text['dorf_mauer']        = "Mur";
    $text['dorf_turnier']      = "Turneringsplats";
    $text['dorf_palast']       = "Palats";
    $text['dorf_residenz']     = "Residens";
    $text['dorf_kornspeicher'] = "Silo";
    $text['dorf_getreide']     = "Vete produktion";
	// Troop Planner @modified 2007/07/28 for RtWW Mod
	$text['umkreis_header']="Strategi planerare";
	$text['umkreis_col_val']="V&auml;rde";
	$text['umkreis_col_sel']="Selection / Range";
	$text['umkreis_col_help']="H&auml;lpare/detaljer";
	$text['umkreis_target']="Kordinater";
	$text['umkreis_arrival_date']="Ankomst datum";
	$text['umkreis_arrival_time']="Ankomst tid";
	$text['umkreis_notimes_note1']="Displaying walk time durations only";
	$text['umkreis_notimes_note2']="Active timing to set arrival date/time";
	$text['umkreis_submit']="Resultat";
	$text['umkreis_date_today']="Idag";
	$text['umkreis_date_plus1d']="Imorgon";
	$text['umkreis_date_plus2d']="Om 2 dagar";
	$text['umkreis_date_cal']="Kalendar";
	$text['umkreis_date_cal_hint']="Välj datum från kalender";
	$text['umkreis_time_now']="Nu";
	$text['umkreis_time_now_hint']="Nuvarande tiden";
	$text['umkreis_art']="Uppdrags typ";
	$text['umkreis_art_def']="Deffensiv";
	$text['umkreis_art_off']="Offensiv";
	$text['umkreis_art_adl']="E&ouml;vring";
	$text['umkreis_art_fak']="Fake/Falsk";
	$text['umkreis_art_oth']="annan";
	$text['umkreis_types_i']="Infanteri endast";
	$text['umkreis_types_k']="Kavalleri endast";
	$text['umkreis_types_g']="Bel&ouml;gringsvapen endast";
	$text['umkreis_types_a']="Stamledare &ouml;";
	$text['umkreis_types_ik']="Infanteri + kavalleri";
	$text['umkreis_types_ig']="Infanteri + bel&ouml;gringsvapen";
	$text['umkreis_types_kg']="Kavalleri + bel&ouml;gringsvapen";
	$text['umkreis_types_ai']="Med infanteri";
	$text['umkreis_types_ak']="Med kavalleri";
	$text['umkreis_types_aik']="Med infanteri + kavalleri";
	$text['umkreis_types_aikg']="Med allt";
	$text['umkreis_types_ff']="Fast (Cavalry)";
	$text['umkreis_types_fm']="Medium (Infantry)";
	$text['umkreis_types_fs']="Slow (Siege weapons)";
	$text['umkreis_types_sp']="Spion";
	$text['umkreis_types_ss']="Liten räd";
	$text['umkreis_types_ls']="Stor räd";
	$text['umkreis_types_all']="Allt";
	$text['umkreis_types_both']="Båda";
	$text['umkreis_troops']="Truppval";
	$text['umkreis_troops_yes']="Ja";
	$text['umkreis_troops_yes_hint']="Den här truppensorten måste ingå";
	$text['umkreis_troops_no']="Nej";
	$text['umkreis_troops_no_hint']="Den här truppstorten kommer bli ignorerad";
	$text['umkreis_troops_opt']="Om det finns";
	$text['umkreis_troops_opt_hint']="Den här truppsorten visas om den finns";
	$text['umkreis_troops_fit']="Om passande";
	$text['umkreis_troops_fit_hint']="Den här truppsorten visas om den är passande för uppdraget";
	$text['umkreis_strength']="Trupp styrka";
	$text['umkreis_strength_cnt']="Efter antal";
	$text['umkreis_strength_res']="Efter veteåtgång";
	$text['umkreis_strength_cry']="Efter bärande kapacitet";
	$text['umkreis_strength_single']="Fake/Falsk";
	$text['umkreis_strength_all']="All";
	$text['umkreis_pool_limit']="Max. from stock";
	$text['umkreis_pool_limit_player']="Individualt";
	$text['umkreis_pool_limit_set']="Styrka";
	$text['umkreis_source']="Hemby";
	$text['umkreis_source_all']="All (All allianser)";
	$text['umkreis_source_own']="Egna";
	$text['umkreis_source_own_tr']="Egna trupper";
	$text['umkreis_source_own_gr']="Egen grupp";
	$text['umkreis_source_own_al']="Egen allians";
	$text['umkreis_source_direct']="Hemby endast";
	$text['umkreis_source_direct_hint']="Inkludera trupper från produktions byn endast";
	$text['umkreis_source_locations']="Inkludera positioner";
	$text['umkreis_source_locations_hint']="Inkludera även trupper från andra byar";
	$text['umkreis_distance']="Avstånds gräns";
	$text['umkreis_distance_dur']="Max. restid";
	$text['umkreis_distance_dis']="Max. avstånd";
	$text['umkreis_distance_no']="Obegränsat";
	$text['umkreis_distance_yes']="Gräns";
	$text['umkreis_distance_fields']="Rutor";

	$text['umkreis_dev_note']="<b>OBS!</b> Den här sidan är ännu inte färdig.<br />Alla funktionerna finns ännu inte med, du kan varken tvinga de eller gå runt de.";

	$text['umkreis2_header'] = "Beräkningar för ###X###|###Y### den %Y/%m/%d, kl %H:%M:%S";
	$text['umkreis2_src_direct']="Rak väg från ###VIL1###";
	$text['umkreis2_src_location']="Beräknad väg från ###VIL2### över ###VIL1###";
	$text['umkreis2_col_player']="Spelare";
	$text['umkreis2_col_squad']="Trupper";
	$text['umkreis2_col_start']="Tid för sändning";
	$text['umkreis2_col_duration']="Avstånd";

/*
	$text['umkreis_dauer']="Duration";
	$text['umkreis_start']="Starting time";
	$text['umkreis_ver']="Defense";
	$text['umkreis_ang']="Attack planning";
	$text['umkreis_own']="only own troops";
	$text['umkreis_header21']="Troops available within";
	$text['umkreis_header22']="hours";
	$text['umkreis_herkunft']="Origin";
	$text['umkreis_standort']="Position";
	$text['umkreis_anzahl']="Troops";
*/
	// Stats
	$text['stat_header']="Statistik";
	$text['stat_verlauf']="Total truppöversikt";
	$text['stat_truppenver']="Trupp fördelning";
	$text['stat_spielerver']="Stam fördelning";

	// User Profile
	$text['profil_header'] = "Min profil";
	$text['profil_name']   = "Användarnamn:";
	$text['profil_volk']   = "Stam:";
	$text['profil_email']  = "Email adress:";
	$text['profil_new']    = "Nytt lösenord:";
	$text['profil_old']    = "Gammalt lösenord:";
	$text['profil_ok']     = "Lösenordet ändrades utan problem.";
	$text['profil_fehler'] = "Du skrev in ett felaktigt lösenord.";
	$text['save']          = "Spara";

	// Setup /* temporarly disabled */
	$text['config_header'] = "Inställningar";
	$text['config_note'] = "OBS! Totala inställningar! Inte bara ditt konto!";
	$text['config_mail'] = "Link bakom användarnamn för att kontakta spelare.";
	$text['config_mail_0'] = "Visa inte";
	$text['config_mail_1'] = "Visa";
	$text['config_dorfname'] = "Kordinater/Byns namn";
	$text['config_dorfname_0'] = "Visa endast kordinater";
	$text['config_dorfname_1'] = "Visa kordinater - håll musen över för att visa by namn";
	$text['config_dorfname_2'] = "By namn - håll musen över för att visa kordinater";
	$text['config_dorfname_3'] = "Kordinater bakom byns namn";
	$text['config_dorfname_4'] = "Byns namn framför byns namn";

	// FAQ
    $text['faq_haeder']="FAQ (frequently asked questions)/OFF (Ofta Frågade Frågor)";
    $text['faq_frage']="Fråga:";
    $text['faq_antwort']="Svar:";
    $text['faq_f1']="Varf&ouml;r fungerar inte verktyget/sidan?";
    $text['faq_a1']="F&ouml;r att verktyget ska fungera beh&ouml;ver du en updaterad vebl&auml;sare. Javascript och cookies/kakor måste vara igång.";
    $text['faq_f2']="Hur aktiverar jag ett konto?";
    $text['faq_a2']="Om en ny medlem har registrerat sitt nick och datumet f&ouml;r registrering visas i tabbelen till på höger sida, ett klick på dett gr&ouml;na märket aktiverar kontot. Han/hon finns nu i tabbelen till v&auml;nster fr.o.m. nu. Om du vill ta bort en medlem så klickar du bara på X.";
    $text['faq_f3']="Vad betyder symbolerna i medlemslistan?";
    $text['faq_a3']="Symbolerna under siffrorna visar om spelaren har tillg&aring;ng till
      den sidan. Ett r&ouml;tt kryss f&ouml;rbjuder och spelare utan kryss har tillg&aring;ng till den sidan. Siffrorna
	  st&aring;r f&ouml;r f&ouml;ljande: 1=Alla trupper, 2=Medlemslista, 3=Trupps&ouml;kning och 4=Statistik.";
    $text['faq_f4']="Hur l&auml;gger jag till egna trupper?";
    $text['faq_a4']="Tryck p&aring; l&auml;nken Egna trupper i menyn. D&aring; f&aring;r du fram en &ouml;versikt &ouml;ver dina egna trupper. 
      Tabellen &auml;r tom om du inte har lagt till n&aring;got.
	  F&ouml;r att l&auml;gga till trupper tryck p&aring; &quot;L&auml;gg till nya trupper&quot;. I rutan
	  som kommer upp, fyll i X och Y koordinaterna av dina truppers ursprungsby och var de &auml;r
	  placerade i nul&auml;get. F&ouml;r att l&auml;gga till trupperna automatiskt g&aring; till din samlingsplats
	  (ex. http://speed.travian.se/build.php?id=39). D&auml;r trycker du p&aring; Ctrl+A och Ctrl+C.
	  Efter&aring;t, g&aring; tillbaka till &quot;Egna trupper&quot; och tryck Ctrl+V i dialogrutan. Om du f&ouml;redrar att
	  l&auml;gga till dina trupper manuellt, tryck p&aring; den lilla pilen. Skriv in antalet och sort i de nya
	  rutorna. Tryck p&aring; &quot;spara&quot; f&ouml;r att avsluta. Om allt gick korrekt tillv&auml;ga s&aring; kan du se dina trupper i tabellen.";
    $text['faq_f5']="Hur &auml;ndrar jag mina trupper?";
    $text['faq_a5']="Tryck p&aring; pennan p&aring; den rad som du vill &auml;ndra.";
    $text['faq_f6']="Hur tar jag bort mina trupper?";
    $text['faq_a6']="Tryck p&aring; \"X\" s&aring; f&ouml;rsvinner trupperna i den raden.";
    $text['faq_f7']="Hur fungerar Trupps&ouml;kningen?";
    $text['faq_a7']="I de f&ouml;rsta tv&aring; f&auml;lten fyller du i koordinater. De andra tre &auml;r reserverade f&ouml;r
      den senaste ankomsttiden. Fyll i tiden som timmar : minuter : sekunder. Du har tv&aring; valfria
	  f&auml;lt i andra raden. Den f&ouml;rsta inkluderar sp&aring;rare. Den andra visar ursprungsbyn. Det
	  &auml;ndrar inte resultatet av s&ouml;kningen.";
    $text['faq_f8']="Vilka trupper &auml;r inkluderade i Trupps&ouml;kningen?";
    $text['faq_a8']="Trupps&ouml;kningen inkluderar bara trupper som &auml;r fler &auml;n 50 av en trupptyp i en by. En defensiv s&ouml;kning
      inkluderar Legion&auml;rer, Praetorianer och Imperieriddare, Falanxer, Druidryttare och Haeduans, Spjutm&auml;n
	  och Paladiner. En offensiv s&ouml;kning inkluderar Imperiesoldater, Imperieriddare and Caesarriddare, Sv&auml;rdsk&auml;mpar,
	  Theutates Blixtar och Haeduans, Klubbm&auml;n, Yxm&auml;n, Paladiner och Germanska Knektar.";
    $text['faq_f9']="Fr&aring;ga";
    $text['faq_a9']="Svar";

	// Logout
	$text['login_again']="logga in igen";

	// Troops (Single) @modified 2007/07/21 for RtWW Mod
	// Romans
  $text['t_rom1']="Legion&auml;r";
  $text['t_rom2']="Praetorian";
  $text['t_rom3']="Imperiesoldat";
  $text['t_rom4']="Sp&aring;rare";
  $text['t_rom5']="Imperieriddare";
  $text['t_rom6']="Caesarriddare";
  $text['t_rom7']="Murbr&auml;cka";
  $text['t_rom8']="Eldkatapult";
  $text['t_rom9']="Senator";
  $text['t_rom10']="Nybyggare";
  
  //Galier
  $text['t_gal1']="Falanx";
  $text['t_gal2']="Sv&auml;rdsk&auml;mpe";
  $text['t_gal3']="Sp&aring;rare";
  $text['t_gal4']="Theutates Blixt";
  $text['t_gal5']="Druidryttare";
  $text['t_gal6']="Haeduan";
  $text['t_gal7']="Murbr&auml;cka";
  $text['t_gal8']="Krigskatapult";
  $text['t_gal9']="H&ouml;vding";
  $text['t_gal10']="Nybyggare";
  
  //Germanen
  $text['t_ger1']="Klubbman";
  $text['t_ger2']="Spjutman";
  $text['t_ger3']="Yxman";
  $text['t_ger4']="Scout";
  $text['t_ger5']="Paladin";
  $text['t_ger6']="Germansk Knekt";
  $text['t_ger7']="Murbr&auml;cka";
  $text['t_ger8']="Katapult";
  $text['t_ger9']="Stamledare";
  $text['t_ger10']="Nybyggare";

	// Troops (Multiple) @added 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1_x']  = "Legionärer";
	$text['t_rom2_x']  = "Praetorianer";
	$text['t_rom3_x']  = "Imperiesoldater";
	$text['t_rom4_x']  = "Spårare";
	$text['t_rom5_x']  = "Imperieriddare";
	$text['t_rom6_x']  = "Caesarriddare";
	$text['t_rom7_x']  = "Murbr&auml;ckor";
	$text['t_rom8_x']  = "Eldkatapulter";
	$text['t_rom9_x']  = "Senatorer";
	$text['t_rom10_x'] = "Nybyggare";

	// Gauls
	$text['t_gal1_x']  = "Falanxer";
	$text['t_gal2_x']  = "Sv&auml;rdsk&auml;mpar";
	$text['t_gal3_x']  = "Spårare";
	$text['t_gal4_x']  = "Theutates Blixtar";
	$text['t_gal5_x']  = "Druidryttare";
	$text['t_gal6_x']  = "Haeduans";
	$text['t_gal7_x']  = "Murbr&auml;ckor";
	$text['t_gal8_x']  = "Krigskatapulter";
	$text['t_gal9_x']  = "H&ouml;vdingar";
	$text['t_gal10_x'] = "Nybyggare";

	// Teutons
	$text['t_ger1_x']  = "Klubbmän";
	$text['t_ger2_x']  = "Spjutmän";
	$text['t_ger3_x']  = "Yxmän";
	$text['t_ger4_x']  = "Spårare";
	$text['t_ger5_x']  = "Paladiner";
	$text['t_ger6_x']  = "Germanska Knektar";
	$text['t_ger7_x']  = "Murbr&auml;ckor";
	$text['t_ger8_x']  = "katapulter";
	$text['t_ger9_x']  = "Stamledare";
	$text['t_ger10_x'] = "SNybyggare";


	// Troop Types @added 2007/07/21 for RtWW Mod
	$text['t_sp'] = "Spårare";
	$text['t_id'] = "Deffensivt infanteri";
	$text['t_io'] = "Offensivt infantri";
	$text['t_kd'] = "Deffensivt kavaleri";
	$text['t_ko'] = "Offensivt kavaleri";
	$text['t_rm'] = "Murbräckor";
	$text['t_kt'] = "Katapulter";
	$text['t_ad'] = "Stamledare";
	$text['t_gt'] = "Belägrings maskiner";
	$text['t_hr'] = $text['troops_hero'];

	// Return Text
	return (!empty($text[$parameter])) ? $text[$parameter] : '';
}
?>
