<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @author belse <ake.svedin@gmail.com>
 * @package trooptool
 * @subpackage rtwwmod
 * @internal language: english
 * @todo replace by xml-based, full utf-8 layer
 * @since 2007/11/02 waRhawK converted to native utf-8 file, be sure your editor support utf-8 before editing this file
 * @Slovak translation: Risi (rlaffers@yahoo.com)
 */



/**
 * Delivering of language specific text
 *
 * @param string $parameter the label key to fetch
 * @return string the utf-8 encoded, localized text
 */
function text($parameter) {

	/**
	 * The language stack
	 * @var array
	 */
	$text=array();

	// Name of Translator
	$text['translator']="Belse";

	// About
	$text['about'] = 'Truppentool '.VERSION.
	((strlen(MOD_NAME))?' - '.MOD_NAME:'').
	((strlen(MOD_VERSION))?' '.MOD_VERSION:'').
	((strlen(MOD_AUTHOR))?' by '.MOD_AUTHOR:'').
	((strlen(MOD_UPDATE))?', last updated: '.MOD_UPDATE:'');

	// Language specific
	$text['locale'] = array('sk_SK', 'Slovensky');
	$text['date_short'] = 'd/m/Y';
	$text['date_picker_fmt'] = 'dmY';
	$text['date_picker_sep'] = '/';

	// Menu
	$text['admin.php']="Všetky jednotky";
	$text['admin.php_hover']="Prezrieť všetky jednotky v aliancii";

	$text['member.php']="Zoznam užívateľov";
	$text['member.php_hover']="Zoznam užívateľov";

	$text['updater.php']="Update DB";
	$text['updater.php_hover']="Aktualizovať databázu užívateľov a dedín údajmi z Travian servera.";

	$text['user.php']="Moje jednotky";
	$text['user.php_hover']="Vložiť alebo aktualizovať vlastné jednotky";

	$text['hero.php']="Moji hrdinovia";
	$text['hero.php_hover']="Vložiť alebo aktualizovať vlastných hrdinov";

	$text['dorf.php']="Moje dediny";
	$text['dorf.php_hover']="Vložiť vlastné dediny";

	$text['umkreis.php']="Plánovač";
	$text['umkreis.php_hover']="Vyhľadanie jednotiek pre plánovanie misií";

	$text['stat.php']="Štatistiky";
	$text['stat.php_hover']="Štatistiky stavu jednotiek";

	$text['userconfig.php']="Nastavenia";
	$text['userconfig.php_hover']="Nastaviť Trooptool";

	$text['profil.php']="Môj profil";
	$text['profil.php_hover']="Zmeniť nastavenia profilu";

	$text['faq.php']="FAQ";
	$text['faq.php_hover']="FAQ (Často kladené otázky)";

	$text['logout.php']="Odhlásiť";
	$text['logout.php_hover']="Odhlásiť";

	$text['login']="Prihlásiť";
	$text['login_hover']="Prihlásiť";

	$text['register.php']="Registrovať";
	$text['register.php_hover']="Vytvoriť nový účet";

	// Login
	$text['login_header']	= "Prihlásiť";
	$text['login_name']		= "Prihlasovacie meno:";
	$text['login_pass']		= "Heslo:";
	$text['login_submit']	= "Prihlásiť";
	$text['login_fehler1']	= "Užívateľ s týmto prihlasovacím menom neexistuje.";
	$text['login_inactive']	= "Tvoj účet ešte nie je aktivovaný. Prosím počkaj, kým ho administrátor aktivuje. Kontaktuj ho, ak si myslíš že to trvá pridlho.";
	$text['login_wrong']	= "Nesprávne prihlasovacie meno/heslo. Klikni <a href=\"index.php?action=lostpw\">sem</a>, ak si zabudol svoje heslo a chceš nastaviť nové";
	$text['login_success']	= "Vitaj <i>###PLAYER:NAME###</i>, prihlásenie prebehlo úspešne.";

	// Generic Errors
	$text['err_cookie']			= "Nepodarilo sa vytvoriť koláčik pre toto sedenie.<br />Prosím, skontroluj nastavenie svojho prehliadača.";
	$text['err_sess_invalid']	= "Neplatné sedenie. Prihlás sa znovu.";
	$text['err_sess_timeout']	= "Tvoje sedenie expirovalo. Prihlás sa znovu.";

	// Lost Password
	$text['pw_header']="Zabudol si heslo?";
	$text['pw_text']="Nevadí, stačí zadať meno a emailovú adresu ktorú si použil pri registrácii. Krátko na to ti bude zaslaný email s novým heslom.";
	$text['pw_name']="Prihlasovacie meno:";
	$text['pw_email']="Email:";
	$text['pw_submit']="Vytvoriť nové heslo";

	// Registration
	$text['register_header']="Registrácia";
	$text['register_name']="Prihlasovacie meno:";
	$text['register_pass']="Heslo:";
	$text['register_volk']="Národ:";
	$text['register_submit']="Registrovať";
	$text['register_error_1']="Užívateľ s týmto menom už existuje. Zvoľ prosím iné prihlasovacie meno.";
	$text['register_error_2']="Vyplň prosím všetky kolonky.";
	$text['register_error_21']="Chyba: Nezadal si prihlasovacie meno.";
	$text['register_error_22']="Chyba: Nezadal si heslo.";
	$text['register_error_3']="Registrácia prebehla úspešne. Počkaj kým administrátor aktivuje tvoj účet.";

	// Tribe
	$text['volk_rom'] = "Rimania";
	$text['volk_gal'] = "Galovia";
	$text['volk_ger'] = "Germáni";

	// Actions
	$text['edit'] = "Editovať";
	$text['del']  = "Zmazať";
	$text['fwd']  = "Pokračovať";
	// Sortings @added 2007/08/02 for RtWW Mod
	$text['sort_asc']	= 'Vzostupné poradie';
	$text['sort_desc']	= 'Zostupné poradie';
	$text['sort_group']	= 'Zoskupiť';

	// Quick Selects
	$text['list_members'] = "Hráči";
	$text['list_villages'] = "Dediny";
	$text['list_groups'] = "Skupina";
	$text['list_allies'] = "Aliancia";
	$text['list_empty'] = "(prázdne)";
	$text['list_na'] = "(nenájdené)";
	$text['list_unknown'] = "(neznáme)";

	$text['all_groups'] = "Všetky skupiny";

	// Troop Overview
	$text['admin_header']     = "Prehľad jednotiek";
	$text['admin_player']     = "Hráč";
	$text['admin_lastchange'] = "Posledná aktualizácia";
	$text['admin_sort']       = "Zoradiť podľa";
	$text['admin_sum']        = "Spolu";
	$text['lastlogin']        = "Posledné prihlásenie";
	$text['admin_age']        = "Posledná aktualizácia: %Y/%m/%d";
	$text['admin_age_1']      = "Stav jednotiek je aktuálny (max. 3 dni)";
	$text['admin_age_2']      = "Stav jednotiek je mierne neaktuálny (3-5 dní)";
	$text['admin_age_3']      = "Stav jednotiek je neaktuálny (5-7 dní)";
	$text['admin_age_4']      = "Stav jednotiek je veľmi zastaralý (7-14 dní)";
	$text['admin_age_5']      = "Stav jednotiek je extrémne zastaralý (min. 2 týždne) alebo ho hráč ešte neuviedol.";

	// User Profile
	$text['troops_detail'] = "Detaily";
	$text['troops_hero']   = "Hrdina";
	$text['troops_stat']   = "Štatistika";
	$text['changepw_ok'] = "Chyba: Zadal si nesprávne heslo. Nemožno nastaviť nové heslo.";
	$text['changepw_fehler'] = "Heslo bolo úspešne zmenené.";

	// Memberlist
	$text['memberlist_header']   = "Zoznam užívateľov";
	$text['name']                = "Meno";
	$text['member_header']       = "Noví užívatelia";
	$text['member_ok']           = "Aktivovať";
	$text['member_no']           = "Zrušiť registráciu";
	$text['member_date']         = "Dátum";
	$text['member_tribe']        = "Národ";
	$text['member_nonewmembers'] = "Nikto nečaká na prijatie";
	$text['member_del']          = "Zmazať užívateľa";
	$text['member_delq']         = "Naozaj chcete zmazať tohto užívateľa?";

	// Grouplist - RISI !!!
	$text['grouplist_header']   = "Zoznam skupín";
	$text['header_group']   = "Skupiny";
	$text['members']   = "Členovia skupiny";
	$text['member_delmemq']         = "Naozaj si želáš odstrániť zo skupiny tohto hráča?";
	$text['member_delgrpq']         = "Naozaj chcete odstrániť túto skupinu?";
	$text['add_member'] = "Pridať člena";
	$text['delete_group'] = "Zmazať skupinu";
	$text['add_group'] = "Vytvoriť skupinu";
	$text['grp_name'] = "Meno skupiny:";
	$text['grp_description'] = "Opis skupiny:";



	// Access Control
    $text['rechte_0'] = "Vstup zakázaný!";
    $text['rechte_1'] = "Čítať len vlastné údaje";
    $text['rechte_2'] = "Čítať všetko";
    $text['rechte_3'] = "Čítať a editovať údaje";
    $text['member_0'] = "Všetky jednotky";
    $text['member_1'] = "Zoznam užívateľov";
    $text['member_2'] = "Plánovač";
    $text['member_3'] = "Štatistiky";

	// Own Troops
	$text['user_askdel']      = "Naozaj to chceš zmazať?";
	$text['user_header']      = "Moje jednotky";
	$text['user_her']         = "Vyrobené v";
	$text['user_sta']         = "Súčasná pozícia";
	$text['user_units']       = "Jednotky ";
	$text['user_showforms']   = "Vložiť nové jednotky";
	$text['user_form_header'] = "Vložiť jednotky";
	$text['user_hilfe_regex'] = "V hre vyberte Bod stretnutia (http://s3.travian.sk/build.php?gid=16). Stlač Ctrl+A a Ctrl+C. Potom sa vráť na túto stránku a stlač Ctrl+V. Potom vyplň pozíciu kde boli jednotky vyrobené a pozíciu kde sa teraz nachádzajú. Po stlačení &quot;uložiť&quot; budú jednotky vložené.";
	$text['user_manu']        = "Manuálne";
	$text['user_auto']        = "Automaticky";
	$text['user_manu_hint']   = "Vlož manuálne";
	$text['user_auto_hint']   = "Vlož automaticky";

	// Ingame headlines from rally point; used for auto regex insert of troops
	$text['user_own_troops']    = "Vlastné jednotky";
	$text['user_return_from']   = "Návrat z";
	$text['user_troops_for']    = "Podpora pre";
	$text['user_troops_of']     = "Jednotky od";
	$text['user_attack_to']     = "Útok na";
	$text['user_raid_to']       = "Lúpež proti";
	$text['user_spy_at']        = "Špehovanie v";
	$text['user_explore_oasis'] = "Preskúmať opustené údolie";

    // Own heroes
    $text['hero_header']      = "Moji hrdinovia";
    $text['hero_name']        = "Meno";
    $text['hero_typ']         = "Typ";
    $text['hero_sta']         = "Súčasná pozícia";
    $text['hero_off']         = "Útok";
    $text['hero_def']         = "Obrana";
    $text['hero_off-bonus']   = "Útok-Bonus";
    $text['hero_def-bonus']   = "Obrana-Bonus";
    $text['hero_showforms']   = "Vložiť ďalšieho hrdinu";
    $text['hero_form_header'] = "Vložiť hrdinu";
	$text['hero_enable']      = "Aktivovať hrdinu";
	$text['hero_disable']     = "Deaktivovať hrdinu";
	$text['hero_active']      = "Tento hrdina je aktívny";
	$text['hero_inactive']    = "Tento hrdina je neaktívny. Oživiť ho môžeš v dvore hrdinov.";
	$text['hero_state']		= "Stav";
	$text['hero_state_active']		= "Aktívny";
	$text['hero_state_inactive']		= "Neaktívny";

	// Own villages
    $text['dorf_header']       = "Moje dediny";
    $text['dorf_showforms']    = "Vložiť novú dedinu";
    $text['dorf_autofill']    = "Vyplniť automaticky";
    $text['dorf_form_header']  = "Vložiť dedinu";
    $text['dorf_name']         = "Meno";
    $text['dorf_koords']       = "Súradnice";
	$text['dorf_type']         = "Typ";
	$text['dorf_type_0']       = "Normálna (obyčajná dedina)";
	$text['dorf_type_1']       = "Hlavná";
	$text['dorf_type_2']       = "Natarská (s divom sveta)";
	$text['dorf_type_3']       = "Obsadené údolie";
	$text['dorf_layout']       = "Rozloženie polí";
	$text['dorf_layout_0']     = "Štandardné (4-4-4-6)";
	$text['dorf_layout_1']     = "Drevná (5-3-4-6)";
	$text['dorf_layout_2']     = "Hlinená (4-5-3-6)";
	$text['dorf_layout_3']     = "Železná (3-4-5-6)";
	$text['dorf_layout_4']     = "Multikrop (3-3-3-9)";
	$text['dorf_layout_5']     = "Megakrop (1-1-1-15)";
	$text['dorf_size']         = "Populácia";
    $text['dorf_mauer']        = "Múr (úroveň)";
    $text['dorf_turnier']      = "Turnajové ihrisko (úroveň)";
    $text['dorf_palast']       = "Palác";
    $text['dorf_residenz']     = "Rezidencia";
    $text['dorf_kornspeicher'] = "Kapacita sýpky";
    $text['dorf_getreide']     = "Obilná produkcia (hrubá)";
	// Troop Planner @modified 2007/07/28 for RtWW Mod
	$text['umkreis_header']="Plánovač";
	$text['umkreis_col_val']="Hodnota";
	$text['umkreis_col_sel']="Výber / Rozsah";
	$text['umkreis_col_help']="Filter výsledkov / Detaily";
	$text['umkreis_target']="Súradnice";
	$text['umkreis_arrival_date']="Dátum príchodu";
	$text['umkreis_arrival_time']="Čas príchodu";
	$text['umkreis_notimes_note1']="Zobraziť len dobu cestovania";
	$text['umkreis_notimes_note2']="Aktivuj pre nastavenie času/dátumu príchodu";
	$text['umkreis_submit']="Vyhľadať";
	$text['umkreis_date_today']="Dnes";
	$text['umkreis_date_cal']="Kalendár";
	$text['umkreis_date_cal_hint']="Vybrať dátum z kalendára";
	$text['umkreis_time_now']="Teraz";
	$text['umkreis_time_now_hint']="Aktuálny čas";
	$text['umkreis_art']="Typ misie";
	$text['umkreis_art_def']="Obrana";
	$text['umkreis_art_off']="Útok";
	$text['umkreis_art_adl']="Dobývanie";
	$text['umkreis_art_fak']="Falošný útok";
	$text['umkreis_art_oth']="Iná";
	$text['umkreis_types_i']="Pechota";
	$text['umkreis_types_k']="Jazda";
	$text['umkreis_types_g']="Obliehacie stroje";
	$text['umkreis_types_a']="Šéfovia";
	$text['umkreis_types_ik']="Pechota + jazda";
	$text['umkreis_types_ig']="Pechota + obliehacie stroje";
	$text['umkreis_types_kg']="Jazda + obliehacie stroje";
	$text['umkreis_types_ai']="pechotou";
	$text['umkreis_types_ak']="jazdou";
	$text['umkreis_types_aik']="pechotou + jazdou";
	$text['umkreis_types_aikg']="všetky";
	$text['umkreis_types_ff']="Rýchle (jazda)";
	$text['umkreis_types_fm']="Normálne (pechota)";
	$text['umkreis_types_fs']="Pomalé (obliehacie stroje)";
	$text['umkreis_types_sp']="Špehovia";
	$text['umkreis_types_ss']="Malá lúpež";
	$text['umkreis_types_ls']="Veľká lúpež";
	$text['umkreis_types_all']="Všetky";
	$text['umkreis_types_both']="Obe";
	$text['umkreis_troops']="Výber jednotiek";
	$text['umkreis_troops_yes']="Áno";
	$text['umkreis_troops_yes_hint']="Tento typ jednotiek je nutný";
	$text['umkreis_troops_no']="Nie";
	$text['umkreis_troops_no_hint']="Tento typ jednotiek netreba";
	$text['umkreis_troops_opt']="Ak je dostupný";
	$text['umkreis_troops_opt_hint']="Tento typ jednotiek sa zobrazí ak je dostupný";
	$text['umkreis_troops_fit']="Ak je vhodný";
	$text['umkreis_troops_fit_hint']="Tento typ jednotiek sa zobrazí ak je vhodný pre túto misiu";
	$text['umkreis_strength']="Sila jednotiek";
	$text['umkreis_strength_cnt']="Podľa množstva";
	$text['umkreis_strength_res']="Podľa spotreby obilia";
	$text['umkreis_strength_cry']="Podľa nosnosti";
	$text['umkreis_strength_single']="Falošný útok";
	$text['umkreis_strength_all']="Všetky";
	$text['umkreis_pool_limit']="Max. z dostupného množstva";
	$text['umkreis_pool_limit_player']="Individuálne";
	$text['umkreis_pool_limit_set']="Vynútiť";
	$text['umkreis_source']="Pôvod";
	$text['umkreis_source_all']="Všetko (všetky aliancie)";
	$text['umkreis_source_own']="Vlastné";
	$text['umkreis_source_own_tr']="Vlastné jednotky";
	$text['umkreis_source_own_gr']="Vlastná skupina";
	$text['umkreis_source_own_al']="Vlastná aliancia";
	$text['umkreis_source_direct']="Len z miest výroby";
	$text['umkreis_source_direct_hint']="Zahrnúť len jednotky umiestnené v dedine kde boli vyrobené";
	$text['umkreis_source_locations']="Aj detašované jednotky";
	$text['umkreis_source_locations_hint']="Zahrnúť aj jednotky vyslané ako podpora do iných dedín";
	$text['umkreis_distance']="Ohraničenie dosahu";
	$text['umkreis_distance_dur']="Max. doba cesty";
	$text['umkreis_distance_dis']="Max. vzdialenosť";
	$text['umkreis_distance_no']="Neobmedzená";
	$text['umkreis_distance_yes']="Obmedzená";
	$text['umkreis_distance_fields']="polí";

	$text['umkreis_dev_note']="<b>Pozor!</b> Táto stránka ešte nie je dokončená.<br />Niektoré funckie ešte nie sú dostupné.";

	$text['umkreis2_header'] = "Jednotky dostupné pre ###X###|###Y### o %Y/%m/%d, %H:%M:%S o'clock";
	$text['umkreis2_header_notimes'] = "Jednotky dostupné pre ###X###|###Y### (len doba cestovania)";
	$text['umkreis2_src_direct']="Priama cesta z ###VIL1###";
	$text['umkreis2_src_location']="Nepriama cesta z ###VIL2### cez ###VIL1###";
	$text['umkreis2_col_player']="Hráč";
	$text['umkreis2_col_squad']="Jednotky";
	$text['umkreis2_col_start']="Vyhodiť";
	$text['umkreis2_col_duration']="Vzdialenosť";

/*
	$text['umkreis_dauer']="Duration";
	$text['umkreis_start']="Starting time";
	$text['umkreis_ver']="Defense";
	$text['umkreis_ang']="Attack planning";
	$text['umkreis_own']="only own troops";
	$text['umkreis_header21']="Troops available within";
	$text['umkreis_header22']="hours";
	$text['umkreis_herkunft']="Origin";
	$text['umkreis_standort']="Position";
	$text['umkreis_anzahl']="Troops";
*/
	// Stats
	$text['stat_header']= "Štatistiky";
	$text['stat_verlauf']="Časový diagram";
	$text['stat_truppenver']="Diagram jednotiek";
	$text['stat_spielerver']="Diagram národov";

	// User Profile
	$text['profil_header'] = "Môj profil";
	$text['profil_name']   = "Meno:";
	$text['profil_volk']   = "Národ:";
	$text['profil_email']  = "Emailová adresa:";
	$text['profil_new']    = "Nové heslo:";
	$text['profil_old']    = "Staré heslo:";
	$text['profil_ok']     = "Profil úspešne zmenený.";
	$text['profil_fehler'] = "Vložil si nesprávne heslo.";
	$text['save']          = "Uložiť";

	// Setup /* temporarly disabled */
	$text['config_header'] = "Nastavenia";
	$text['config_note'] = "Pozor! Globálne nastavenia! Aplikujú sa pre všetky účty!";
	$text['config_mail'] = "Link behind any username to contact player";
	$text['config_mail_0'] = "Do not show";
	$text['config_mail_1'] = "Show";
	$text['config_dorfname'] = "Coordinates/Village name";
	$text['config_dorfname_0'] = "Show only coordinates";
	$text['config_dorfname_1'] = "Show coordinates - Village name when mouseover";
	$text['config_dorfname_2'] = "Show village name - Coordinates when mouseover";
	$text['config_dorfname_3'] = "Coordinates behind village name";
	$text['config_dorfname_4'] = "Village name above coordinates";

	// FAQ
    $text['faq_haeder']="FAQ (často kladené otázky)";
    $text['faq_frage']="Otázka:";
    $text['faq_antwort']="Odpoveď:";
    $text['faq_f1']="Why doesn't it work?";
    $text['faq_a1']="To make that Tool Work you need an up-to-date Browser. Javascript and Cookies have to be enabled.";
    $text['faq_f2']="How do I activate my members?";
    $text['faq_a2']="If a new member registered the nickname and the date of register are shown in the table on the right side. A click on the green checkmark activates the member. He/she is shown in the table on the left side from now on. If you want to delete the member just click on the red X.";
    $text['faq_f3']="What do the numbers with crosses and circles in the memberlist mean?";
    $text['faq_a3']="The red circles and green crosses below the numbers show if the player is allowed to call that sites. A green cross allows and a red circle forbides to enter the site. The numbers stand for the following sites: 1=All troops, 2=Memberlist, 3=Ambitsearch and 4=Statistics.";
    $text['faq_f4']="How do I enter my own troops?";
    $text['faq_a4']="On the left side in menu you can see the point own troops. After clicking that an overview of your own troops will apear. The table naturally looks empty if nothing is inserted. To enter data you have to click on &quot;enter new troops&quot; which is placed below. In the following form you enter on the top the X and Y coordinates of the troops' origin and where they are stationed at the moment. To enter the troops automatically go to the site of your rally point (e.g. http://s5.travian.com/build.php?id=39). There you have to press Ctrl+A and Ctrl+C. Afterwards you go back to &quot;own troops&quot; and press Ctrl+V in the big input box. If you prefer to enter your troops manually click on the little arrow. Enter the quantity and the unit type in the new boxes. Click on &quot;save&quot; to finish. If all was correct you can see your troops in the table.";
    $text['faq_f5']="How to edit my own troops?";
    $text['faq_a5']="Click the pencil to edit your troops in this line.";
    $text['faq_f6']="How to delete troops?";
    $text['faq_a6']="Click on the \"X\" and the data in this line will be deleted for ever.";
    $text['faq_f7']="How does the Ambitsearch work?";
    $text['faq_a7']="You have to enter the coordinates in the first two fields. The other three are reservered for the latest arrivaltime. Please enter the time like hour : minute : second. You have two optional fields in the second line. The first one includes spys. The second one shows the origin of the troops. This doesn't change the results. The troops have ever to follow that sheme: position -&gt; origin -&gt; target";
    $text['faq_f8']="Which troops are included in the Ambitsearch?";
    $text['faq_a8']="The Ambitsearch includes only troops which are more than 50 of a type in a village. A defense search includes Legionnaires, Praetorians and Equites Imperatoris, Phalanx, Druidriders and Haeduans, Spearfighters and Paladins. A search of offense calculates with Imperians, Equites Imperatoris and Equites Caesaris, Swordsmen, Theutates Thunder and Haeduans, Clubswingers, Axefighters, Paladins and Teuton Knights.";
    $text['faq_f9']="Question";
    $text['faq_a9']="Answer";

	// Logout
	$text['login_again']="login again";

	// Troops (Single) @modified 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1']  = "Legionár";
	$text['t_rom2']  = "Pretorián";
	$text['t_rom3']  = "Imperián";
	$text['t_rom4']  = "Equites Legati";
	$text['t_rom5']  = "Equites Imperatoris";
	$text['t_rom6']  = "Equites Caesaris";
	$text['t_rom7']  = "Baranidlo";
	$text['t_rom8']  = "Ohnivý katapult";
	$text['t_rom9']  = "Senátor";
	$text['t_rom10'] = "Osadník";

	// Gauls
	$text['t_gal1']  = "Falanx";
	$text['t_gal2']  = "Šermiar";
	$text['t_gal3']  = "Sliedič";
	$text['t_gal4']  = "Theutates Blesk";
	$text['t_gal5']  = "Druid jazdec";
	$text['t_gal6']  = "Haeduan";
	$text['t_gal7']  = "Baranidlo";
	$text['t_gal8']  = "Vojenský katapult";
	$text['t_gal9']  = "Náčelník";
	$text['t_gal10'] = "Osadník";

	// Teutons
	$text['t_ger1']  = "Pálkar";
	$text['t_ger2']  = "Oštepár";
	$text['t_ger3']  = "Sekerník";
	$text['t_ger4']  = "Špeh";
	$text['t_ger5']  = "Rytier";
	$text['t_ger6']  = "Teuton";
	$text['t_ger7']  = "Baranidlo";
	$text['t_ger8']  = "Katapult";
	$text['t_ger9']  = "Kmeňový vodca";
	$text['t_ger10'] = "Osadník";

	// Troops (Multiple) @added 2007/07/21 for RtWW Mod
	// Romans
	$text['t_rom1_x']  = "Legionárov";
	$text['t_rom2_x']  = "Pretoriánov";
	$text['t_rom3_x']  = "Imperiánov";
	$text['t_rom4_x']  = "Equites Legati";
	$text['t_rom5_x']  = "Equites Imperatoris";
	$text['t_rom6_x']  = "Equites Caesaris";
	$text['t_rom7_x']  = "Baranidiel";
	$text['t_rom8_x']  = "Ohnivých katapultov";
	$text['t_rom9_x']  = "Senátorov";
	$text['t_rom10_x'] = "Osadníkov";

	// Gauls
	$text['t_gal1_x']  = "Falanxov";
	$text['t_gal2_x']  = "Šermiarov";
	$text['t_gal3_x']  = "Sliedičov";
	$text['t_gal4_x']  = "Theutates Bleskov";
	$text['t_gal5_x']  = "Druid jazdcov";
	$text['t_gal6_x']  = "Haeduanov";
	$text['t_gal7_x']  = "Baranidiel";
	$text['t_gal8_x']  = "Vojenských katapultov";
	$text['t_gal9_x']  = "Náčelníkov";
	$text['t_gal10_x'] = "Osadníkov";

	// Teutons
	$text['t_ger1_x']  = "Pálkarov";
	$text['t_ger2_x']  = "Oštepárov";
	$text['t_ger3_x']  = "Sekerníkov";
	$text['t_ger4_x']  = "Špehov";
	$text['t_ger5_x']  = "Rytierov";
	$text['t_ger6_x']  = "Teutonov";
	$text['t_ger7_x']  = "Braniciel";
	$text['t_ger8_x']  = "Katapultov";
	$text['t_ger9_x']  = "Kmeňových vodcov";
	$text['t_ger10_x'] = "Osadníkov";


	// Troop Types @added 2007/07/21 for RtWW Mod
	$text['t_sp'] = "Špehovia";
	$text['t_id'] = "Obranná pechota";
	$text['t_io'] = "Útočná pechota";
	$text['t_kd'] = "Obranná jazda";
	$text['t_ko'] = "Útočná jazda";
	$text['t_rm'] = "Baranidlá";
	$text['t_kt'] = "Katapulty";
	$text['t_ad'] = "Šéfovia";
	$text['t_gt'] = "Obliehacie stroje";
	$text['t_hr'] = $text['troops_hero'];

	// auth key
	$text['auth_header']       = "Autentifikačný kľúč";
	$text['auth_current']       = "Autentifikačný kľúč";
	$text['auth_submit']       = "Generovať nový kľúč";

	//Updateing troops
	$text['send_success']	= "Trooptool hlási: Stav jednotiek bol aktualizovaný.";
	$text['send_error']	= "Trooptool hlási: Chyba pri aktualizácii jednotiek!";

	// Return Text
	return (!empty($text[$parameter])) ? $text[$parameter] : '';
}
?>
