<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 */
  //Header und Gre vom Bild
  Header("Content-Type: image/png");
  $width  = 252;
  $height = 252;
  $img = ImageCreate($width, $height);

  //config.php includen
  $lang_include = 0;
  require_once "config.php";

  security();

  $x = (int) $_GET['x'] - (int) $_GET['tx'];
  $y = (int) $_GET['y'] - (int) $_GET['ty'];

  //Farben
  $white = ImageColorAllocate($img, 255, 255, 255);
  $black = ImageColorAllocate($img, 0, 0, 0);
  $gray  = ImageColorAllocate($img, 210, 210, 210);
  $green = ImageColorAllocate($img, 34, 139, 34);
  $red   = ImageColorAllocate($img, 255, 0, 0);

  //Hintergrund: wei
  ImageFill($img, 0, 0, $white);

  //--Koordinatensystem
  $x_gitter = ($_GET['tx']%5)*2;
  $y_gitter = ($_GET['ty']%5)*2;
  //Gitter zeichnen
  for ($i=1; $i<=50; $i++) {
  	ImageLine($img, 10*$i-4-$x_gitter, 1, 10*$i-4-$x_gitter, 250, $gray);
  	ImageLine($img, 1, 10*$i-4+$y_gitter, 250, 10*$i-4+$y_gitter, $gray);
  }
  //Rand
  ImageFilledRectangle($img, 0, 0, 250, 16, $white);
  ImageFilledRectangle($img, 0, 0, 16, 250, $white);
  ImageFIlledRectangle($img, 0, 234, 250, 250, $white);
  ImageFilledRectangle($img, 234, 0, 250, 250, $white);
  //Koordinaten schreiben
  for ($i=0; $i<=20; $i++) {
  	ImageStringUp($img, 1, 22+($i*10)-$x_gitter, 15, ($_GET['tx']-($_GET['tx']%5)-50)+($i*5), $gray);  //x-oben
  	ImageStringUp($img, 1, 22+($i*10)-$x_gitter, 249, ($_GET['tx']-($_GET['tx']%5)-50)+($i*5), $gray); //x-unten
  	ImageString($img, 1, 2, 222-($i*10)+$y_gitter, ($_GET['ty']-($_GET['ty']%5)-50)+($i*5), $gray);    //y-links
  	ImageString($img, 1, 235, 222-($i*10)+$y_gitter, ($_GET['ty']-($_GET['ty']%5)-50)+($i*5), $gray);    //y-rechts
  }

  //Zieldorf
  ImageLine($img, 120, 126, 132, 126, $red);
  ImageLine($img, 126, 120, 126, 132, $red);

  //Startdorf
  ImageFilledRectangle($img, 125+$x*2, 125-$y*2, 127+$x*2, 127-$y*2, $green);

  //Rand
  ImageRectangle($img, 0, 0, 251, 251, $black);

  //erstellt das Bild und leert den Cache
  ImagePNG($img);
  ImageDestroy($img);
?>