<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/11/03 waRhawK added recursive delete to avoid database is being wasted by dead player data
 * @since 2007/11/03 waRhawK fixed bug that overlib was included twice
 */
require_once("config.php");

  security();

  function recht_img($nr)
  {
  	$return = array("readno", "read", "readall", "readwrite");
  	return "img/".$return[$nr].".gif";
  }

  function rechte($seite)
  {
  	switch ($seite) {
  		case "0":
  		  return "1010";
  		  break;
  		case "1":
  		  return "1011";
  		  break;
  		case "2":
  		  return "1110";
  		  break;
  		case "3":
  		  return "1110";
  		  break;
  	}
  }

  //gibt ein Formular zur�ck, in dem die neuen Rechte ausgew�hlt werden k�nnen -->FIREFOX UND ANDERE
  function change_rights_ff($seite, $spieler)
  {
  	$r = "";

  	for ($i=0; $i<=3; $i++) {
  		if (substr(rechte($seite),$i,1)==1) {
		  	$r.=   "<button type=\'submit\' name=\'rechte\' value=\'$i\'>";
			$r.=     "<img src=\'".recht_img($i)."\'>";
			$r.=   "</button>";
  		}
  	}

  	return $r;
  }
  


  //gibt ein Formular zur�ck, in dem die neuen Rechte ausgew�hlt werden k�nnen -->NUR INTERNET EXPLORER
  function change_rights_ie($seite, $spieler)
  {
  	$r = "<select class=\'ibox\' style=\'width:100px;\' name=\'rechte\' OnChange=\'this.form.submit();\'>";
  	$r.= "<option>...</option>";

  	for ($i=0; $i<=3; $i++) {
  		if (substr(rechte($seite),$i,1)==1) {
		  	$r.= "<option value=\'$i\'>".text("rechte_".$i)."</option>";
  		}
  	}

  	$r.= "</select>";

  	return $r;
  }
  


  function change_rights($seite, $spieler)
  {
  	$r = "<form action=\'member.php\' method=\'post\' accept-charset=\'utf-8\'>";
  	$r.=   "<input type=\'hidden\' name=\'spielerid\' value=\'".$spieler."\'>";
  	$r.=   "<input type=\'hidden\' name=\'seite\' value=\'".$seite."\'>";

  	//IE hat Probleme mit Bildern in Submitbuttons...
  	//Mit IE7 kein Problem?
  	if (!ereg("MSIE",$_SERVER['HTTP_USER_AGENT'])) {
  		$r.= change_rights_ff($seite, $spieler);
  	} else {
  		$r.= change_rights_ie($seite, $spieler);
  	}

  	$r.= "</form>";

  	return $r;
  }
  
  
  /**************  CUSTOMIZED (risi) *******************/
  function get_his_groups($spieler) {
	$his_groups = "";
	$sql = "SELECT id FROM ".PREFIX."groups WHERE ".PREFIX."groups.members LIKE '%,".(int)$spieler.",%'";
	$result = mysql_query($sql) OR die(mysql_error());
	if(mysql_num_rows($result) == 0) {
		return $his_groups;
	}
	
	while($row = mysql_fetch_assoc($result)) {
		$his_groups .= $row['id'].",";
	}
	return $his_groups;
  }
  
  function delete_member($spieler, $grp) 
  {
	
	$r = "<a href=\'javascript:askdelmem(".$spieler.",".$grp.");\' style=\'cursor:pointer;\'><img src=\'img/user_delete.png\'></a>";
	return $r;
	
  }
  
  function add_member($grp)
  {
	$r = "<form action=\'member.php\' method=\'post\' accept-charset=\'utf-8\'>";
  	$r.=   "<input type=\'hidden\' name=\'groupid\' value=\'".$grp."\'>";
  	$r.=   "<input type=\'hidden\' name=\'addspieler2grp\' value=\'true\'>";
  	$r.=   "<input type=\'text\' name=\'spielername\' value=\'\'>";
  	$r.=   "<a onclick=\'this.parentNode.submit();\' ><img src=\'img/user_add.png\' alt=\'".text('add_user')."\' title=\'".text('add_user')."\' style=\'cursor:pointer;\' /></a>";
	
	$r.= "</form>";

  	return $r;
  }
  
  function add_group()
  {
	$r = "<form action=\'member.php\' method=\'post\' accept-charset=\'utf-8\'>";
  	$r.=   text("grp_name")."<input type=\'text\' name=\'newgrp\' value=\'\'><br/>";
  	$r.=   text("grp_description")."<input type=\'text\' name=\'grpdesc\' value=\'\'>";
  	$r.=   "<a onclick=\'this.parentNode.submit();\' ><img src=\'img/group_add.png\' alt=\'".text('add_group')."\' title=\'".text('add_group')."\' style=\'cursor:pointer;\' /></a>";
	
	$r.= "</form>";

  	return $r;
  }
  
  // Add player to a group
  if( isset($_POST['addspieler2grp'], $_POST['groupid'], $_POST['spielername']) && is_numeric($_POST['groupid']) && $_POST['spielername'] != "" ) {
	
	$group_id = (int)$_POST['groupid'];
	$member_name = $_POST['spielername'];
	
	$player = mysql_query("SELECT sid FROM ".PREFIX."spieler WHERE name='".$member_name."' LIMIT 1")  OR die(mysql_error());
	$player = mysql_fetch_assoc($player);
	if(count($player) > 0) {
		//player found
		$member_id = $player['sid'];
		
		$old_members = mysql_query("SELECT members FROM ".PREFIX."groups WHERE id='".$group_id."' LIMIT 1") OR die(mysql_error());
		$old_members = mysql_fetch_assoc($old_members); 
		if($old_members != NULL) {
			$old_members = explode(",", trim($old_members['members'], ","));			
			$new_members = array();
			foreach($old_members as $value) {
				if($value != $member_id && $value != "") {
					$new_members[] = $value;
				}
			}
			$new_members[] = $member_id;
			if(count($new_members) > 0) {
				$new_members = ",".implode(",", $new_members).",";
			} else {
				$new_members = NULL;
			}
			
			mysql_query("UPDATE `".PREFIX."groups` SET `members` = '".$new_members."' WHERE id = '".$group_id."' LIMIT 1") OR die(mysql_error());
		}
		
	} else {
		echo "<span style=\"color:red\">Error! Player <em>".$member_name."</em> does not exist.</span> <a href=\"member.php\">Continue...</a>";
		die();
	}
	
  }
  
   // Remove player from a group
  if (isset($_GET['delmem']) AND isset($_GET['grp']) AND is_numeric($_GET['delmem']) AND is_numeric($_GET['grp'])) {

  	
	$group_id = (int)$_GET['grp'];
	$member_id = (int)$_GET['delmem'];
	$old_members = mysql_query("SELECT members FROM ".PREFIX."groups WHERE id='".$group_id."' LIMIT 1") OR die(mysql_error());
	$old_members = mysql_fetch_assoc($old_members); 	
	if($old_members != NULL) {
		$old_members = explode(",", trim($old_members['members'], ","));			
		$new_members = array();
		foreach($old_members as $value) {
			if($value != $member_id && $value != "") {
				$new_members[] = $value;
			}
		}		
		if(count($new_members) > 0) {
			$new_members = ",".implode(",", $new_members).",";
		} else {
			$new_members = NULL;
		}
		
	mysql_query("UPDATE `".PREFIX."groups` SET `members` = '".$new_members."' WHERE id = '".$group_id."' LIMIT 1") OR die(mysql_error());
	}

  }
  
  //Delete group
  if (isset($_GET['delgrp']) AND is_numeric($_GET['delgrp']) )	
  {
	$group_id = (int)$_GET['delgrp'];
	
	$sql = "DELETE FROM ".PREFIX."groups WHERE id='".$group_id." LIMIT 1'";
	mysql_query($sql) OR die(mysql_error());	
  }
  
  // Create group
  if(isset($_POST['newgrp']) AND $_POST['newgrp'] != "") {
	if (!get_magic_quotes_gpc()) {
		$group_name = addslashes($_POST['newgrp']);
		$group_desc = addslashes($_POST['grpdesc']);
	} else {
		$group_name = $_POST['newgrp'];
		$group_desc = $_POST['grpdesc'];
	}
	$sql = 'INSERT INTO '.PREFIX.'groups (`id`, `name`, `description`, `members`) VALUES (NULL, \''.$group_name.'\', \''.$group_desc.'\', NULL)';
	mysql_query($sql) OR die(mysql_error());	
 }
 /************************************* end of the CUSTOMIZED ***************************************************/
 
 
 
  // Delete Player
  if (isset($_GET['del']) AND is_numeric($_GET['del'])) {

  	// Delete by sid from all tables
  	$tables = array( 'spieler', 'dorf', 'hero', 'stat', 'truppen' );
  	foreach( $tables as $index => $table ) {
  		$sql = "DELETE FROM `".PREFIX."{$table}` WHERE `sid`=".(int)$_GET['del'];
    	mysql_query($sql) OR die(mysql_error());
  	}
  }  

  //--Spieler aktivieren
  if (isset($_GET['act']) AND is_numeric($_GET['act'])) {
  	$sql="UPDATE
            ".PREFIX."spieler
          SET
            aktiv='1'
		  WHERE
		    sid='".(int) $_GET['act']."'";
	mysql_query($sql);
  }

  //--Rechte bearbeiten
  if (isset($_POST['spielerid'], $_POST['seite'], $_POST['rechte']) AND $_POST['spielerid']!=$sid AND $rechte[1]=="3") {
  	//Rechte der anderen Seiten abrufen ...
  	$sql="SELECT
  	        rechte
  	      FROM
  	        ".PREFIX."spieler
  	      WHERE
  	        sid = '".(int) $_POST['spielerid']."'";
  	$result = mysql_query($sql);
  	$row    = mysql_fetch_assoc($result);
  	$spielerrechte = explode("|", $row['rechte']);
  	$spielerrechte[$_POST['seite']] = (int) $_POST['rechte'];
  	//... und mit dem ge�nderten Wert wieder in der Datenbank speichern
  	$sql="UPDATE
  	        ".PREFIX."spieler
  	      SET
  	        rechte='".$spielerrechte[0]."|".$spielerrechte[1]."|".$spielerrechte[2]."|".$spielerrechte[3]."'
  	      WHERE
  	        sid='".(int) $_POST['spielerid']."'";
  	mysql_query($sql) OR die(mysql_error());
  }
  
  
  /*
  * risi added custom functions here: askdelmem(), askdelgrp
  ****************************/

  //Javascript zum L�schen eines Spielers
  $script = "<script type=\"text/javascript\">";
  $script.=   "function askdel(sid) {";
  $script.=     "Check = confirm(\"".text('member_delq')."\");";
  $script.=     "if (Check == true) window.location.href = 'member.php?del=' + sid;";
  $script.=   "}";
  $script.=   "function askdelmem(sid,grp) {";
  $script.=     "Check = confirm(\"".text('member_delmemq')."\");";
  $script.=     "if (Check == true) window.location.href = 'member.php?delmem=' + sid + '&grp=' + grp;";
  $script.=   "}";
  $script.=   "function askdelgrp(grp) {";
  $script.=     "Check = confirm(\"".text('member_delgrpq')."\");";
  $script.=     "if (Check == true) window.location.href = 'member.php?delgrp=' + grp;";
  $script.=   "}";
  
  $script.= "</script>";

  write_header(text('memberlist_header'), $script);
?>

<div class="oben"><?php include "oben.php"; ?></div>
<div class="menu"><?php include "menu.php" ?></div>
<div class="mitte2">

  <table class="itable" cellpadding="2" cellspacing="1" width="300">
    <tr>
	  <td class="header1" colspan="8"><?php echo text('memberlist_header')?></td>
	</tr>
	<tr>
	  <td class="header2">#</td>
	  <td class="header2"><?php echo text('name')?></td>
<?php
  for ($i=0; $i<=3; $i++) {
  	echo "<td class=\"header2 infbox\" title=\"".text('member_'.$i)."\">".($i+1)."</td>";
  }
  /**************risi****************/
  echo "<td class=\"header2 infbox\" title=\"".text('header_group')."\" >".text('header_group')."</td> ";
  /**************end****************/
  if ($rechte[1]=="3") { echo "<td class=\"header2\"></td>"; }
  echo "</tr>";

  $sql="SELECT
          name,
		  sid,
		  rechte		 
        FROM
          ".PREFIX."spieler
        WHERE
          aktiv='1'
		ORDER BY
		  name ASC";
  $result=mysql_query($sql) OR die(mysql_error());

  $rowodd = false;
  $count = 0;
  while ($row=mysql_fetch_assoc($result)) {
  	$rowodd = !$rowodd;
  	$count++;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';

  	echo "<tr>";
	
  	//Zeilennummer
  	echo "<td{$tdclass}>".zerofill($count,3)."</td>";
	
  	//Spielername + Kontaktlink
	if ($rechte[0]=="2" && $rechte[3]=="2") {
		echo "<td{$tdclass}><a href=\"showtroops.php?spieler=".urlencode($row['name'])."\" onmouseover=\"return overlib('<img src=\'image.php?u=".urlencode($row['name'])."\' alt=\'".$row['name']."\' border=\'0\' style=\'margin:0px;\'>');\" onmouseout=\"return nd();\">".$row['name']."</a>".contact_member($row['name'])."</td>";
	} elseif ($rechte[3]=="2") {
		echo "<td{$tdclass} onmouseover=\"return overlib('<img src=\'image.php?u=".urlencode($row['name'])."\' alt=\'".$row['name']."\' border=\'0\' style=\'margin:0px;\'>');\" onmouseout=\"return nd();\">".$row['name'].contact_member($row['name'])."</td>";
	} else {
		echo "<td{$tdclass}>".$row['name'].contact_member($row['name'])."</td>";
	}
	
  	//Rechte
  	$userrechte=explode('|', $row['rechte']);
	
  	for ($j=0; $j<=3; $j++) {
	  	if ($rechte[1]=="3") {
  			echo "<td{$tdclass}><a onmouseover=\"return overlib('".text("rechte_".$userrechte[$j])."');\" onclick=\"return overlib('".change_rights($j, $row['sid'])."', STICKY, CAPTION, '<font color=\'black\'>".$row['name']."</font>');\" onmouseout=\"return nd();\"><img src=\"".recht_img($userrechte[$j])."\" alt=\"".text("rechte_".$userrechte[$j])."\"></a></td>";
	  	} else {
  			echo "<td{$tdclass} title=\"".text("rechte_".$userrechte[$j])."\"><img src=\"".recht_img($userrechte[$j])."\" alt=\"".text("rechte_".$userrechte[$j])."\"></td>";
	  	}
  	}
	
	//***************** risi ********************************
	echo '<td>'.get_his_groups($row['sid']).'</td>';
	//****end*********

  	if ($rechte[1]=="3") {
  		if ($row['sid']!=$sid) {
			//l�schen
			echo "<td{$tdclass}><a href=\"javascript:askdel(".$row['sid'].");\"><img src=\"img/del.gif\" title=\"".text('member_del')."\"></a></td>";
  		} else {
	  		//man darf sich nicht selber l�schen
	  		echo "<td{$tdclass}></td>";
  		}
  	}
  	echo "</tr>";
  }
?>
  </table><br>

<?php
  //nur anzeigen, wenn Spieler das Recht hat die Mitgliederliste zu bearbeiten
  if ($rechte[1]=="3") {
?>
<div style="position:absolute; left:320px; top:0px;">
  <table class="itable" cellpadding="2" cellspacing="1" width="400">
    <tr>
	  <td class="header1" colspan="6"><?php echo text('member_header')?></td>
	</tr>
	<tr>
	  <td class="header2">#</td>
	  <td class="header2"><?php echo text('name')?></td>
	  <td class="header2"><?php echo text('member_tribe')?></td>
	  <td class="header2"><?php echo text('member_date')?> <?php echo sortarrow(1)?></td>
	  <td class="header2" colspan="2"></td>
	</tr>
<?php
  $sql="SELECT
          name,
		  sid,
		  volk,
		  start
        FROM
          ".PREFIX."spieler
        WHERE
          aktiv='0'
		ORDER BY
		  start DESC";
  $result=mysql_query($sql) OR die(mysql_error());

  $rowodd = false;
  $count = 0;
  if (mysql_num_rows($result)<1) {
  	echo "<tr><td colspan=\"6\" class=\"footer\">".zero('-')."</td></tr>";
  }

  while ($row=mysql_fetch_assoc($result)) {
  	$rowodd = !$rowodd;
  	$count++;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';

  	echo "<tr>";
  	echo "<td{$tdclass}>".zerofill($count,3)."</td>";
  	echo "<td{$tdclass}>".$row['name'].contact_member($row['name'])."</td>";
  	echo "<td{$tdclass}>".text('volk_'.$row['volk'])."</td>";
  	echo "<td{$tdclass}>".changedate($row['start'], true)."</td>";
  	echo "<td{$tdclass}><a href=\"?act=".$row['sid']."\" title=\"".text('member_ok')."\"><img src=\"img/ok.gif\"></a></td>";
	echo "<td{$tdclass}><a href=\"?del=".$row['sid']."\" title=\"".text('member_no')."\"><img src=\"img/del.gif\"></a></td>";
  	echo "</tr>";
  }
  //niemand neu angemeldet
  if (empty($row['name']) AND $i==1) {
  	echo "<tr>";
  	echo "<td colspan=\"5\">".text('member_nonewmembers')."</td>";
	echo "</tr>";
  }
  echo "</table>";
  echo "<br><br>";

  echo "</div>";
  }
?>

<!-- ************ risi **************** -->


<table class="itable" cellpadding="2" cellspacing="1" width="300">
    <tr>
	  <td class="header1" colspan="8"><?php echo text('grouplist_header')?></td>
	</tr>
	<tr>
	  <td class="header2">#</td>
	  <td class="header2"><?php echo text('name')?></td>
	  <td class="header2"><?php echo text('members')?></td>
	  <td class="header2" colspan="2"></td>
	</tr>
<?php
$result = mysql_query("SELECT * FROM ".PREFIX."groups ") OR die(mysql_error());
$result2 = mysql_query("SELECT sid, name FROM ".PREFIX."spieler WHERE 1") OR die(mysql_error());
while($row = mysql_fetch_assoc($result2)) {
	$member_names[$row['sid']] = (get_magic_quotes_gpc()) ? $row['name'] : stripslashes($row['name']);
}
$rowodd = false;
$count = 0;

while($row = mysql_fetch_assoc($result)) {
	//find all members who belong here
	$members_str = "";
	//$row['description'] = (get_magic_quotes_gpc()) ? $row['description'] : stripslashes($row['description']) ;
	//$row['members'] = (get_magic_quotes_gpc()) ? $row['members'] : stripslashes($row['members']);
	$members = explode(",", trim($row['members'], ","));
	//die(print_r($members));
	
	//check for the users that no longer exist and remove them from members
	$members_count = count($members);
	foreach($members as $key => $this_member) {
			if(!array_key_exists($this_member, $member_names)) {
				unset($members[$key]);
			}
	}
	if($members_count != count($members)) {
		//the number of members has changed, the group needs to be updated
		$members_to_db = (count($members) > 0) ? ",".implode("", $members)."," : ''; 
		$sql = "UPDATE ".PREFIX."groups SET `members` = '".$members_to_db."' WHERE `id` =".$row['id']." LIMIT 1";
		mysql_query($sql) OR die(mysql_error());
	}
	
	
	
	if($members[0] != "" && $members[0] != NULL) {
	    foreach($members as $this_member) {
			
				$members_str .= "<a onmouseover=\"return overlib('".text('member_del')."');\" onclick=\"return overlib('".delete_member($this_member,$row['id'])."', STICKY, CAPTION, '<font color=\'black\'>".htmlentities($member_names[$this_member])."</font>');\" onmouseout=\"return nd();\" style='cursor:pointer;'>".htmlentities($member_names[$this_member])."</a>, ";
			
		}
	}

	
  	$rowodd = !$rowodd;
  	$count++;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';

  	echo "<tr>";
  	echo "<td{$tdclass}>".$row['id']."</td>";
  	echo "<td{$tdclass} onmouseover=\"return overlib('".htmlspecialchars($row['description'])."');\" onmouseout=\"return nd();\" >".$row['name']."</td>";
	echo "<td{$tdclass}>".$members_str."</td>";
	
	echo "<td{$tdclass}><a onclick=\"return overlib('".add_member($row['id'])."', STICKY, CAPTION, '<font color=\'black\'>".text('add_member')."</font>');\"  onmouseout=\"return nd();\"   style='cursor:pointer;' ><img src=\"img/user_add.png\" alt=\"".text('add_member')."\" title=\"".text('add_member')."\" /></a></td>";
	
	echo "<td{$tdclass}><a href=\"javascript:askdelgrp(".$row['id'].");\" style=\"cursor:pointer;\" title=\"".text('delete_group')."\"><img src=\"img/group_delete.png\"></a></td>";

  	echo "</tr>";
}
$member_names = "";

echo "<tr><td colspan=\"6\" class=\"footer\"><a onclick=\"return overlib('".add_group($row['id'])."', STICKY, CAPTION, '<font color=\'black\'>".text('add_group')."</font>');\"  onmouseout=\"return nd();\"   style='cursor:pointer;'><img src=\"img/group_add.png\" alt=\"".text('add_group')."\" title=\"".text('add_group')."\" /></a></td></tr>";

?>
	
</table>

<!-- ************ end risi **************** -->

</div>

</body>
</html>