<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/12/18 waRhawK dropped hardcoded site title out of the write_header() call
 * @since 2007/12/18 waRhawK rewrite sql using joins to fix bug that troops were not shown if corresponding villages missing
 * @since 2007/12/18 waRhawK synchronized troop appeareance with the list from user.php, use format_village() for village name display
 * @since 2007/12/18 waRhawK synchronized hero appeareance with the list from hero.php, including the new active state
 */
  require_once "config.php";

  security();

  //definieren der Variabeln
  if (!empty($_GET['spieler'])) {
	  	$spielername = htmlspecialchars($_GET['spieler']);
	  	$sql="SELECT
	  	        sid,
	  	        volk,
	  	        start,
	  	        lastlogin
	  	      FROM
	  	        ".PREFIX."spieler
	  	      WHERE
	  	        name = '".$spielername."'";

	  	$r=mysql_fetch_assoc(mysql_query($sql));

	  	$spielerid   = $r['sid'];
	  	$spielervolk = $r['volk'];
	  	$start       = $r['start'];
	  	$lastlogin   = $r['lastlogin'];
  } else {
  	fwd('admin.php');
  }

write_header(text('troops_detail')." ({$spielername})");
?>

<div class="oben"><?php include "oben.php"; ?></div>
<div class="menu"><?php include "menu.php"; ?></div>
<div class="mitte2">
<table class="itable" cellpadding="2" cellspacing="1">
	<tr>
		<td class="header1" colspan="12"><?php echo $spielername?><?php echo text('user_troops_of')?></td>
	</tr>
    <tr>
        <td class="header2" width="180"><?php echo text('user_her')?></td>
        <td class="header2" width="180"><?php echo text('user_sta')?></td>
<?php
  //Tabellenheader Volksspezifisch darstellen
  for ($i=1; $i<=10; $i++) {
  	echo "<td class=\"header2\" width=\"20\"><img src=\"".img_pfad($spielervolk, $i)."\" title=\"".text('t_'.$spielervolk.$i)."\" alt=\"".text('t_'.$spielervolk.$i)."\"></td>";
  }
?>
    </tr>
<?php
  //--Abfrage der Truppen
  // @since 2007/09/01 waRhawK added ordering by village name ascending
  // @since 2007/12/18 waRhawK rewrite sql using joins to fix bug that troops were not shown if corresponding villages missing
  $sql = "SELECT ".
         "t.tid, t.x1, t.y1, ".
         "d1.name AS vil_origin, ".
         "t.x2, t.y2, ".
         "d2.name AS vil_position, ".
         "t.t1, t.t2, t.t3, t.t4, t.t5, t.t6, t.t7, t.t8, t.t9, t.t10 ".
         "FROM ".PREFIX."truppen t ".
         "LEFT JOIN ".PREFIX."dorf d1 ON (d1.x=t.x1 AND d1.y=t.y1) ".
         "LEFT JOIN ".PREFIX."dorf d2 ON (d2.x=t.x2 AND d2.y=t.y2) ".
         "WHERE t.sid=".(int)$spielerid." ".
         "ORDER BY d1.name ASC, d2.name ASC";
  $result = mysql_query($sql) OR die(mysql_error());

  //--Anzeige der Truppen
  // @since 2007/12/18 waRhawK synchronized troop appeareance with the list from user.php, use format_village() for village name display 
  $rowodd = false;
  while ($row = mysql_fetch_assoc($result)) {
  	
  	$rowodd = !$rowodd;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';
	
  	//Anfang der Zeile
  	echo "<tr>";
  	//Herkunft
  	echo format_village($row['vil_origin'], $row['x1'], $row['y1'], $tdclass);
  	//Standort
  	echo format_village($row['vil_position'], $row['x2'], $row['y2'], $tdclass);
  	//Truppen
  	for ($i=1; $i<=10; $i++) {
	    echo "<td>".zero($row['t'.$i])."</td>";
  	}
  	//Ende der Zeile
    echo "</tr>";
  }

  //--Anzeige der Summe
  echo "<tr><td colspan=\"2\" class=\"header2\"><b>".text('admin_sum')."</b></td>";
  //Berechnung der Summe
  $sql="SELECT
          sum(t1), sum(t2), sum(t3), sum(t4), sum(t5), sum(t6), sum(t7), sum(t8), sum(t9), sum(t10)
        FROM
          ".PREFIX."truppen
		WHERE
		  sid='".$spielerid."'";
  $result = mysql_query($sql) OR die(mysql_error());
  $row = mysql_fetch_assoc($result);
  //Ausgabe der Summe
  for ($i=1; $i<=10; $i++) {
  	echo "<td class=\"zeile2\">".zero($row['sum(t'.$i.')'])."</td>";
  }
  //Zeilenende
  echo "</tr>";

  //--Tabellenende
  echo "</table>";

?>

<!--D.F. START-->
<!--Player Villages-->
<br>

<!--Table header-->
<table class="itable" cellpadding="2" cellspacing="1">
	<tr>
		<td class="header1" colspan="10"><?php echo text('list_villages')?></td>
	</tr>
    <tr>
        <td class="header2">#</td>
        <td class="header2" colspan="2"><?php echo text('dorf_name')?></td>
        <td class="header2"><?php echo text('dorf_size')?></td>
        <td class="header2"><?php echo text('dorf_mauer')?></td>
        <td class="header2"><?php echo text('dorf_turnier')?></td>
        <td class="header2"><?php echo text('dorf_palast')?></td>
        <td class="header2"><?php echo text('dorf_residenz')?></td>
        <td class="header2"><?php echo text('dorf_kornspeicher')?></td>
        <td class="header2"><?php echo text('dorf_getreide')?></td>
    </tr>
<?php
  //--Abfrage der Doerfer aus der Datenbank
  $sql="SELECT
  	        x, y,
  	        name,
  	        type,
  	        layout,
  	        size,
  	        mauer,
  	        turnier,
  	        palast,
  	        residenz,
  	        kornspeicher,
  	        getreide,
            did
          FROM
            ".PREFIX."dorf
          WHERE
		    sid='".(int) $spielerid."'
		  ORDER BY
		    name ASC";
  $result = mysql_query($sql) OR die(mysql_error());

  //--Anzeige der Doerfer
  $rowodd = false;
  $count = 0;
  while ($row = mysql_fetch_assoc($result)) {
  	$rowodd = !$rowodd;
  	$count++;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';
  	$hint = (is_numeric($row['type'])?text('dorf_type_'.$row['type']):'');
  	$hint.= (is_numeric($row['type']) && $row['type']<3 && is_numeric($row['layout'])?', '.text('dorf_layout_'.$row['layout']):'');

  	//Zeilenbeginn
  	echo "<tr>";
  	//Nummer
	echo "<td{$tdclass}>".zerofill($count,3)."</td>";
	// Typ
	switch($row['type']) { case 0:$img=5;break; case 1:$img=1;break; case 2:$img=3; break; case 3:$img=2; break; default:$img=5;break; }
	echo "<td{$tdclass}><img src=\"img/b{$img}.gif\" title=\"{$hint}\"></td>";
  	//Dorfname + Koordinaten
  	echo "<td align=\"left\" title=\"{$hint}\"{$tdclass}>".$row['name']." (".$row['x']."|".$row['y'].")</td>";
  	if (is_numeric($row['type']) && $row['type']==3) {
	  	echo "<td colspan=\"7\"{$tdclass}>".zero('-')."</td>";

  	} else {
	  	//Residents
	  	echo "<td{$tdclass}>".zero($row['size'])."</td>";
	  	//Mauer
	  	echo "<td{$tdclass}>".zero($row['mauer'])."</td>";
	  	//Turnierplatz
	  	echo "<td{$tdclass}>".zero($row['turnier'])."</td>";
	  	//Palast
	  	echo "<td{$tdclass}>".zero($row['palast'])."</td>";
	  	//Residenz
	  	echo "<td{$tdclass}>".zero($row['residenz'])."</td>";
	  	//Kornspeicher
	  	echo "<td{$tdclass}>".zero($row['kornspeicher'])."</td>";
	  	//Getreide
	  	echo "<td{$tdclass}>".zero($row['getreide'])."</td>";
    }
    //Zeilenende
    echo "</tr>";
  }
  //--Ende der Tabelle
  echo '</table>';

  //D.F. END
  
  //Helden nur bei T3 anzeigen
  // @since 2007/12/18 waRhawK synchronized hero appeareance with the list from hero.php, including the new active state 
  if (TRAVIAN_VERSION == 3) {

  //--Zeilenumbruch
  echo "<br>";

  //--Anfang Tabelle (Helden)
  echo "<table class=\"itable\" cellpadding=\"2\" cellspacing=\"1\">";
  echo "<tr>";
  echo "<td class=\"header1\" colspan=\"7\">".text('troops_hero')."</td>";
  echo "</tr>";

  //--Tabellenheader
  //Zeilenanfang
  echo "<tr>";
  //Leerspalten
  echo "<td class=\"header2\"></td>";
  //Name (Typ)
  echo "<td class=\"header2\">".text('hero_name')." (".text('hero_typ').")</td>";
  //aktueller Standort
  echo "<td class=\"header2\">".text('hero_sta')."</td>";
  //Angriffswert
  echo "<td class=\"header2\">".text('hero_off')."</td>";
  //Verteidigungswert
  echo "<td class=\"header2\">".text('hero_def')."</td>";
  //Off-Bonus
  echo "<td class=\"header2\">".text('hero_off-bonus')."</td>";
  //Def-Bonus
  echo "<td class=\"header2\">".text('hero_def-bonus')."</td>";
  //Zeilenende
  echo "</tr>";
  
  //--Abfrage der Helden aus der Datenbank
  $sql="SELECT
          id,
          sid,
          active,
          name,
          typ,
          x,
          y,
          off,
          def_inf,
          def_kav,
          off_bonus,
          def_bonus
        FROM
          ".PREFIX."hero
		WHERE
		  sid = '".(int) $spielerid."'";
  $result = mysql_query($sql) OR die(mysql_error());

  //--Anzeige der Helden
  $rowodd = false;
  while ($row = mysql_fetch_assoc($result)) {
  	$rowodd = !$rowodd;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';
	
  	//Zeilenbeginn
  	echo "<tr>";
    //Aktiv
    if ($row['active']=='1') {
    	$tdtitle=' title="'.text('hero_active').'"';
    	echo "<td{$tdclass}{$tdtitle}><img src=\"img/b1.gif\" title=\"".text('hero_active')."\"></td>";
    } else {
    	$tdtitle=' title="'.text('hero_inactive').'"';
    	echo "<td{$tdclass}{$tdtitle}><img src=\"img/b5.gif\" title=\"".text('hero_inactive')."\"></td>";
    }
  	//Name (Typ)
  	echo "<td{$tdclass}{$tdtitle}> ".$row['name']." (".$row['typ'].")</td>";
  	//Standort
  	echo "<td{$tdclass}{$tdtitle}>(".$row['x']."|".$row['y'].")</td>";
  	//Angriffswert
  	echo "<td{$tdclass}{$tdtitle}>".zero($row['off'])."</td>";
  	//Verteidigungswert
  	echo "<td{$tdclass}{$tdtitle}>".zero($row['def_inf'])."/".zero($row['def_kav'])."</td>";
	//Off-Bonus
	echo "<td{$tdclass}{$tdtitle}>".zero($row['off_bonus'].'%')."</td>";
	//Def-Bonus
	echo "<td{$tdclass}{$tdtitle}>".zero($row['def_bonus'].'%')."</td>";
    //Zeilenende
    echo "</tr>";
  }

  //--Ende der Tabelle (Helden)
  echo "</table>";

  //ENDE -- Helden nur bei T3 anzeigen
  }

  //--Zeilenumbruch
  echo "<br>";

  //--Anfang Tabelle (stat + sonst)
  echo "<table class=\"itable\" cellpadding=\"0\" cellspacing=\"1\">";

  //--Statistikbild
  echo "<tr><td class=\"header1\" colspan=\"2\">".text('troops_stat')."</td></tr>";
  echo "<tr><td class=\"header2\" colspan=\"2\" style=\"padding:0px;\"><img src=\"image.php?u=".urlencode($spielername)."\" alt=\"\" border=\"0\" style=\"margin:0px;\"></td></tr>";

  //--Sonstiges (lastlogin+lastchange)
  echo "<tr><td class=\"header2\" width=\"50%\">".text('member_date').":</td><td>".changedate($start, true)."</td></tr>";
  echo "<tr><td class=\"header2\" width=\"50%\">".text('lastlogin').":</td><td>".changedate($lastlogin, true)."</td></tr>";

  //--Tabellenende
  echo "</table>";
?>



</div>

</body>
</html>