<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/07/21 waRhawK complete rewrite
 * @since 2007/11/03 waRhawK added option to disable arrival timing at all for just gathering walktime durations
 * @since 2007/11/03 waRhawK rewrite of and enabled all time incrementors
 * @since 2007/11/03 waRhawK implemented new JS calendar for picking up an arrival date
 * @since 2007/11/03 waRhawK allowed for localized date format in field order using new language specs
 */
define('CALLER', 'umkreis.php');
require_once "config.php";
security();



	/**************************************************************
	 *                                                            *
	 *   Initialization                                           *
	 *                                                            *
	 **************************************************************/

// Headercode
write_header(text('umkreis_header'));

// Form Variables
$x			= (isset($_POST['x']))				? $_POST['x'] 			: '0';
$y			= (isset($_POST['y']))				? $_POST['y'] 			: '0';
$qs_sid		= (isset($_POST['qs_sid'])) 		? $_POST['qs_sid'] 	: '';
$qs_vil		= (isset($_POST['qs_vil'])) 		? $_POST['qs_vil'] 	: '';
$time_h		= (isset($_POST['time_h']))		? $_POST['time_h'] 	: date('H');
$time_m		= (isset($_POST['time_m']))		? $_POST['time_m']		: date('i');
$time_s		= (isset($_POST['time_s']))		? $_POST['time_s'] 	: date('s');
$date_d 	= (isset($_POST['date_d'])) 		? $_POST['date_d'] 	: date('d');
$date_m 	= (isset($_POST['date_m'])) 		? $_POST['date_m'] 	: date('m');
$date_y 	= (isset($_POST['date_y'])) 		? $_POST['date_y'] 	: date('Y');
$date_full 	= (isset($_POST['date_full'])) 	? $_POST['date_full'] 	: date(text('date_short'));
$timing    	= (isset($_POST['timing'])) 		? $_POST['timing'] 	: '0';
$art 		= (isset($_POST['art']))			? $_POST['art']			: '';
$use_sp 	= (isset($_POST['use_sp'])) 		? $_POST['use_sp'] 	: '2';
$use_id 	= (isset($_POST['use_id'])) 		? $_POST['use_id'] 	: '2';
$use_kd 	= (isset($_POST['use_kd'])) 		? $_POST['use_kd'] 	: '2';
$use_io 	= (isset($_POST['use_io'])) 		? $_POST['use_io'] 	: '2';
$use_ko 	= (isset($_POST['use_ko'])) 		? $_POST['use_ko'] 	: '2';
$use_rm 	= (isset($_POST['use_rm'])) 		? $_POST['use_rm'] 	: '2';
$use_kt 	= (isset($_POST['use_kt'])) 		? $_POST['use_kt'] 	: '2';
$use_ad 	= (isset($_POST['use_ad'])) 		? $_POST['use_ad'] 	: '2';
$use_hr 	= (isset($_POST['use_hr'])) 		? $_POST['use_hr'] 	: '2';
$qnt_mode	= (isset($_POST['qnt_mode']))		? $_POST['qnt_mode'] 	: '';
$qnt_size	= (isset($_POST['qnt_size']))		? $_POST['qnt_size'] 	: '3';
$qnt_min 	= (isset($_POST['qnt_min']))		? $_POST['qnt_min'] 	: '0';
$qnt_max	= (isset($_POST['qnt_max']))		? $_POST['qnt_max'] 	: '0';
$qnt_lmt	= (isset($_POST['qnt_lmt']))		? $_POST['qnt_lmt'] 	: '0';
$qnt_rat	= (isset($_POST['qnt_rat']))		? $_POST['qnt_rat'] 	: '';
$src 		= (isset($_POST['src']))			? $_POST['src']			: 'all';
$route		= (isset($_POST['route']))			? $_POST['route']		: 0;
$lmt_t		= (isset($_POST['lmt_t']))			? $_POST['lmt_t']		: '0';
$lmt_t_h	= (isset($_POST['lmt_t_h']))		? $_POST['lmt_t_h']	: '';
$lmt_t_m	= (isset($_POST['lmt_t_m']))		? $_POST['lmt_t_m']	: '';
$lmt_t_s	= (isset($_POST['lmt_t_s']))		? $_POST['lmt_t_s']	: '';
$lmt_d		= (isset($_POST['lmt_d']))			? $_POST['lmt_d']		: '0';
$lmt_d_f	= (isset($_POST['lmt_d_f']))		? $_POST['lmt_d_f']	: '';

// Security: limit to own troops
if ($rechte[2]==1) {
	$src = 'own_tr';
}

// Prefetch players and villages for quick selection
$player_list = array();
$village_list_js = array();
$village_list_full = array();

// Read players
$sql="SELECT ".
     "name, sid, rechte ".
     "FROM ".
     PREFIX."spieler ".
     "WHERE ".
     "aktiv='1' ".
     "ORDER BY ".
     " name ASC";

$res=mysql_query($sql) OR die(mysql_error());
while ($row=mysql_fetch_assoc($res)) {
  	$player_list[ $row['sid'] ] = $row['name'];
  	$village_list[ $row['sid'] ] = array();

  	// Read villages per player
    $sql="SELECT * ".
         "FROM ".
         PREFIX."dorf ".
         "WHERE ".
         "sid='".(int)$row['sid']."' ".
         "ORDER BY ".
         "name ASC";

    $res2 = mysql_query($sql) OR die(mysql_error());
  	while ($row2 = mysql_fetch_assoc($res2)) {

  		$village_list_js[ $row['sid'] ][ $row2['did'] ] = array( $row2['did'], $row2['name'], $row2['x'], $row2['y'] );
  		$village_list_full[$row2['x'].'|'.$row2['y']] = $row2;
  	}
}

	/**************************************************************
	 *                                                            *
	 *   Form Functions                                           *
	 *                                                            *
	 **************************************************************/


echo '
	<script type="text/javascript">
	<!--
	var spielerliste = new Array();
	var dorfliste = new Array();
	var datePickerFMT = \''.text('date_picker_fmt').'\';
	var datePickerSEP = \''.text('date_picker_sep').'\';
';

// Build player and village arrays
if ( is_array( $player_list ) ) {
	foreach( $player_list as $key => $val ) {
	    echo "spielerliste[ {$key} ] = '{$val}';\n";
	    echo "dorfliste[ {$key} ] = new Array();\n";
	    if ( isset( $village_list_js[$key] ) && is_array( $village_list_js[$key] ) ) {
	    	foreach( $village_list_js[$key] as $key2 => $val2 ) {
				echo "dorfliste[ {$key} ][ {$key2} ] = new Array({$val2[0]},'{$val2[1]}',{$val2[2]},{$val2[3]});\n";
	    	}
	    }
	}
}

echo '
	function updDateFromPicker() {
		var val = document.getElementById(\'date_full\').value;
		var parts = val.split(datePickerSEP);
		for(var i=0; i<=2; i++) {
			var part = datePickerFMT.substring(i,i+1);
			document.getElementById(\'date_\'+part).value = parts[i];
		}
	}
	function updDateFromFields() {
		updLeadingZeroes();
		var parts = new Array();
		for(var i=0; i<=2; i++) {
			var part = datePickerFMT.substring(i,i+1);
			parts[i] = document.getElementById(\'date_\'+part).value;
		}
		document.getElementById(\'date_full\').value = parts.join(datePickerSEP);
	}
	function updTimingUsage() {
		var usage = document.getElementById(\'timing\').checked;
		document.getElementById(\'date_d\').disabled = !usage;
		document.getElementById(\'date_m\').disabled = !usage;
		document.getElementById(\'date_y\').disabled = !usage;
		document.getElementById(\'time_h\').disabled = !usage;
		document.getElementById(\'time_m\').disabled = !usage;
		document.getElementById(\'time_s\').disabled = !usage;
		if (usage) {
			document.getElementById(\'dateDisabled\').style.display = "none";
			document.getElementById(\'dateEnabled\').style.display = "";
			document.getElementById(\'timeDisabled\').style.display = "none";
			document.getElementById(\'timeEnabled\').style.display = "";
		} else {
			document.getElementById(\'dateEnabled\').style.display = "none";
			document.getElementById(\'dateDisabled\').style.display = "";
			document.getElementById(\'timeEnabled\').style.display = "none";
			document.getElementById(\'timeDisabled\').style.display = "";
		}
	}
    function updVillageList( spieler, dorfaktiv ) {
		var dorfwahl = document.forms[0].elements.qs_vil;
		var dorfmarker = false;
		while( dorfwahl.length > 1 ) {
			dorfwahl.options[ dorfwahl.length - 1 ] = null;
		}
		if ( spieler == "" || dorfliste[spieler].length < 1 ) {
			dorfeintrag = new Option( "(keine)", "", false, false);
			dorfwahl.options[dorfwahl.length] = dorfeintrag;
		} else {
			for( var did in dorfliste[ spieler ] ) {
				dorf = dorfliste[ spieler ][ did ];
				dorfmarker = ( dorfaktiv == dorf[0] );
				dorfeintrag = new Option( dorf[1] + " (" + dorf[2] + "|" + dorf[3] + ")", dorf[0], false, dorfmarker);
				dorfwahl.options[dorfwahl.length] = dorfeintrag;
			}
		}
	}
	function updTarget( dorf ) {
		spieler = document.forms[0].elements.qs_sid.options[ document.forms[0].elements.qs_sid.selectedIndex ].value;
		document.forms[0].elements.x.value = dorfliste[spieler][dorf][2];
		document.forms[0].elements.y.value = dorfliste[spieler][dorf][3];
	}
	function getDateFromFieldSet() {
		var date = new Date();
		date.setDate(		document.getElementById(\'date_d\').value );
		date.setMonth(	document.getElementById(\'date_m\').value-1 );
		date.setFullYear(	document.getElementById(\'date_y\').value );
		date.setHours(	document.getElementById(\'time_h\').value );
		date.setMinutes(	document.getElementById(\'time_m\').value );
		date.setSeconds(	document.getElementById(\'time_s\').value );
		date.setMilliseconds(0);
		return date;
	}
	function updArrDate(offset) {
		if (offset>0) {
			var date = getDateFromFieldSet();
			date.setTime( date.getTime() + (offset*24*60*60*1000));
		} else {
			var date = new Date();
		}
		document.getElementById(\'date_d\').value = date.getDate();
		document.getElementById(\'date_m\').value = date.getMonth()+1;
		document.getElementById(\'date_y\').value = date.getFullYear();
		updDateFromFields();
	}
	function updArrTime(offset) {
		if (offset>0) {
			var date = getDateFromFieldSet();
			var oldday = date.getDate();
			date.setTime( date.getTime() + (offset*60*1000));
			var newday = date.getDate();
			if (oldday!=newday) {
				updArrDate(1);
			}
		} else {
			var date = new Date();
		}
		document.getElementById(\'time_h\').value = date.getHours();
		document.getElementById(\'time_m\').value = date.getMinutes();
		document.getElementById(\'time_s\').value = date.getSeconds();
		updLeadingZeroes();
	}
	function updLeadingZeroes() {
		var fields = new Array(\'date_d\', \'date_m\', \'date_y\', \'time_h\', \'time_m\', \'time_s\');
		for( var field in fields ) {
			val = document.getElementById(fields[field]).value;
			if (val.length < 2) {
				document.getElementById(fields[field]).value = \'0\' + val;
			}
		}
	}
	function updTroops( aMode ) {

		// Sp�her
		if ( aMode == "msc_sp" ) document.forms[0].elements.use_sp[0].checked = true
        else document.forms[0].elements.use_sp[1].checked = true;

		// Infantrie Defensiv
		if ( aMode == "def_i" ) document.forms[0].elements.use_id[0].checked = true
		else if ( aMode == "def_ik" ) document.forms[0].elements.use_id[2].checked = true
		else document.forms[0].elements.use_id[1].checked = true;

		// Kavallerie Defensiv
		if ( aMode == "def_k" ) document.forms[0].elements.use_kd[0].checked = true
		else if ( aMode == "def_ik" ) document.forms[0].elements.use_kd[2].checked = true
		else document.forms[0].elements.use_kd[1].checked = true;

		// Infantrie Offensiv
		if ( aMode == "off_i" || aMode == "off_ig" || aMode == "adl_ai" || aMode == "fak_m" ) document.forms[0].elements.use_io[0].checked = true
		else if ( aMode == "off_ik" || aMode == "off_ikg" || aMode == "adl_aik" || aMode == "adl_aikg" || aMode == "msc_ss" || aMode == "msc_ls" || aMode == "fak_a" ) document.forms[0].elements.use_io[2].checked = true
		else document.forms[0].elements.use_io[1].checked = true;

		// Kavallerie Offensiv
		if ( aMode == "off_k" || aMode == "off_kg" || aMode == "adl_ak" || aMode == "fak_f" ) document.forms[0].elements.use_ko[0].checked = true
		else if ( aMode == "off_ik" || aMode == "off_ikg" || aMode == "adl_aik" || aMode == "adl_aikg" || aMode == "msc_ss" || aMode == "msc_ls" || aMode == "fak_a" ) document.forms[0].elements.use_ko[2].checked = true
		else document.forms[0].elements.use_ko[1].checked = true;

		// Rammen & Katapulte
		if ( aMode == "off_g" || aMode == "fak_s" ) document.forms[0].elements.use_rm[0].checked = document.forms[0].elements.use_kt[0].checked = true
		else if ( aMode == "off_ig" || aMode == "off_kg" || aMode == "off_ikg" || aMode == "adl_aikg" || aMode == "fak_a" ) document.forms[0].elements.use_rm[2].checked = document.forms[0].elements.use_kt[2].checked = true
		else document.forms[0].elements.use_rm[1].checked = document.forms[0].elements.use_kt[1].checked = true;

		// Adeleinheiten
		if ( aMode == "adl_a" || aMode == "adl_ai" || aMode == "adl_ak" || aMode == "adl_aik" || aMode == "adl_aikg" ) document.forms[0].elements.use_ad[0].checked = true
		else document.forms[0].elements.use_ad[1].checked = true;

		// Helden
		if ( aMode == "off_g" || aMode == "adl_a" || aMode == "fak_f" || aMode == "fak_s" || aMode == "fak_m" || aMode == "fak_a" || aMode == "msc_sp" || aMode == "msc_ss" || aMode == "msc_ls" ) document.forms[0].elements.use_hr[1].checked = true
		else document.forms[0].elements.use_hr[2].checked = true;

		// Truppenst�rke
		if ( aMode == "msc_ss" || aMode == "msc_ls" ) {
			document.forms[0].elements.qnt_mode.selectedIndex = 3;
			document.forms[0].elements.qnt_size[1].checked = true;
			document.forms[0].elements.qnt_min.value = ( ( aMode == "msc_ss" ) ? "" : 10000 );
			document.forms[0].elements.qnt_max.value = ( ( aMode == "msc_ss" ) ? 10000 : "" );
		} else if ( aMode == "fak_f" || aMode == "fak_m" || aMode == "fak_s" || aMode == "fak_a" ) {
			document.forms[0].elements.qnt_mode.selectedIndex = 1;
			document.forms[0].elements.qnt_size[0].checked = true;
			document.forms[0].elements.qnt_min.value = "";
			document.forms[0].elements.qnt_max.value = "";
		} else {
			document.forms[0].elements.qnt_mode.selectedIndex = 1;
			document.forms[0].elements.qnt_size[2].checked = true;
			document.forms[0].elements.qnt_min.value = "";
			document.forms[0].elements.qnt_max.value = "";
		}
	}
	//-->
	</script>
';



	/**************************************************************
	 *                                                            *
	 *   Form Generation                                          *
	 *                                                            *
	 **************************************************************/

?>
<div class="oben"><?php include "oben.php"; ?></div>
<div class="menu"><?php include "menu.php" ?></div>
<div class="mitte2">

	<form action="umkreis.php" method="post" accept-charset="utf-8">
	<input type="hidden" name="calc" value="1">

	<table class="itable" cellpadding="2" cellspacing="1" width="700">

		<tr>
			<td class="header1" colspan="4"><?php echo text('umkreis_header')?></td>
		</tr>

		<!-- Headers -->
		<tr>
			<td class="header2" width="130"><?php echo text('umkreis_col_val')?></td>
			<td colspan="2" class="header2" width="190"><?php echo text('umkreis_col_sel')?></td>
			<td class="header2" width="380"><?php echo text('umkreis_col_help')?></td>
		</tr>

		<!-- Target -->
		<tr>
	  		<td class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_target')?>:</label></td>
        	<td colspan="2">
		  		X: <input type="text" maxlength="4" size="3" class="ibox" name="x" value="<?php echo $x?>">
		  		Y: <input type="text" maxlength="4" size="3" class="ibox" name="y" value="<?php echo $y?>">
			</td>
			<td>
				<select class="ibox" name="qs_sid" onchange="updVillageList( document.forms[0].elements.qs_sid.options[ document.forms[0].elements.qs_sid.selectedIndex ].value )">
				<option value=""></option>
				<optgroup label="<?php echo text('list_members')?>">
<?php
// Player and village quickselect
if ( !is_array( $player_list ) || !count( $player_list ) ) {
	echo '<option value="">'.text('list_empty').'</option>';
} else {
	foreach( $player_list as $key => $val ) {
		echo '<option value="'.$key.'"'.(($qs_sid == $key)?' selected':'').'>'.$val.'</option>';
	}
}
?>
				</optgroup></select>
				<select class="ibox" name="qs_vil" onchange="updTarget( document.forms[0].elements.qs_vil.options[ document.forms[0].elements.qs_vil.selectedIndex ].value )">
				<option value=""></option>
				<optgroup label="<?php echo text('list_villages')?>">
				<option value=""><?php echo text('list_empty')?></option>
				</optgroup></select>
<?php
if (is_numeric($qs_sid) && $qs_sid > 0) {
	echo '<script type="text/javascript">updVillageList('.$qs_sid.', '.((is_numeric($qs_vil))?$qs_vil:0).');</script>';
}
?>
			</td>
		</tr>

		<!-- Arrival Date -->
		<tr>
		  	<td class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_arrival_date')?>:</label></td>
		  	<td rowspan="2" style="white-space:nowrap">
		  		<input type="checkbox" <?php echo ($timing)?'checked="checked"':'';?> class="checkbox" id="timing" name="timing" value="1" onClick="updTimingUsage();" />
				<input type="text" id="date_full" name="date_full" style="margin:0px; padding:0px; border:0px none; width:0px; height:0px;" value="<?php echo $date_full?>" onFocus="updDateFromPicker();" />
		  	</td>
	        <td style="white-space:nowrap;">
<?php
$datefmt = trim( strtolower( text('date_short') ) );
$res = '';
for( $i=0; $i<strlen($datefmt); $i++) {
	if ( in_array( $part = $datefmt[$i], array( 'd', 'm', 'y' ) ) ) {
		$field = 'date_'.$part;
		$res.= '<input type="text" maxlength="'.(($part=='y')?'4':'2').'" class="ibox" style="width:'.(($part=='y')?'32':'24').'px;" id="'.$field.'" name="'.$field.'" '.(($timing)?'':'disabled="disabled"').' value="'.$$field.'" onChange="updDateFromFields();" />'; 
	} elseif ( $part == text('date_picker_sep') ) {
		$res.= ' <b>'.$part.'</b> ';
	}
}
print $res."\n";
?>	        
	        </td>
	        <td>
	        	<div id="dateEnabled" style="display:<?php echo ($timing)?'':'none';?>">
					[ <a href="javascript:updArrDate(0);" title=""><?php echo text('umkreis_date_today')?></a> ]
					[ <a href="javascript:updArrDate(1);" title="">+1d</a> ]
					[ <a href="javascript:updArrDate(7);" title="">+1w</a> ]
					[ <a href="javascript:updArrDate(28);" title="">+4w</a> ]
					[ <a id="picker1" href="javascript:displayDatePicker('date_full', document.getElementById('picker1'), '<?php echo text('date_picker_fmt')?>', '<?php echo text('date_picker_sep')?>');" title="<?php echo text('umkreis_date_cal_hint')?>"><?php echo text('umkreis_date_cal')?></a> ]
				</div>
				<div id="dateDisabled" style="display:<?php echo ($timing)?'none':'';?>">
					<span class="grey"><?php echo text('umkreis_notimes_note1')?></span>
				</div>
	        </td>
		</tr>

		<!-- Arrival Time -->
		<tr>
		  	<td class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_arrival_time')?>:</label></td>
	        <td style="white-space:nowrap;">
				<input type="text" maxlength="2" size="3" class="ibox" style="width:28px;" id="time_h" name="time_h" <?php echo ($timing)?'':'disabled="disabled"';?> value="<?php echo $time_h?>" onChange="updLeadingZeroes();" />
				<b>:</b>
				<input type="text" maxlength="2" size="3" class="ibox" style="width:28px;" id="time_m" name="time_m" <?php echo ($timing)?'':'disabled="disabled"';?> value="<?php echo $time_m?>" onChange="updLeadingZeroes();" />
				<b>:</b>
				<input type="text" maxlength="2" size="3" class="ibox" style="width:28px;" id="time_s" name="time_s" <?php echo ($timing)?'':'disabled="disabled"';?> value="<?php echo $time_s?>" onChange="updLeadingZeroes();" />
	        </td>
	        <td>
	        	<div id="timeEnabled" style="display:<?php echo ($timing)?'':'none';?>">
					[ <a href="javascript:updArrTime(0);" title="<?php echo text('umkreis_time_now_hint')?>"><?php echo text('umkreis_time_now')?></a> ]
					[ <a href="javascript:updArrTime(15);" title="">+15m</a> ]
					[ <a href="javascript:updArrTime(60);" title="">+1h</a> ]
					[ <a href="javascript:updArrTime(180);" title="">+3h</a> ]
					[ <a href="javascript:updArrTime(360);" title="">+6h</a> ]
				</div>
				<div id="timeDisabled" style="display:<?php echo ($timing)?'none':'';?>">
					<span class="grey"><?php echo text('umkreis_notimes_note2')?></span>
				</div>
	        </td>
		</tr>

      	<!-- Mission Type -->
		<tr>
			<td class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_art')?>:</label></td>
			<td colspan="2">
				<select class="ibox" name="art" onchange="updTroops( document.forms[0].elements.art.options[ document.forms[0].elements.art.selectedIndex ].value )">
				<option value=""></option>
				<optgroup label="<?php echo text('umkreis_art_def')?>">
				<option value="def_i"<?php echo (($art=='def_i')?' selected':'')?>><?php echo text('umkreis_types_i')?></option>
				<option value="def_k"<?php echo (($art=='def_k')?' selected':'')?>><?php echo text('umkreis_types_k')?></option>
				<option value="def_ik"<?php echo (($art=='def_ik')?' selected':'')?>><?php echo text('umkreis_types_both')?></option>
				</optgroup>
				<optgroup label="<?php echo text('umkreis_art_off')?>">
				<option value="off_i"<?php echo (($art=='off_i')?' selected':'')?>><?php echo text('umkreis_types_i')?></option>
				<option value="off_k"<?php echo (($art=='off_k')?' selected':'')?>><?php echo text('umkreis_types_k')?></option>
				<option value="off_g"<?php echo (($art=='off_g')?' selected':'')?>><?php echo text('umkreis_types_g')?></option>
				<option value="off_ik"<?php echo (($art=='off_ik')?' selected':'')?>><?php echo text('umkreis_types_ik')?></option>
				<option value="off_ig"<?php echo (($art=='off_ig')?' selected':'')?>><?php echo text('umkreis_types_ig')?></option>
				<option value="off_kg"<?php echo (($art=='off_kg')?' selected':'')?>><?php echo text('umkreis_types_kg')?></option>
				<option value="off_ikg"<?php echo (($art=='off_ikg')?' selected':'')?>><?php echo text('umkreis_types_all')?></option>
				</optgroup>
				<optgroup label="<?php echo text('umkreis_art_adl')?>">
				<option value="adl_a"<?php echo (($art=='adl_a')?' selected':'')?>><?php echo text('umkreis_types_a')?></option>
				<option value="adl_ai"<?php echo (($art=='adl_ai')?' selected':'')?>><?php echo text('umkreis_types_ai')?></option>
				<option value="adl_ak"<?php echo (($art=='adl_ak')?' selected':'')?>><?php echo text('umkreis_types_ak')?></option>
				<option value="adl_aik"<?php echo (($art=='adl_aik')?' selected':'')?>><?php echo text('umkreis_types_aik')?></option>
				<option value="adl_aikg"<?php echo (($art=='adl_aikg')?' selected':'')?>><?php echo text('umkreis_types_aikg')?></option>
				</optgroup>
				<!--
				<optgroup label="<?php echo text('umkreis_art_fak')?>">
				<option value="fak_f"<?php echo (($art=='fak_f')?' selected':'')?>><?php echo text('umkreis_types_ff')?></option>
				<option value="fak_m"<?php echo (($art=='fak_m')?' selected':'')?>><?php echo text('umkreis_types_fm')?></option>
				<option value="fak_s"<?php echo (($art=='fak_s')?' selected':'')?>><?php echo text('umkreis_types_fs')?></option>
				<option value="fak_a"<?php echo (($art=='fak_a')?' selected':'')?>><?php echo text('umkreis_types_all')?></option>
				</optgroup>
				<optgroup label="<?php echo text('umkreis_art_oth')?>">
				<option value="msc_sp"<?php echo (($art=='msc_sp')?' selected':'')?>><?php echo text('umkreis_types_sp')?></option>
				<option value="msc_ss"<?php echo (($art=='msc_ss')?' selected':'')?>><?php echo text('umkreis_types_ss')?></option>
				<option value="msc_ls"<?php echo (($art=='msc_ls')?' selected':'')?>><?php echo text('umkreis_types_sl')?></option>
				</optgroup>
				-->
				</select>
			</td>
			<td>&nbsp;
				<!-- [ <a href="javascript:alert('coming soon...');" title="Erweiterte Truppenauswahl">Erweiterte Truppenauswahl</a> ] //-->
			</td>
		</tr>

		<!-- Unit Selection -->
		<tbody style="display:visible;">
		<tr>
			<td rowspan="9" class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_troops')?>:</label></td>
			<td colspan="2"><?php echo text('t_sp')?>:</td>
			<td>
				<input type="radio" name="use_sp" value="1" id="use_sp" class="radio"<?php echo (($use_sp=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_sp" value="0" id="use_sp" class="radio"<?php echo (($use_sp=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_sp" value="2" id="use_sp" class="radio"<?php echo (($use_sp=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_id')?>:</td>
			<td>
				<input type="radio" name="use_id" value="1" id="use_id" class="radio"<?php echo (($use_id=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_id" value="0" id="use_id" class="radio"<?php echo (($use_id=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_id" value="2" id="use_id" class="radio"<?php echo (($use_id=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_kd')?>:</td>
			<td>
				<input type="radio" name="use_kd" value="1" id="use_kd" class="radio"<?php echo (($use_kd=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_kd" value="0" id="use_kd" class="radio"<?php echo (($use_kd=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_kd" value="2" id="use_kd" class="radio"<?php echo (($use_kd=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_io')?>:</td>
			<td>
				<input type="radio" name="use_io" value="1" id="use_io" class="radio"<?php echo (($use_io=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_io" value="0" id="use_io" class="radio"<?php echo (($use_io=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_io" value="2" id="use_io" class="radio"<?php echo (($use_io=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_ko')?>:</td>
			<td>
				<input type="radio" name="use_ko" value="1" id="use_ko" class="radio"<?php echo (($use_ko=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_ko" value="0" id="use_ko" class="radio"<?php echo (($use_ko=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_ko" value="2" id="use_ko" class="radio"<?php echo (($use_ko=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_rm')?>:</td>
			<td>
				<input type="radio" name="use_rm" value="1" id="use_rm" class="radio"<?php echo (($use_rm=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_rm" value="0" id="use_rm" class="radio"<?php echo (($use_rm=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_rm" value="2" id="use_rm" class="radio"<?php echo (($use_rm=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_kt')?>:</td>
			<td>
				<input type="radio" name="use_kt" value="1" id="use_kt" class="radio"<?php echo (($use_kt=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_kt" value="0" id="use_kt" class="radio"<?php echo (($use_kt=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_kt" value="2" id="use_kt" class="radio"<?php echo (($use_kt=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_ad')?>:</td>
			<td>
				<input type="radio" name="use_ad" value="1" id="use_ad" class="radio"<?php echo (($use_ad=='1')?' checked':'')?> title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_ad" value="0" id="use_ad" class="radio"<?php echo (($use_ad=='0')?' checked':'')?> title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_ad" value="2" id="use_ad" class="radio"<?php echo (($use_ad=='2')?' checked':'')?> title="<?php echo text('umkreis_troops_opt_hint')?>"><label title="<?php echo text('umkreis_troops_opt_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_opt')?></label>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('t_hr')?>:</td>
			<td>
				<input type="radio" name="use_hr" value="1" id="use_hr" class="radio"<?php echo (($use_hr=='1')?' checked':'')?> disabled title="<?php echo text('umkreis_troops_yes_hint')?>"><label title="<?php echo text('umkreis_troops_yes_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_yes')?></label>
				<input type="radio" name="use_hr" value="0" id="use_hr" class="radio"<?php echo (($use_hr=='0' || true)?' checked':'')?> disabled title="<?php echo text('umkreis_troops_no_hint')?>"><label title="<?php echo text('umkreis_troops_no_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_no')?></label>
				<input type="radio" name="use_hr" value="2" id="use_hr" class="radio"<?php echo (($use_hr=='2')?' checked':'')?> disabled title="<?php echo text('umkreis_troops_fit_hint')?>"><label title="<?php echo text('umkreis_troops_fit_hint')?>" class="fieldValue"><?php echo text('umkreis_troops_fit')?></label>
			</td>
		</tr>

		<!-- Army Stength -->
		<tr>
			<td rowspan="2" class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_strength')?>:</label></td>
			<td colspan="2">
				<select class="ibox" name="qnt_mode" disabled>
				<option value=""></option>
				<option value="cnt"<?php echo (($qnt_mode=='cnt' || true)?' selected':'')?>><?php echo text('umkreis_strength_cnt')?></option>
				<option value="res"<?php echo (($qnt_mode=='res')?' selected':'')?>><?php echo text('umkreis_strength_res')?></option>
				<option value="cry"<?php echo (($qnt_mode=='cry')?' selected':'')?>><?php echo text('umkreis_strength_cry')?></option>
				</select>
				<br />
			</td>
			<td>
				<input type="radio" name="qnt_size" value="1" id="qnt_size" class="radio"<?php echo (($qnt_size=='1')?' checked':'')?> disabled><?php echo text('umkreis_strength_single')?>
				<input type="radio" name="qnt_size" value="2" id="qnt_size" class="radio"<?php echo (($qnt_size=='2')?' checked':'')?> disabled><input type="text" maxlength="5" size="4" class="ibox" name="qnt_min" value="<?php echo $qnt_min?>" disabled> <b>-</b> <input type="text" maxlength="5" size="4" class="ibox" name="qnt_max" value="<?php echo $qnt_max?>" disabled>
				<input type="radio" name="qnt_size" value="3" id="qnt_size" class="radio"<?php echo (($qnt_size=='3')?' checked':'')?> disabled><?php echo text('umkreis_strength_all')?>
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('umkreis_pool_limit')?>:</td>
			<td>
				<input type="radio" name="qnt_lmt" value="0" id="qnt_lmt" title="Einstellungen der Spieler ber&uuml;cksichtigen" class="radio"<?php echo (($qnt_lmt=='0')?' checked':'')?> disabled><?php echo text('umkreis_pool_limit_player')?>
				<input type="radio" name="qnt_lmt" value="1" id="qnt_lmt" class="radio"<?php echo (($qnt_lmt=='1')?' checked':'')?> disabled><?php echo text('umkreis_pool_limit_set')?>: <input type="text" maxlength="3" size="2" class="ibox" name="qnt_rat" value="<?php echo $qnt_rat?>" disabled> %
			</td>
		</tr>
		</tbody>

		<!-- Source Selection -->
		<tr>
			<td class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_source')?>:</label></td>
			<td colspan="2">
				<select class="ibox" name="src"<?php echo (($rechte[2]==1)?' disabled	':'')?>>
				<option value=""></option>
				<option value="all"<?php echo (($src=='all')?' selected':'')?>><?php echo text('umkreis_source_all')?></option>
				<option value=""></option>
				<optgroup label="<?php echo text('umkreis_source_own')?>">
				<option value="own_tr"<?php echo (($src=='own_tr')?' selected':'')?>><?php echo text('umkreis_source_own_tr')?></option>
				<!--
				<option value="own_gr"<?php echo (($src=='own_gr')?' selected':'')?>><?php echo text('umkreis_source_own_gr')?></option>
				<option value="own_al"<?php echo (($src=='own_al')?' selected':'')?>><?php echo text('umkreis_source_own_al')?></option>
				-->
				<option value=""></option>
				<optgroup label="<?php echo text('list_members')?>">
<?php
// Players
if ( !is_array( $player_list ) || !count( $player_list ) ) {
	echo '<option value="">'.text('list_empty').'</option>';
} else {
	foreach( $player_list as $key => $val ) {
		echo '<option value="sid_'.$key.'"'.(($src=='sid_'.$key)?' selected':'').'>'.$val.'</option>';
	}
}
?>
				<!--
				<option value=""></option>
				<optgroup label="<?php echo text('list_groups')?>">
				<option value=""><?php echo text('list_na')?></option>
				</optgroup>
				<option value=""></option>
				<optgroup label="<?php echo text('list_groups')?>">
				<option value=""><?php echo text('list_na')?></option>
				</optgroup>
				-->
				</select>
				<br />
			</td>
			<td>
				<input type="radio" name="route" value="0" id="route" class="radio"<?php echo (($route=='0')?' checked':'')?> title="<?php echo text('umkreis_source_direct_hint')?>"><?php echo text('umkreis_source_direct')?>
				<input type="radio" name="route" value="1" id="route" class="radio"<?php echo (($route=='1')?' checked':'')?> title="<?php echo text('umkreis_source_locations_hint')?>"><?php echo text('umkreis_source_locations')?>
			</td>
		</tr>

		<!-- Range Limits -->
		<tr>
	  		<td rowspan="2" class="zeile2"><label class="fieldLabel"><?php echo text('umkreis_distance')?>:</label></td>
        	<td colspan="2"><?php echo text('umkreis_distance_dur')?>:</td>
        	<td>
				<input type="radio" name="lmt_t" value="0" id="lmt_t" class="radio" title=""<?php echo (($lmt_t=='0')?' checked':'')?>><?php echo text('umkreis_distance_no')?>
				<input type="radio" name="lmt_t" value="1" id="lmt_t" class="radio" title=""<?php echo (($lmt_t=='1')?' checked':'')?>><?php echo text('umkreis_distance_yes')?>:
				<input type="text" maxlength="2" size="3" class="ibox" name="lmt_t_h" value="<?php echo $lmt_t_h?>">
				<b>:</b>
				<input type="text" maxlength="2" size="3" class="ibox" name="lmt_t_m" value="<?php echo $lmt_t_m?>">
				<b>:</b>
				<input type="text" maxlength="2" size="3" class="ibox" name="lmt_t_s" value="<?php echo $lmt_t_s?>">
			</td>
		</tr>
		<tr>
			<td colspan="2"><?php echo text('umkreis_distance_dis')?>:</td>
			<td>
				<input type="radio" name="lmt_d" value="0" id="lmt_d" class="radio" title=""<?php echo (($lmt_d=='0')?' checked':'')?>><?php echo text('umkreis_distance_no')?>
				<input type="radio" name="lmt_d" value="1" id="lmt_d" class="radio" title=""<?php echo (($lmt_d=='1')?' checked':'')?>><?php echo text('umkreis_distance_yes')?>:
				<input type="text" maxlength="3" size="3" class="ibox" name="lmt_d_f" value="<?php echo $lmt_d_f?>"> <?php echo text('umkreis_distance_fields')?>
			</td>
		</tr>

		<!-- Temporary Note -->
		<tr>
			<td colspan="4" class="footer small"><?php echo text('umkreis_dev_note')?></td>
		</tr>

		<!-- Submit -->
		<tr>
			<td colspan="4" class="footer"><input type="submit" class="submit" value="<?php echo text('umkreis_submit')?>"></td>
		</tr>

		<!-- Done -->
	</table>
    <br>

<?php
// Call next script on submit
if (isset($_POST['calc'])) include "umkreis2.php";
?>

</form>
</div>

</body>
</html>