<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/07/21 waRhawK complete rewrite
 * @since 2007/11/03 waRhawK skip overall arrival time processing if just walktime durations are configured
 * @since 2007/11/03 waRhawK allowed for localized date format using new language specs
 */
if (!defined('CALLER') || CALLER!='umkreis.php') { die('forbidden'); }
require_once "config.php";
security();



	/**************************************************************
	 *                                                            *
	 *   Initialization                                           *
	 *                                                            *
	 **************************************************************/

	/**
	 * Time (Now)
	 * @var array
	 * @access public
	 */
	$now = array(
  		'h' => date('H'),
  		'm' => date('i'),
  		's' => date('s'),
  		'Y' => date('Y'),
  		'M' => date('m'),
  		'D' => date('d'),
	);

	/**
	 * Timestamps
	 * @var array
	 * @access public
	 */
	$times = array(
	  	'now' => mktime( $now['h'], $now['m'], $now['s'], $now['M'], $now['D'], $now['Y'] ),
  		'arrival' => mktime( $time_h, $time_m, $time_s, $date_m, $date_d, $date_y ),
	);

	/**
	 * Timelimit in seconds
	 * @var array
	 * @access public
	 */
	if ($lmt_t <> 1) {
		$times['limit'] = null;
	} else {
		$times['limit'] = 0;
		$times['limit']+= (is_numeric($lmt_t_h)) ? ($lmt_t_h*60*60) : 0;
		$times['limit']+= (is_numeric($lmt_t_m)) ? ($lmt_t_m*60) : 0;
		$times['limit']+= (is_numeric($lmt_t_s)) ? ($lmt_t_s) : 0;
	}

	/**
	 * Troop Types
	 * @var array
	 * @access public
	 */
	$types = array('sp', 'id', 'io', 'kd', 'ko', 'rm', 'kt', 'ad');

	/**
	 * Unit Speeds
	 * Note: Dealers and Settlers are not part of planning right now
	 * Note: null pseudo value was added to avoid defining all the keys (troops start with 1 to 9=nobilities)
	 * @var array
	 * @access public
	 * @todo Apply from world setup... eg. to support speed (not yet implemented)
	 */
	$speeds = array(
		'rom' => array( null, 6, 5, 7, 16, 14, 10, 4, 3, 4 ),
  		'ger' => array( null, 7, 7, 6, 9, 10, 9, 4, 3, 4 ),
  		'gal' => array( null, 7, 6, 17, 19, 16, 13, 4, 3, 5 ),
	);

	/**
	 * Unit to Troop Type Mapping per Race
	 * Note: Dealers and Settlers are not part of planning right now
	 * @var array
	 * @access public
	 * @todo Update on each army by configured player privilueges (not yet implemented)
	 */
	$racetypes = array(
  		'rom' => array(					// --- Romans ---
  			'sp' => array('t4'),		// Scounts (German: [Sp]�her)
  			'id' => array('t1','t2'),	// Defense Infantry
  			'io' => array('t3'),		// Offense Infantry
  			'kd' => array('t5'),		// Defense Cavalry (German: [K]avallerie)
  			'ko' => array('t6'),		// Offense Cavalry
  			'rm' => array('t7'),		// Rams
  			'kt' => array('t8'),		// Catapults (German: [K]a[t]apulte)
  			'ad' => array('t9'),		// Nobilities (German: [Ad]el)
  		),
  		'ger' => array(					// --- Teutons (German: [Ger]manen) ---
	  		'sp' => array('t4'),
  			'id' => array('t2'),
  			'io' => array('t1', 't3'),
  			'kd' => array('t5'),
  			'ko' => array('t6'),
  			'rm' => array('t7'),
  			'kt' => array('t8'),
  			'ad' => array('t9'),
  		),
  		'gal' => array(					// --- Gauls (German: [Gal]lier) ---
	  		'sp' => array('t3'),
  			'id' => array('t1'),
  			'io' => array('t2'),
  			'kd' => array('t5'),
  			'ko' => array('t4','t6'),
  			'rm' => array('t7'),
  			'kt' => array('t8'),
  			'ad' => array('t9'),
  		),
	);



	/**************************************************************
	 *                                                            *
	 *   Functions                                                *
	 *                                                            *
	 **************************************************************/

	/**
	 * Calculate distance for units for location=>source=>target
	 *
	 * @param int $x1 the location X coordinate
	 * @param int $y1 the location Y coordinate
	 * @param int $x2 the source X coordinate
	 * @param int $y2 the source Y coordinate
	 * @return float the calculated distance in fields
	 * @access public
	 * @author waRhawK <whk@gmx.de>
	 */
	function get_distance($x1, $y1, $x2, $y2) {

		$S1 = abs($x1 - $x2);
		if ($S1 > (KARTE + 1)) $S1 = $S1 - (2*KARTE + 1);
		$S2 = abs($y1 - $y2);
		if ($S2 > (KARTE + 1)) $S2 = $S2 - (2*KARTE + 1);
		$SQ = $S1 * $S1 + $S2 * $S2;

		return sqrt($SQ);
	}

	/**
	 * Calculate walk time for units based on field distance
	 *
	 * @param string $race the race
	 * @param int $type the unit
	 * @param float $distance the field distance
	 * @param int $tplevel the tournament place building level (travian 3 only, applied after 30 fields of distance)
	 * @return int the walk time in seconds
	 * @access public
	 * @author waRhawK <whk@gmx.de>
	 */
	function get_walktime($race, $type, $distance, $tplevel) {
		global $speeds;
		$type = (int)$type;

		// Split Distance into non-tp and tp-accelerated waypoints
		$distance_tp = 0;
		if ($distance > 30 && $tplevel > 0) {
			$distance_tp = $distance - 30;
			$distance = 30;
		}

		// Get Times (Hours)
		$hours = 0;
		if ($distance > 0) { $hours+= $distance / $speeds[$race][$type]; }
		if ($distance_tp > 0) { $hours+= $distance_tp / ( $speeds[$race][$type] * ( 1.0 + ( $tplevel * 0.1 ) ) ); }

		// Return Seconds
		return round($hours * 60 * 60);
	}

	/**
	 * Format a duration of seconds for human readable display
	 *
	 * @param int $s the seconds
	 * @return string the readable time
	 * @access public
	 * @author waRhawK <whk@gmx.de>
	 */
	function format_time($s) {

		$h = floor($s/3600);
		$s-= ($h*3600);
		$m = floor($s/60);
		$s-= ($m*60);

		return zerofill($h).':'.zerofill($m).':'.zerofill($s);
	}

	/**
	 * Get units from race associated to the desired troop type
	 *
	 * @param string $volk the race
	 * @param string $type the troop type
	 * @return mixed the array of unit types or boolean false on error (should not happen)
	 * @access public
	 * @author waRhawK <whk@gmx.de>
	 */
	function get_race_types($volk,$type) {
		global $racetypes;
		return (isset($racetypes[$volk]) && isset($racetypes[$volk][$type])) ? $racetypes[$volk][$type] : false;
	}

	/**
	 * Format a units for display
	 *
	 * @param string $race the race
	 * @param int $type the unit index (1-9)
	 * @param int $count the amount of units
	 * @return string html code
	 * @access public
	 * @author waRhawK <whk@gmx.de>
	 */
	function show_troops($race,$type,$count) {

		$content="<a onmouseover=\"return overlib('"
		        ."<table class=\'itable\' cellpadding=\'2\' cellspacing=\'1\'><tr>"
		        ."<td colspan=\'2\' class=\'header1b\'>{$count} ".text('t_'.$race.$type.(($count>1)?'_x':''))."</td>"
		        ."</tr><tr>"
		        ."<td>"
		        ."</tr></table>"
		        ."');\" onmouseout=\"return nd();\">"
		        ."<img src='".img_pfad($race,$type)."' alt='' title='' border='0' align='top'> {$count}&nbsp;&nbsp;&nbsp;"
		        ."</a>";

		return $content;
	}





	/**************************************************************
	 *                                                            *
	 *   Get Troops from Database                                 *
	 *                                                            *
	 **************************************************************/
	$allowed_sids = get_allowed_sids($sid, "s.");
	// xy1=Source, xy2=Location
	$sql="SELECT ".
         "t.t1, t.t2, t.t3, t.t4, t.t5, t.t6, t.t7, t.t8, t.t9, ".
         "t.x1, t.x2, ".
         "t.y1, t.y2, ".
         "s.name, ".
         "s.sid, ".
         "s.volk ".
         "FROM ".
         PREFIX."truppen t, ".
         PREFIX."spieler s ".
         "WHERE ".
         "s.sid = t.sid AND
		 (".$allowed_sids.")
		 ";  // risi added: AND  (".$allowed_sids.")

	// Source Limitation
	if (($rechte[2]==1)||($src=='own_tr')) {
		$sql.= " AND s.sid = ".$_SESSION[INSTANCE_KEY]['sid'];	// Only own troops allowed or selected
	} elseif (strpos($src,'sid_')!==false) {
  		list(,$temp) = explode('_',$src);			// Only troops from specified player
		$sql.= " AND s.sid = ".$temp;
		unset($temp);
	}

	// Skip troops, that are already on target location
	// Drops too much, don't know why. So dropping is done on processing...
	#$sql.= " AND t.x2 <> ".$x." AND t.y2 <> ".$y;

	// Read the troops
	$res = mysql_query($sql) OR die(mysql_error());
	$army=array();
	while ($row = mysql_fetch_assoc($res)) {
		$army[]=$row;
	}





	/**************************************************************
	 *                                                            *
	 *   Troop Processsing                                        *
	 *                                                            *
	 **************************************************************/

	// Calculation is done per Squad
	foreach( $army as $armykey => $squad ) {

		// Drop squads that are already on target (Did not work by upper sql... don't understand why...)
		if ($squad['x2'] == $x && $squad['y2'] == $y) {
			unset($army[$armykey]); continue;
		}

		// Drop squads from foreign locations, if direct source was forced
		if ($route==0 && ($squad['x1'] != $squad['x2'] || $squad['y1'] != $squad['y2'])) {
			unset($army[$armykey]); continue;
		}

		// Calculate Distance
		$army[$armykey]['distance_from']	= get_distance($squad['x2'], $squad['y2'], $squad['x1'], $squad['y1']);
		$army[$armykey]['distance_to']		= get_distance($squad['x1'], $squad['y1'], $x, $y);
		$army[$armykey]['distance']		= $army[$armykey]['distance_from'] + $army[$armykey]['distance_to'];

		// Drop squads that are too far away for configured distance limit
		if ($lmt_d==1 && $lmt_d_f > 0 && $army[$armykey]['distance'] > $lmt_d_f) {
			unset($army[$armykey]); continue;
		}

		// Process the different troop types per squad (offensive, defensive, scouts, etc.)
		foreach( $types as $type ) {

			// Get units that match the troop type for each the races
			$useflag = 'use_'.$type;

			if (!is_array($squadracetypes = get_race_types($squad['volk'],$type))) {

				// This never happens during testing, but just to be sure...
				user_error('could not determine units for troop type "'.$type.'" on race "'.$squad['volk'].'"', E_USER_ERROR);
			}

			// Check if units for desired type and race are available (check player privilueges in future releases...)
			if ( !count( $squadracetypes ) ) {

				if ( $$useflag == '1' ) {
					unset($army[$armykey]); continue 2; // Unit type forced and not available
				} else {
	  				continue; // ...flush to skip viewing
				}
			}

			// Check availability of units for desired type (skip when optionally)
			if ( $$useflag != '2' ) {

				// Get each unit for troop type
				$matchtype = false;
				foreach( $squadracetypes as $racetype ) {

	  				if ( $$useflag == '1' && (int)$squad[ $racetype ] > 0 ) {
		  				$matchtype = true; // Unit type forced and found
	  				} elseif ( $$useflag == '0' ) {
		  				$matchtype = true; // Not wanted, so allow go and...
		  				$army[$armykey][$racetype] = 0; // ...flush to skip viewing
	  				}
				}

				// Drop useless squad due to missing units for desired type
				if (!$matchtype) {
					unset($army[$armykey]); continue 2;
				}
			}
		}

		// Get Tournament Square Level (source village only)
		$army[$armykey]['tp'] = isset( $village_list_full[ $squad['x1'].'|'.$squad['y1'] ] ) ? (int)$village_list_full[ $squad['x1'].'|'.$squad['y1'] ][ 'turnier' ] : 0;

		// Calculate walk time and check for empty squads
		$army[$armykey]['duration'] = 0;
  		$droparmy=true;
  		for( $i=1; $i<=9; $i++) {
			if ($army[$armykey]['t'.$i] > 0) {
				$droparmy=false;
				$army[$armykey]['t'.$i.'_duration'] = 0;

				// Walk Time for Location => Source
				if ($army[$armykey]['distance_from'] > 0) {
					$army[$armykey]['t'.$i.'_duration'] += get_walktime($squad['volk'], $i, $army[$armykey]['distance_from'], $army[$armykey]['tp']);

					// Todo: Add some time for the players to react, as they need some time for commanding troops between location an source
				}

				// Walk Time for Source => Target
				if ($army[$armykey]['distance_to'] > 0) {
					$army[$armykey]['t'.$i.'_duration'] += get_walktime($squad['volk'], $i, $army[$armykey]['distance_to'], $army[$armykey]['tp']);
				}

				// Get walk time for slowest unit on squad
				if ($army[$armykey]['t'.$i.'_duration'] > $army[$armykey]['duration']) {
					$army[$armykey]['duration'] = $army[$armykey]['t'.$i.'_duration'];
				}
			}
  		}

  		// Drop squads that are too far away to reach target on time, if time aiming is active
  		if ($timing && ( $times['now']+$army[$armykey]['duration'] > $times['arrival'] ) ) {
			unset($army[$armykey]); continue;
  		}

  		// Drop squads that are too far away to underneath configured walk time limit
  		if ($times['limit']>0 && $army[$armykey]['duration']>$times['limit']) {
			unset($army[$armykey]); continue;
  		}

  		// Calculate Start Time
  		$army[$armykey]['start'] = ( $timing ) ? $times['arrival']-$army[$armykey]['duration'] : -1;

		// Drop empty squads (this may happen, if all units have been selected as optional)
		if ($droparmy) {
			unset($army[$armykey]); continue;
		}
	}

	// Sort squads ascending by walk time
	// Todo: Support resort and maybe secondary grouping (players, wings, etc.)
	$durations = array();
	foreach( $army as $armykey => $squad ) {
  		$durations[$armykey] = $squad['duration'];
	}
	array_multisort($durations, SORT_ASC, $army);





	/**************************************************************
	 *                                                            *
	 *   Display available troops                                 *
	 *                                                            *
	 **************************************************************/

#print count($army);
#ausgabe($army); die();

	// Table Head
	echo '
<table width="970" class="itable" cellpadding="2" cellspacing="1">
<tr>
<td colspan="'.(($timing)?5:4).'" class="header1a">'.strftime(str_replace(array('###X###','###Y###'),array($x,$y),text('umkreis2_header'.(($timing)?'':'_notimes'))), $times['arrival']).'</td>
</tr>
	';

	echo $columnheads='
<tr>
<td class="header2"><nobr>#</nobr></td>
<td class="header2"><nobr>'.text('umkreis2_col_player').'</nobr></td>
<td class="header2" width="100%"><nobr>'.text('umkreis2_col_squad').'</nobr></td>
'.(($timing)?'<td class="header2"><nobr>'.text('umkreis2_col_start').'</nobr></td>':'').'
<td class="header2"><nobr>'.text('umkreis2_col_duration').' '.sortarrow(0).'</nobr></td>
</tr>
	';

	// Get each the squads
	$rowodd = false;
	$squadno=0;
	$datefmt = text('date_short');
	foreach( $army as $armykey => $squad ) {
		$rowodd = !$rowodd;
		$squadno++;
		$tdclass = (($rowodd)?'zeile1':'zeile2');

		echo "<tr valign=\"top\">\n";

		// Squad Number
		echo '<td class="'.$tdclass.'"><nobr>'.zerofill($squadno,3).'<br /></nobr></td>';

		// Player Info
		$hint = str_replace('###VIL1###', (isset($village_list_full[ $squad['x1'].'|'.$squad['y1'] ]) ? $village_list_full[ $squad['x1'].'|'.$squad['y1'] ][ 'name' ] : text('list_unknown')),
		        str_replace('###VIL2###', (isset($village_list_full[ $squad['x2'].'|'.$squad['y2'] ]) ? $village_list_full[ $squad['x2'].'|'.$squad['y2'] ][ 'name' ] : text('list_unknown')),
		        text('umkreis2_src_'.(($squad['distance_from']>0)?'location':'direct'))));

		echo '<td class="'.$tdclass.'"><nobr>'.
		     (($rechte[3]=='2')
		       #? '<a href="showtroops.php?spieler='.$squad['name'].'" onmouseover="return overlib(\'<img src=\\\'image.php?sid='.$squad['sid'].'\\\'>\');" onmouseout="return nd();">'.$squad['name'].'</a>'
		       ? '<a href="showtroops.php?spieler='.$squad['name'].'">'.$squad['name'].'</a>'
		       : $squad['name']
		     ).
		     contact_member($squad['name']).
		     '<br /><span class="grey" title="'.$hint.'">'.
		     (($squad['distance_from']>0)?$squad['x2'].'|'.$squad['y2'].' &#187; ':'').
		     $squad['x1'].'|'.$squad['y1'].
		     '</span></nobr></td>';

		// Available Troops
		echo '<td class="'.$tdclass.' small" style="cursor:default">';
		for($i=1; $i<=9; $i++) {
			if ($squad['t'.$i] > 0) {
				echo show_troops($squad['volk'],$i,$squad['t'.$i]);
			}
		}
		echo '</td>';

		// The start time for the complete squad (slowed unit counts)
		if ($timing) {
			echo '<td class="'.$tdclass.'"><nobr>'.date($datefmt, $squad['start']).'<br />'.date('H:i:s', $squad['start']).'</nobr></td>';
		}

		// The walk time for the complete squad (slowed unit counts)
/* coming in next release...
		$hint = "<table class=\'itable\' cellpadding=\'2\' cellspacing=\'1\'>".
		        "<tr><td colspan=\'5\' class=\'header1b\'>".text('umkreis2_col_duration')."</td></tr>".
		        "<tr>".
		        "<td class=\'header2\'>Von</td>".
		        "<td class=\'header2\'>Nach</td>".
		        "<td class=\'header2\'>Felder</td>".
		        "<td class=\'header2\'>TP</td>".
		        "<td class=\'header2\'>Zeit</td>".
		        "</tr>".
		        "<tr>".
		        "<td><nobr>{$squad['x1']}|{$squad['x2']}</nobr></td>".
		        "<td><nobr>{$x}|{$y}</nobr></td>".
		        "<td>".number_format($squad['distance_to'], 2, ',', '')."</td>".
		        "<td></td>".
		        "<td></td>".
		        "</tr>".
		        "</table>";

/*
		$content="<a onmouseover=\"return overlib('"
		        ."<table class=\'itable\' cellpadding=\'2\' cellspacing=\'1\'><tr>"
		        ."<td colspan=\'2\' class=\'header1b\'>{$count} ".text('t_'.$race.$type.(($count>1)?'_x':''))."</td>"
		        ."</tr><tr>"
		        ."<td>"
		        ."</tr></table>"
		        ."');\" onmouseout=\"return nd();\">"
		        ."<img src='".img_pfad($race,$type)."' alt='' title='' border='0' align='top'> {$count}&nbsp;&nbsp;&nbsp;"
		        ."</a>";

		echo '<td class="'.$tdclass.'" onmouseover="return overlib(\''.$hint.'\');" onmouseout="return nd();"><nobr>'.format_time($squad['duration']).'<br />'.number_format($squad['distance'], 2, ',', '').' <img src="img/external.gif" alt="" title="'.text('umkreis2_col_distance').'" border="0" align="bottom" /></nobr></td>';
*/

		echo '<td class="'.$tdclass.'"><nobr>'.format_time($squad['duration']).'<br />'.number_format($squad['distance'], 2, ',', '').' <img src="img/external.gif" alt="" title="'.text('umkreis2_col_distance').'" border="0" align="bottom" /></nobr></td>';

		echo "</tr>\n";
	}

	// Table Footer
  	echo "</table>\n";


/*





  	/**************************************************************
	 *                                                            *
	 *   Display target info                                      *
	 *                                                            *
	 **************************************************************/


	// Get village from database
	// Todo: Support external targets using SQL provided by world servers and personal information added due to scout info gained
	if (isset($x) && isset($y) && is_numeric($x) && is_numeric($y)) {
		$sql="SELECT ".
		     "d.did, d.x, d.y, d.name as villagename, d.type, d.layout, d.size, d.mauer, d.palast, d.residenz, d.kornspeicher, d.getreide, ".
		     "s.name as playername ".
		     "FROM ".
	         PREFIX."dorf as d ".
		     "LEFT JOIN ".PREFIX."spieler as s ON (d.sid = s.sid) ".
	         "WHERE d.x={$x} AND d.y={$y} ";

		$res = mysql_query($sql) OR die(mysql_error());

		// Village found?
		if (mysql_num_rows($res)) {
			$row = mysql_fetch_assoc($res);

	  		// Print Info
			echo "<table width=\"250\" class=\"itable\" cellpadding=\"2\" cellspacing=\"1\" style=\"position:absolute; top:0px; left:720px;\">".
			     "<tr>".
			     "<td colspan=\"2\" class=\"header1a\">".$row['villagename']."</td>".
			     "</tr>".
			     "<tr>".
			     "<td width=\"100\" class=\"header2\">".text('umkreis2_col_player')."</td>".
			     "<td width=\"150\">".$row['playername']." ".contact_member($row['playername'])."</td>".
			     "</tr>".
			     "<tr>".
			     "<td class=\"header2\">".text('dorf_type')."</td>".
			     "<td>".text('dorf_type_'.(int)$row['type'])."</td>".
			     "</tr>".
			     "<tr>".
			     "<td class=\"header2\">".text('dorf_layout')."</td>".
			     "<td>".(((int)$row['type']<3)?text('dorf_layout_'.(int)$row['layout']):zero('-'))."</td>".
			     "</tr>".
			     "<tr>".
			     "<td class=\"header2\">".text('dorf_size')."</td>".
			     "<td>".(((int)$row['type']<3)?zero((int)$row['size']):zero('-'))."</td>".
			     "</tr>".
			     "<tr>".
			     "<td class=\"header2\">".text('dorf_mauer')."</td>".
			     "<td>".(((int)$row['type']<3)?zero($row['mauer']):zero('-'))."</td>".
			     "</tr>".
			     "<tr>".
			     (($row['residenz']>0)
			       ? "<td class=\"header2\">".text('dorf_residenz')."</td>".
				     "<td>".(((int)$row['type']<3)?zero($row['residenz']):zero('-'))."</td>"
				   : "<td class=\"header2\"><i>".text('dorf_palast')."</i></td>".
				     "<td>".(((int)$row['type']<3)?zero($row['palast']):zero('-'))."</td>"
				 ).
			     "</tr>".
			     "<tr>".
			     "<td class=\"header2\">".text('dorf_kornspeicher')."</td>".
			     "<td>".(((int)$row['type']<3)?zero($row['kornspeicher']):zero('-'))."</td>".
			     "</tr>".
			     "<tr>".
			     "<td class=\"header2\">".text('dorf_getreide')."</td>".
			     "<td>".(((int)$row['type']<3)?zero($row['getreide']):zero('-'))."</td>".
			     "</tr>".
			     "</table>";
		}
	}
?>
<br>