<?php
/**
 * Copyright (c) 2006, 2007
 *
 * Florian Schreier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 3. The names of its contributors may never be used to endorse or promote
 * products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author tomilo <tomilo@gmx.net>
 * @author waRhawK <whk@gmx.de>
 * @package trooptool
 * @subpackage rtwwmod
 * @since 2007/11/15 waRhawK hero is now shown up on both coordinaates match only to avoid duplicate displays; still needs a rewrite because without other troops in desired village, he will be invisible
 * @since 2007/12/18 waRhawK rewrite troop queries using joins to fix bug that troops were not shown if corresponding villages missing 
 * @since 2007/12/18 waRhawK indicate missing villages by display 'unknown' as name relacement
 * @since 2007/12/18 waRhawK quick performance improvement: delcared config query result static to avoid querying the same for each village name
 */
  require_once "config.php";

  if (empty($_SESSION[INSTANCE_KEY]['sid'])) {
  	include "index.php";
  	die();
  }

  security();

  //eventuelle Befehle ausf�hren (Truppen l�schen/eintragen)
  if (isset($_GET['del'])) {
  	include "delete.php";
  }
  if (isset($_POST['x1'])) {
  	include "send.php";
  }

// Create Head JS
$script = '
<script type="text/javascript">
<!--

    function showforms(formname, formtext, refresh_site) {
    	if (document.getElementById(formname).style.display == "none") {
    		document.getElementById(formname).style.display = "";
    		document.getElementById(formtext).disabled = 1;
    	}
    	else {
			document.getElementById(formname).style.display = "none";
    		document.getElementById(formtext).disabled = 0;
    		if (refresh_site) {
    			window.location="user.php";
    		}
    	}
    }

    function switchtroops() {
    	if (document.getElementById("unitManual").style.display == "none") {
    		document.getElementById("unitManual").style.display = "";
    		document.getElementById("unitAuto").style.display = "none";
    	} else {
    		document.getElementById("unitManual").style.display = "none";
    		document.getElementById("unitAuto").style.display = "";
    	}
    }

    function askdel(tid, site) {
        Check = confirm("'.text('user_askdel').'");
        if (Check == true) window.location.href = site + \'?del=\' + tid;
    }
	
	function update_coord(value) {
		var coords = value.split(",");
		document.getElementById("x1").value = coords[0];
		document.getElementById("y1").value = coords[1];
	}
	
	function update_coord2(value) {
		var coords = value.split(",");
		document.getElementById("x2").value = coords[0];
		document.getElementById("y2").value = coords[1];
	}

//-->
</script>
';

// Write Header
write_header(text('user_header'), $script);
?>

<div class="oben"><?php include "oben.php"; ?></div>
<div class="menu"><?php include "menu.php"; ?></div>
<div class="mitte2" align="center">

<table class="itable" cellpadding="2" cellspacing="1">
	<tr>
		<td class="header1" colspan="15"><?php echo text('user_header')?></td>
	</tr>
<?php
  //--Tabellenheader
  //Zeilenanfang
  echo "<tr>";
  //Herkunft
  echo "<td class=\"header2\" width=\"180\">".text('user_her')."</td>";
  //Standort
  echo "<td class=\"header2\" width=\"180\">".text('user_sta')."</td>";
  //Volk (10 Truppenspalten)
  for ($i=1; $i<=10; $i++) {
  	echo "<td class=\"header2\" width=\"20\"><img src=\"".img_pfad($volk, $i)."\" title=\"".text('t_'.$volk.$i)."\" alt=\"".text('t_'.$volk.$i)."\"></td>";
  }
  //Helden
  echo "<td class=\"header2\" width=\"20\"><a href=\"hero.php\"><img src=\"img/hero.gif\" title=\"".text('troops_hero')."\" alt=\"".text('troops_hero')."\"></a></td>";
  //zwei Leerspalten
  echo "<td class=\"header2\" colspan=\"2\"></td>";
  //Zeilenende
  echo "</tr>";

  // @since 2007/09/01 waRhawK added reading of hero
  $sql = "SELECT * ".
         "FROM `".PREFIX."hero` ".
         "WHERE `sid`=".(int)$sid." AND `active`=1 ".
         "LIMIT 0,1";
  $res = mysql_query($sql) OR die(mysql_error());
  $hero = mysql_fetch_assoc($res);

  //--Abfrage der Trupen aus der Datenbank
  // @since 2007/09/01 waRhawK added ordering by village name ascending
  // @since 2007/12/18 waRhawK rewrite sql using joins to fix bug that troops were not shown if corresponding villages mising
  $sql = "SELECT ".
         "t.tid, t.x1, t.y1, ".
         "d1.name AS vil_origin, ".
         "t.x2, t.y2, ".
         "d2.name AS vil_position, ".
		 "sp.name AS spieler, " .
         "t.t1, t.t2, t.t3, t.t4, t.t5, t.t6, t.t7, t.t8, t.t9, t.t10 ".
         "FROM ".PREFIX."truppen t ".
         "LEFT JOIN ".PREFIX."dorf d1 ON (d1.x=t.x1 AND d1.y=t.y1 AND t.sid = d1.sid) ".
         "LEFT JOIN ".PREFIX."dorf d2 ON (d2.x=t.x2 AND d2.y=t.y2 AND t.sid = d1.sid) ".
         "LEFT JOIN ".PREFIX."spieler sp ON (t.sid = sp.sid) ".
         "WHERE t.sid=".(int)$sid." ".
         "ORDER BY d1.name ASC, d2.name ASC"; //*/
	/*$sql = "SELECT ".
         "t.tid, t.x1, t.y1, ".
         "d1.village AS vil_origin, ".
         "t.x2, t.y2, ".
         "d2.village AS vil_position, ".
         "t.t1, t.t2, t.t3, t.t4, t.t5, t.t6, t.t7, t.t8, t.t9, t.t10 ".
         "FROM ".PREFIX."truppen t ".
         "LEFT JOIN x_world d1 ON (d1.x=t.x1 AND d1.y=t.y1) ".
         "LEFT JOIN x_world d2 ON (d2.x=t.x2 AND d2.y=t.y2) ".
         "WHERE t.sid=".(int)$sid." ".
         "ORDER BY d1.village ASC, d2.village ASC";  //*/
		 //die($sql);
  $result = mysql_query($sql) OR die(mysql_error());

  //--Anzeige der Truppen
  $rowodd = false;
  while ($row = mysql_fetch_assoc($result)) {
	
	if($row['vil_position'] == "") { 
		$sql = "SELECT village, player FROM x_world WHERE x=".(int)$row['x2']." AND y=".(int)$row['y2']." LIMIT 1";
		$alt_village = mysql_query($sql) OR die(mysql_error());
		if(mysql_num_rows($alt_village) > 0) {
			$alt_village = mysql_fetch_assoc($alt_village);
			$row['vil_position'] = $alt_village['village'];
			$row['spieler'] = $alt_village['player'];
		}
	}
	
  	$rowodd = !$rowodd;
	$tdclass = ' class="'.(($rowodd)?'zeile1':'zeile2').'"';
  	//Zeilenbeginn
  	echo "<tr>";
  	//Herkunft
  	echo format_village($row['vil_origin'], $row['x1'], $row['y1'], $tdclass);
  	//Standort
  	echo format_village($row['vil_position'], $row['x2'], $row['y2'], $tdclass, $row['spieler']);
  	//Truppen
  	for ($i=1; $i<=10; $i++) {
	    echo "<td{$tdclass}>".zero($row['t'.$i])."</td>";
    }
    //Hero
  	if (is_array($hero) && count($hero) && ($hero['x']==$row['x1']) && ($hero['x']==$row['x2']) && ($hero['y']==$row['y1']) && ($hero['y']==$row['y2'])) {
  		echo "<td title=\"{$hero['name']} ({$hero['typ']})\"{$tdclass}><a href=\"hero.php?edit={$hero['id']}&return=user\">1</a></td>";
  	} else {
  		echo "<td{$tdclass}>".zero(0)."</td>";
  	}
    //bearbeiten
    echo "<td{$tdclass}><a href=\"?edit=".$row['tid']."\"><img src=\"img/edit.gif\" title=\"".text('edit')."\"></a></td>";
    //l�schen
    echo "<td{$tdclass}><a href=\"javascript: askdel(".$row['tid'].", 'user.php');\"><img src=\"img/del.gif\" title=\"".text('del')."\"></a></td>";
    //Zeilenende
    echo "</tr>";
  }

  //--Anzeige der Summe
  echo "<tr><td colspan=\"2\" class=\"header2\"><b>".text('admin_sum')."</b></td>";
  //Summenberechnung
  $sql="SELECT
          sum(t1), sum(t2), sum(t3), sum(t4), sum(t5), sum(t6), sum(t7), sum(t8), sum(t9), sum(t10)
        FROM
          ".PREFIX."truppen
		WHERE
		  sid='".$sid."'";
  $result = mysql_query($sql) OR die(mysql_error());
  $row = mysql_fetch_assoc($result);
  $row['sum(t11)'] = (is_array($hero) && count($hero)) ? 1 : 0;
  for ($i=1; $i<=11; $i++) {
  	echo "<td class=\"header2\">".zero($row['sum(t'.$i.')'])."</td>";
  }
  //leere Zellen am Ende der Zeile
  echo "<td colspan=\"2\" class=\"header2\"></td>";

  //Button
  $buttonDisable = (isset($_GET['edit']) && is_numeric($_GET['edit'])) ? ' disabled':'';
  echo '
  	</tr>
	<tr>
		<td colspan="15" class="footer"><input id="formtext" type="button" class="submit" value="'.text('user_showforms').'" onclick="showforms(\'forms\', \'formtext\', 1)"'.$buttonDisable.'></td>
	</tr>
  ';

  //--Ende der Tabelle
  echo "</table>";

?>
<br>
<?php

	// Forms
  if (isset($_GET['edit']) AND is_numeric($_GET['edit'])) {
  	$display = "";
  	$display2 = " style='display: none'";
    // @since 2007/12/18 waRhawK rewrite sql using joins to fix bug that troops were not shown if corresponding villages mising
    $sql = "SELECT ".
           "t.sid, t.x1, t.y1, ".
           "d1.name AS vil_origin, ".
           "t.x2, t.y2, ".
           "d2.name AS vil_position, ".
           "t.t1, t.t2, t.t3, t.t4, t.t5, t.t6, t.t7, t.t8, t.t9, t.t10 ".
           "FROM ".PREFIX."truppen t ".
           "LEFT JOIN ".PREFIX."dorf d1 ON (d1.x=t.x1 AND d1.y=t.y1 AND t.sid = d1.sid) ".
           "LEFT JOIN ".PREFIX."dorf d2 ON (d2.x=t.x2 AND d2.y=t.y2 AND t.sid = d1.sid) ".
           "WHERE t.tid=".(int)$_GET['edit'];
    $result=mysql_query($sql) OR die(mysql_error());
  	$row = mysql_fetch_assoc($result);
  	if ($sid == $row['sid']) {
 	  for ($i=1; $i<=10; $i++) {
 	 	$t[$i] = $row['t'.$i];
 	  }
 	  $x1 = $row['x1'];
 	  $y1 = $row['y1'];
 	  $x2 = $row['x2'];
 	  $y2 = $row['y2'];
 	  // @since 2007/12/18 waRhawK indicate the unknowns
 	  $herkunft = strlen($row['vil_origin'])?$row['vil_origin']:'<span class="grey">'.text('list_unknown').'</span>';
 	  $standort = strlen($row['vil_position'])?$row['vil_position']:'<span class="grey">'.text('list_unknown').'</span>';
 	  $edit = " readonly";
  	} else {
 	  die("ACCESS DENIED");
 	}
  } else {
  	$display = " style='display: none'";
  	$display2 = "";
  	$_GET['edit'] = 0;
  	for ($i=1; $i<=10; $i++) {
 	  $t[$i] = 0;
 	}
 	$x1       = 0;		$x2       = 0;
 	$y1       = 0;		$y2       = 0;
 	//
	$sql = "SELECT name, x, y FROM ".PREFIX."dorf WHERE (sid=".(int)$sid." AND (type!=3 OR type IS NULL))";
	$result = mysql_query($sql) OR die(mysql_error());
	if(mysql_num_rows($result) > 0) {
		$herkunft = "<select onchange=\"update_coord(this.value)\">";
		$standort = "<select onchange=\"update_coord2(this.value)\">";	
		$do_once = 0;
		while($this_village = mysql_fetch_assoc($result)) {
			$herkunft .= "<option value='".$this_village['x'].",".$this_village['y']."'>".$this_village['name']."</option>";			
			$standort .= "<option value='".$this_village['x'].",".$this_village['y']."'>".$this_village['name']."</option>";	
			if($do_once < 1) {
				$x1 = $this_village['x'];
				$x2 = $this_village['x'];
				$y1 = $this_village['y'];
				$y2 = $this_village['y'];
				$do_once++;
			}
		}
		$herkunft .= "</select>";
		$standort .= "</select>";
	} else {
		$herkunft = $standort = '<span class="grey">'.text('list_unknown').'</span>';
	}
 	$edit = "";
  }
?>

<div id="forms" class="formular"<?php echo $display?>>

<form action="user.php" method="post" accept-charset="utf-8">
  <input type="hidden" name="edit" value="<?php echo (int) $_GET['edit']?>">
    <table class="itable" cellpadding="2" cellspacing="1" width="350">
        <tr class="header1">
            <td colspan="4" class="header1"><?php echo text('user_form_header')?><a href="javascript:showforms('forms', 'formtext', 1)"><img src="img/close.gif" style="position:absolute; right:4px; top:4px; height:18px; width:18p;"></a></td>
        </tr>
        <tr>
            <td class="zeile2"><label class="fieldLabel"><?php echo text('user_her')?>:</label></td>
            <td colspan="2" align="left"><i><?php echo $herkunft?></i></td>
            <td align="right"><nobr>
            	X: <input class="ibox f30" type="text" name="x1" id="x1" value="<?php echo $x1?>" maxlength="4">
                Y: <input class="ibox f30" type="text" name="y1" id="y1" value="<?php echo $y1?>" maxlength="4">
            </nobr></td>
        </tr>
        <tr>
            <td class="zeile2"><label class="fieldLabel"><?php echo text('user_sta')?>:</label></td>
            <td colspan="2" align="left"><i><?php echo $standort?></i></td>
            <td align="right"><nobr>
            	X: <input class="ibox f30" type="text" name="x2" id="x2" value="<?php echo $x2?>" maxlength="4">
                Y: <input class="ibox f30" type="text" name="y2" id="y2" value="<?php echo $y2?>" maxlength="4"></td>
            </nobr></td>
        </tr>
		<tbody id="unitAuto"<?php echo $display2?>>
        <tr>
          <td class="zeile2">
          <label class="fieldLabel"><?php echo text('user_units')?>:</label><p /><a href="javascript:switchtroops();" title="<?php echo text('user_manu_hint')?>"><?php echo text('user_manu')?> <img src="img/external.gif"></a>
          </td>
		  <td colspan="3">
		  	<textarea name="truppen_regex" class="ibox" style="width:250px; height:100px;"></textarea>
		  	<a href="javascript:void(0)" onmouseover="return overlib('<?php echo text('user_hilfe_regex')?>');" onmouseout="return nd();">?</a>
		  </td>
		</tr>
		</tbody>
		<tbody id="unitManual"<?php echo $display?>>
		<tr>
          <td class="zeile2" rowspan="10">
          <label class="fieldLabel"><?php echo text('user_units')?>:</label><p /><a href="javascript:switchtroops();" title="<?php echo text('user_auto_hint')?>"><?php echo text('user_auto')?> <img src="img/external.gif"></a>
          </td>
<?php
  for($i=1; $i<=10; $i++) {

  	if($i>1) { echo "<tr>\n"; }
	echo "<td width=\"20\"><img src=\"".img_pfad($volk, $i)."\" title=\"".text('t_'.$volk.$i)."\">";
	echo "<td width=\"170\" align=\"left\">".text('t_'.$volk.$i).":</td>";
	echo "<td width=\"110\" align=\"right\"><input class=\"ibox f80\" type=\"text\" maxlength=\"5\" name=\"t".$i."\" value=\"".$t[$i]."\"></td>";
  	echo "\n</tr>";
  }
?>
		</tbody>
		<tr>
        	<td colspan="4" class="footer"><input class="submit" type="submit" value="<?php echo text('save')?>"></td>
        </tr>
    </table>
  </form>
</div></div></div>

</div>

</body>
</html>